/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.diagnostics.adapters.providers;

import com.intellij.codeInsight.lookup.LookupElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.AnalyzedFullLineProposal;
import org.jetbrains.completion.full.line.ComposedContext;
import org.jetbrains.completion.full.line.FullLineProposal;
import org.jetbrains.completion.full.line.LocalInferenceType;
import org.jetbrains.completion.full.line.RawFullLineProposal;
import org.jetbrains.completion.full.line.platform.DiagnosableProposalTransformer;
import org.jetbrains.completion.full.line.platform.diagnostics.FullLineSessionLogger;
import org.jetbrains.completion.full.line.platform.diagnostics.adapters.providers.DebugProvidersDiagnostic;
import org.jetbrains.completion.full.line.platform.diagnostics.adapters.providers.ProvidersDiagnosticCallback;
import org.jetbrains.completion.full.line.platform.request.pipeline.FullLineMerger;
import org.jetbrains.completion.full.line.providers.FullLineCompletionProvider;
import org.jetbrains.completion.full.line.relevance.RelevanceModelResponse;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u001a\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J$\u0010\u001d\u001a\u00020\t2\u001a\u0010\u001e\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020 \u0012\u0006\u0012\u0004\u0018\u00010!0\u001f0\u000bH\u0016J$\u0010\"\u001a\u00020\t2\u001a\u0010\u001e\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020 \u0012\u0006\u0012\u0004\u0018\u00010!0\u001f0\u000bH\u0016J4\u0010#\u001a\u00020\t2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u000b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020 0\u000b2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0015H\u0016J8\u0010(\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020)0\u000b2\u0018\u0010*\u001a\u0014\u0012\u0004\u0012\u00020)\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u000b0+2\u0006\u0010'\u001a\u00020\u0015H\u0016J\u0010\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.H\u0016J$\u0010/\u001a\u00020\t2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u000b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020 0\u000bH\u0016J\u0010\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\u0015H\u0016J\u0016\u00102\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020)0\u000bH\u0016J\u0018\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\fH\u0016J\u0016\u00105\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\b\u00106\u001a\u00020\tH\u0016J\f\u00107\u001a\u00020\u0015*\u00020\fH\u0002J\f\u00107\u001a\u00020\u0015*\u00020)H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/adapters/providers/DebugProvidersDiagnostic;", "Lorg/jetbrains/completion/full/line/platform/diagnostics/adapters/providers/ProvidersDiagnosticCallback;", "logger", "Lorg/jetbrains/completion/full/line/platform/diagnostics/FullLineSessionLogger;", "(Lorg/jetbrains/completion/full/line/platform/diagnostics/FullLineSessionLogger;)V", "isDebugEnabled", "", "()Z", "addCachedProposals", "", "proposals", "", "Lorg/jetbrains/completion/full/line/AnalyzedFullLineProposal;", "addComposedContext", "context", "Lorg/jetbrains/completion/full/line/ComposedContext;", "addFilterModelResponse", "response", "Lorg/jetbrains/completion/full/line/relevance/RelevanceModelResponse;", "addSkipReason", "reason", "", "addTriggerModelResponse", "addingStandardResult", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "analyzed", "timeToAnalyzeAll", "", "filteredAnalyzed", "items", "Lkotlin/Pair;", "Lorg/jetbrains/completion/full/line/FullLineProposal;", "Lorg/jetbrains/completion/full/line/platform/request/pipeline/FullLineMerger$FilterReason;", "filteredRaw", "filteringStep", "before", "after", "filterType", "description", "groupingStep", "Lorg/jetbrains/completion/full/line/RawFullLineProposal;", "grouped", "", "mapper", "mapperDiagnostics", "Lorg/jetbrains/completion/full/line/platform/DiagnosableProposalTransformer$MapperDiagnostics;", "mappings", "message", "text", "pipelineStartsWith", "proposalAnalyzed", "proposal", "resultProposals", "silentCompletion", "describe", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nDebugProvidersDiagnostic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugProvidersDiagnostic.kt\norg/jetbrains/completion/full/line/platform/diagnostics/adapters/providers/DebugProvidersDiagnostic\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n1#2:170\n766#3:171\n857#3,2:172\n766#3:174\n857#3,2:175\n1549#3:177\n1620#3,3:178\n*S KotlinDebug\n*F\n+ 1 DebugProvidersDiagnostic.kt\norg/jetbrains/completion/full/line/platform/diagnostics/adapters/providers/DebugProvidersDiagnostic\n*L\n62#1:171\n62#1:172,2\n90#1:174\n90#1:175,2\n94#1:177\n94#1:178,3\n*E\n"})
public final class DebugProvidersDiagnostic
implements ProvidersDiagnosticCallback {
    @NotNull
    private final FullLineSessionLogger logger;
    private final boolean isDebugEnabled;

    public DebugProvidersDiagnostic(@NotNull FullLineSessionLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.logger = logger2;
        this.isDebugEnabled = this.logger.isDebugEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    @Override
    public void resultProposals(@NotNull List<AnalyzedFullLineProposal> proposals) {
        Intrinsics.checkNotNullParameter(proposals, (String)"proposals");
        if (!this.isDebugEnabled()) {
            return;
        }
        this.message("Result proposals:\n" + CollectionsKt.joinToString$default((Iterable)proposals, (CharSequence)"\n", null, null, (int)0, null, (Function1)resultProposals.1.INSTANCE, (int)30, null));
        this.logger.resultProposals(proposals);
    }

    @Override
    public void addCachedProposals(@NotNull List<AnalyzedFullLineProposal> proposals) {
        Intrinsics.checkNotNullParameter(proposals, (String)"proposals");
        this.logger.addCachedProposals(proposals);
    }

    @Override
    public void message(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.logger.debug(text);
    }

    @Override
    public void addingStandardResult(@NotNull LookupElement element, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (!this.isDebugEnabled()) {
            return;
        }
        this.message("Standard proposal \"" + element.getLookupString() + "\" filtered out: " + reason);
    }

    @Override
    public void pipelineStartsWith(@NotNull List<RawFullLineProposal> proposals) {
        Intrinsics.checkNotNullParameter(proposals, (String)"proposals");
        if (!this.isDebugEnabled()) {
            return;
        }
        this.message("Got " + proposals.size() + " raw full line proposals");
        Iterator iterator2 = ((Iterable)proposals).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        RawFullLineProposal it = (RawFullLineProposal)iterator2.next();
        boolean bl = false;
        int n = it.getSuggestion().length();
        while (iterator2.hasNext()) {
            RawFullLineProposal it2 = (RawFullLineProposal)iterator2.next();
            $i$a$-maxOf-DebugProvidersDiagnostic$pipelineStartsWith$longest$1 = false;
            int n2 = it2.getSuggestion().length();
            if (n >= n2) continue;
            n = n2;
        }
        int longest = n;
        for (RawFullLineProposal proposal : proposals) {
            this.message("\t" + StringsKt.padEnd$default((String)proposal.getSuggestion(), (int)longest, (char)'\u0000', (int)2, null) + " [" + this.describe(proposal) + "]");
        }
        this.logger.pipelineStartsWith(proposals);
    }

    @Override
    public void filteringStep(@NotNull List<? extends FullLineProposal> before, @NotNull List<? extends FullLineProposal> after, @NotNull String filterType, @NotNull String description) {
        Intrinsics.checkNotNullParameter(before, (String)"before");
        Intrinsics.checkNotNullParameter(after, (String)"after");
        Intrinsics.checkNotNullParameter((Object)filterType, (String)"filterType");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        if (!this.isDebugEnabled()) {
            return;
        }
        if (before.size() == after.size()) {
            return;
        }
        this.message("Some elements were filtered out due to " + description + ":");
        Set afterSet = CollectionsKt.toSet((Iterable)after);
        for (FullLineProposal fullLineProposal : before) {
            if (afterSet.contains(fullLineProposal)) continue;
            this.message("\t" + fullLineProposal.getSuggestion());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mappings(@NotNull List<? extends FullLineProposal> before, @NotNull List<? extends FullLineProposal> after) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(before, (String)"before");
        Intrinsics.checkNotNullParameter(after, (String)"after");
        if (!this.isDebugEnabled()) {
            return;
        }
        Iterable $this$filter$iv = CollectionsKt.zip((Iterable)before, (Iterable)after);
        boolean $i$f$filter = false;
        Iterator iterator22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)((FullLineProposal)it.getFirst()).getSuggestion(), (Object)((FullLineProposal)it.getSecond()).getSuggestion()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List changes = (List)destination$iv$iv;
        if (!((Collection)changes).isEmpty()) {
            iterator22 = ((Iterable)changes).iterator();
            if (!iterator22.hasNext()) {
                throw new NoSuchElementException();
            }
            Pair it22 = (Pair)iterator22.next();
            boolean bl = false;
            int it22 = ((FullLineProposal)it22.getFirst()).getSuggestion().length();
            while (iterator22.hasNext()) {
                Pair it32 = (Pair)iterator22.next();
                $i$a$-maxOf-DebugProvidersDiagnostic$mappings$longest$1 = false;
                int it32 = ((FullLineProposal)it32.getFirst()).getSuggestion().length();
                if (it22 >= it32) continue;
                it22 = it32;
            }
            int longest = it22;
            this.message("Some elements were transformed due to Mapping");
            for (Iterator iterator22 : changes) {
                FullLineProposal b = (FullLineProposal)iterator22.component1();
                FullLineProposal a = (FullLineProposal)iterator22.component2();
                this.message("\t" + StringsKt.padEnd$default((String)b.getSuggestion(), (int)longest, (char)'\u0000', (int)2, null) + " -> " + a.getSuggestion());
            }
        }
        this.logger.mappings(before, after);
    }

    @Override
    public void mapper(@NotNull DiagnosableProposalTransformer.MapperDiagnostics mapperDiagnostics) {
        Intrinsics.checkNotNullParameter((Object)mapperDiagnostics, (String)"mapperDiagnostics");
        if (!this.isDebugEnabled()) {
            return;
        }
        String name = mapperDiagnostics.getName();
        String string = "%.3f";
        Object[] objectArray = new Object[]{mapperDiagnostics.getTotalTimeMs()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String totalTimeMs = string2;
        int transformedNumber = mapperDiagnostics.getMappings().size();
        int totalInvocations = mapperDiagnostics.getInvocations();
        this.message("Mapper '" + name + "' took " + totalTimeMs + "ms and transformed " + transformedNumber + " out of " + totalInvocations + " variants");
        this.logger.mapper(mapperDiagnostics);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void groupingStep(@NotNull List<RawFullLineProposal> proposals, @NotNull Map<RawFullLineProposal, ? extends List<RawFullLineProposal>> grouped, @NotNull String description) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(proposals, (String)"proposals");
        Intrinsics.checkNotNullParameter(grouped, (String)"grouped");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        if (!this.isDebugEnabled()) {
            return;
        }
        Iterable $this$filter$iv = grouped.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(((List)it.getValue()).size() != 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List merges = (List)destination$iv$iv;
        if (!((Collection)merges).isEmpty()) {
            this.message("Some elements were grouped due to " + description);
            for (Map.Entry entry : merges) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object element$iv$iv;
                RawFullLineProposal to = (RawFullLineProposal)entry.getKey();
                List from = (List)entry.getValue();
                Iterable $i$f$filterTo2 = from;
                String string = to.getSuggestion();
                DebugProvidersDiagnostic debugProvidersDiagnostic = this;
                boolean $i$f$map = false;
                element$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    RawFullLineProposal rawFullLineProposal = (RawFullLineProposal)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(it.getSuggestion());
                }
                collection = (List)destination$iv$iv2;
                debugProvidersDiagnostic.message("\t" + string + " <- " + (List)collection);
            }
        }
        this.logger.groups(grouped);
    }

    @Override
    public void filteredRaw(@NotNull List<? extends Pair<? extends FullLineProposal, FullLineMerger.FilterReason>> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.logger.filteredRaw(items);
    }

    @Override
    public void proposalAnalyzed(@NotNull RawFullLineProposal proposal, @NotNull AnalyzedFullLineProposal analyzed2) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        Intrinsics.checkNotNullParameter((Object)analyzed2, (String)"analyzed");
        if (!this.isDebugEnabled()) {
            return;
        }
        this.message("Analyzing in parallel \"" + proposal.getSuggestion() + "\" took " + analyzed2.getDetails().getChecksTime() + " ms: [" + this.describe(analyzed2) + "]");
    }

    @Override
    public void analyzed(@NotNull List<AnalyzedFullLineProposal> proposals, long timeToAnalyzeAll) {
        Intrinsics.checkNotNullParameter(proposals, (String)"proposals");
        if (!this.isDebugEnabled()) {
            return;
        }
        this.logger.analyzed(proposals);
        this.message("Analyzing for all " + proposals.size() + " suggestions took " + timeToAnalyzeAll + " ms");
    }

    @Override
    public void filteredAnalyzed(@NotNull List<? extends Pair<? extends FullLineProposal, FullLineMerger.FilterReason>> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.logger.filteredAnalyzed(items);
    }

    @Override
    public void addTriggerModelResponse(@NotNull RelevanceModelResponse response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        this.logger.triggerModelResponse(response2);
    }

    @Override
    public void addFilterModelResponse(@NotNull RelevanceModelResponse response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        this.logger.filterModelResponse(response2);
    }

    public final void addSkipReason(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.logger.skipReason(reason);
    }

    @Override
    public void addComposedContext(@NotNull ComposedContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.logger.composedContext(context2);
    }

    private final String describe(RawFullLineProposal $this$describe) {
        Object it;
        StringBuilder stringBuilder;
        StringBuilder $this$describe_u24lambda_u249 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$describe_u24lambda_u249.append("score: " + $this$describe.getScore());
        Class<? extends FullLineCompletionProvider> clazz = $this$describe.getDetails().getProvider();
        if (clazz != null) {
            it = clazz;
            boolean bl2 = false;
            $this$describe_u24lambda_u249.append(", provider: " + it);
        }
        LocalInferenceType localInferenceType = $this$describe.getDetails().getLocalInferenceType();
        if (localInferenceType != null) {
            it = localInferenceType;
            boolean bl3 = false;
            $this$describe_u24lambda_u249.append(", localInferenceType: " + it);
        }
        Integer n = $this$describe.getDetails().getCacheHitLength();
        if (n != null) {
            int it2 = ((Number)n).intValue();
            boolean bl4 = false;
            $this$describe_u24lambda_u249.append(", cacheHitLength: " + it2);
        }
        Integer n2 = $this$describe.getDetails().getCacheExtensionLength();
        if (n2 != null) {
            int it3 = ((Number)n2).intValue();
            boolean bl5 = false;
            $this$describe_u24lambda_u249.append(", cacheExtensionLength: " + it3);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public void silentCompletion() {
        this.message("Silent completion");
        this.logger.silentCompletion();
    }

    private final String describe(AnalyzedFullLineProposal $this$describe) {
        return "correctness: " + $this$describe.getCorrectnessState() + ", suffix: " + $this$describe.getSuffix();
    }
}

