/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.diagnostics;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.AnalyzedFullLineProposal;
import org.jetbrains.completion.full.line.ComposedContext;
import org.jetbrains.completion.full.line.FullLineProposal;
import org.jetbrains.completion.full.line.RawFullLineProposal;
import org.jetbrains.completion.full.line.platform.CompletionId;
import org.jetbrains.completion.full.line.platform.DiagnosableProposalTransformer;
import org.jetbrains.completion.full.line.platform.NativeServerId;
import org.jetbrains.completion.full.line.platform.diagnostics.AddCachedProposals;
import org.jetbrains.completion.full.line.platform.diagnostics.Analyzed;
import org.jetbrains.completion.full.line.platform.diagnostics.ConnectionAddress;
import org.jetbrains.completion.full.line.platform.diagnostics.ContextMessage;
import org.jetbrains.completion.full.line.platform.diagnostics.DiagnosticsListener;
import org.jetbrains.completion.full.line.platform.diagnostics.DiagnosticsLog;
import org.jetbrains.completion.full.line.platform.diagnostics.FilterModelMessage;
import org.jetbrains.completion.full.line.platform.diagnostics.FilteredAnalyzed;
import org.jetbrains.completion.full.line.platform.diagnostics.FilteredRaw;
import org.jetbrains.completion.full.line.platform.diagnostics.FullLineLogger;
import org.jetbrains.completion.full.line.platform.diagnostics.FullLineNativeServerLogger;
import org.jetbrains.completion.full.line.platform.diagnostics.FullLinePart;
import org.jetbrains.completion.full.line.platform.diagnostics.FullLineSessionLogger;
import org.jetbrains.completion.full.line.platform.diagnostics.Grouped;
import org.jetbrains.completion.full.line.platform.diagnostics.GrpcChannelState;
import org.jetbrains.completion.full.line.platform.diagnostics.LogKt;
import org.jetbrains.completion.full.line.platform.diagnostics.LogMessage;
import org.jetbrains.completion.full.line.platform.diagnostics.Mapper;
import org.jetbrains.completion.full.line.platform.diagnostics.Mappings;
import org.jetbrains.completion.full.line.platform.diagnostics.NativeServerMessage;
import org.jetbrains.completion.full.line.platform.diagnostics.PipelineStartsWith;
import org.jetbrains.completion.full.line.platform.diagnostics.ProcessStarted;
import org.jetbrains.completion.full.line.platform.diagnostics.ProcessTerminated;
import org.jetbrains.completion.full.line.platform.diagnostics.ResultProposals;
import org.jetbrains.completion.full.line.platform.diagnostics.SessionMessage;
import org.jetbrains.completion.full.line.platform.diagnostics.SilentCompletion;
import org.jetbrains.completion.full.line.platform.diagnostics.SkipReason;
import org.jetbrains.completion.full.line.platform.diagnostics.TextMessage;
import org.jetbrains.completion.full.line.platform.diagnostics.TriggerModelMessage;
import org.jetbrains.completion.full.line.platform.request.pipeline.FullLineMerger;
import org.jetbrains.completion.full.line.relevance.RelevanceModelResponse;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bR!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsService;", "", "()V", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "logger", "Lorg/jetbrains/completion/full/line/platform/diagnostics/FullLineLogger;", "part", "Lorg/jetbrains/completion/full/line/platform/diagnostics/FullLinePart;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "nativeServerLogger", "Lorg/jetbrains/completion/full/line/platform/diagnostics/FullLineNativeServerLogger;", "fullLineLogger", "serverId", "Lorg/jetbrains/completion/full/line/platform/NativeServerId;", "sessionLogger", "Lorg/jetbrains/completion/full/line/platform/diagnostics/FullLineSessionLogger;", "completionId", "Lorg/jetbrains/completion/full/line/platform/CompletionId;", "subscribe", "", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "Companion", "intellij.fullLine"})
public final class DiagnosticsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventDispatcher<DiagnosticsListener> dispatcher;

    public DiagnosticsService() {
        EventDispatcher eventDispatcher = EventDispatcher.create(DiagnosticsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.dispatcher = eventDispatcher;
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.dispatcher.addListener((EventListener)new DiagnosticsListener(){
                @NotNull
                private final DiagnosticsLog console = ApplicationManager.getApplication().isUnitTestMode() ? (DiagnosticsLog)new DiagnosticsLog.Test() : (DiagnosticsLog)new DiagnosticsLog.InMemory();

                @NotNull
                public final DiagnosticsLog getConsole() {
                    return this.console;
                }

                @Override
                public void messageReceived(@NotNull LogMessage message) {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    if (message instanceof TextMessage) {
                        this.console.addMessage((TextMessage)message);
                    }
                }
            });
        }
    }

    public final void subscribe(@NotNull DiagnosticsListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.dispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @NotNull
    public final FullLineLogger logger(@NotNull FullLinePart part, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)((Object)part), (String)"part");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        return new FullLineLogger(log, this, part){
            private final boolean isDebugEnabled;
            final /* synthetic */ Logger $log;
            final /* synthetic */ DiagnosticsService this$0;
            final /* synthetic */ FullLinePart $part;
            {
                this.$log = $log;
                this.this$0 = $receiver;
                this.$part = $part;
                this.isDebugEnabled = $log.isDebugEnabled() || DiagnosticsService.access$getDispatcher$p($receiver).hasListeners();
            }

            public void error(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$log.error(throwable);
            }

            public void debug(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.onTextMessage(text, (Function1<? super Logger, Unit>)((Function1)new Function1<Logger, Unit>(text){
                    final /* synthetic */ String $text;
                    {
                        this.$text = $text;
                        super(1);
                    }

                    public final void invoke(@NotNull Logger $this$onTextMessage) {
                        Intrinsics.checkNotNullParameter((Object)$this$onTextMessage, (String)"$this$onTextMessage");
                        $this$onTextMessage.debug(this.$text);
                    }
                }));
            }

            public void info(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.onTextMessage(text, (Function1<? super Logger, Unit>)((Function1)new Function1<Logger, Unit>(text){
                    final /* synthetic */ String $text;
                    {
                        this.$text = $text;
                        super(1);
                    }

                    public final void invoke(@NotNull Logger $this$onTextMessage) {
                        Intrinsics.checkNotNullParameter((Object)$this$onTextMessage, (String)"$this$onTextMessage");
                        $this$onTextMessage.info(this.$text);
                    }
                }));
            }

            public void debug(@NotNull String text, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.onTextMessage(text, (Function1<? super Logger, Unit>)((Function1)new Function1<Logger, Unit>(text, throwable){
                    final /* synthetic */ String $text;
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$text = $text;
                        this.$throwable = $throwable;
                        super(1);
                    }

                    public final void invoke(@NotNull Logger $this$onTextMessage) {
                        Intrinsics.checkNotNullParameter((Object)$this$onTextMessage, (String)"$this$onTextMessage");
                        $this$onTextMessage.debug(this.$text, this.$throwable);
                    }
                }));
            }

            public void warn(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.onTextMessage(text, (Function1<? super Logger, Unit>)((Function1)new Function1<Logger, Unit>(text){
                    final /* synthetic */ String $text;
                    {
                        this.$text = $text;
                        super(1);
                    }

                    public final void invoke(@NotNull Logger $this$onTextMessage) {
                        Intrinsics.checkNotNullParameter((Object)$this$onTextMessage, (String)"$this$onTextMessage");
                        $this$onTextMessage.warn(this.$text);
                    }
                }));
            }

            public void warn(@NotNull String text, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.onTextMessage(text, (Function1<? super Logger, Unit>)((Function1)new Function1<Logger, Unit>(text, throwable){
                    final /* synthetic */ String $text;
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$text = $text;
                        this.$throwable = $throwable;
                        super(1);
                    }

                    public final void invoke(@NotNull Logger $this$onTextMessage) {
                        Intrinsics.checkNotNullParameter((Object)$this$onTextMessage, (String)"$this$onTextMessage");
                        $this$onTextMessage.warn(this.$text, this.$throwable);
                    }
                }));
            }

            private final void onTextMessage(String text, Function1<? super Logger, Unit> block) {
                block.invoke((Object)this.$log);
                if (!DiagnosticsService.access$getDispatcher$p(this.this$0).hasListeners()) {
                    return;
                }
                TextMessage message = new TextMessage(text, System.currentTimeMillis(), this.$part);
                ((DiagnosticsListener)DiagnosticsService.access$getDispatcher$p(this.this$0).getMulticaster()).messageReceived(message);
            }

            public boolean isDebugEnabled() {
                return this.isDebugEnabled;
            }
        };
    }

    public static /* synthetic */ FullLineLogger logger$default(DiagnosticsService diagnosticsService, FullLinePart fullLinePart, Logger logger2, int n, Object object) {
        if ((n & 2) != 0) {
            logger2 = LogKt.access$getLOG$p();
        }
        return diagnosticsService.logger(fullLinePart, logger2);
    }

    @NotNull
    public final FullLineSessionLogger sessionLogger(@NotNull FullLineLogger fullLineLogger, @NotNull CompletionId completionId) {
        Intrinsics.checkNotNullParameter((Object)fullLineLogger, (String)"fullLineLogger");
        Intrinsics.checkNotNullParameter((Object)completionId, (String)"completionId");
        return (FullLineSessionLogger)new FullLineLogger(fullLineLogger, completionId, this){
            private final /* synthetic */ FullLineLogger $$delegate_0;
            final /* synthetic */ CompletionId $completionId;
            final /* synthetic */ DiagnosticsService this$0;
            {
                this.$completionId = $completionId;
                this.this$0 = $receiver;
                this.$$delegate_0 = $fullLineLogger;
            }

            public boolean isDebugEnabled() {
                return this.$$delegate_0.isDebugEnabled();
            }

            public void debug(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.$$delegate_0.debug(text);
            }

            public void debug(@NotNull String text, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$$delegate_0.debug(text, throwable);
            }

            public void error(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$$delegate_0.error(throwable);
            }

            public void info(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.$$delegate_0.info(text);
            }

            public void warn(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.$$delegate_0.warn(text);
            }

            public void warn(@NotNull String text, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$$delegate_0.warn(text, throwable);
            }

            public void pipelineStartsWith(@NotNull List<RawFullLineProposal> proposals) {
                Intrinsics.checkNotNullParameter(proposals, (String)"proposals");
                this.sendSessionMessage(new PipelineStartsWith(this.$completionId, proposals));
            }

            public void mappings(@NotNull List<? extends FullLineProposal> before, @NotNull List<? extends FullLineProposal> after) {
                Intrinsics.checkNotNullParameter(before, (String)"before");
                Intrinsics.checkNotNullParameter(after, (String)"after");
                this.sendSessionMessage(new Mappings(this.$completionId, before, after));
            }

            public void mapper(@NotNull DiagnosableProposalTransformer.MapperDiagnostics mapperDiagnostics) {
                Intrinsics.checkNotNullParameter((Object)mapperDiagnostics, (String)"mapperDiagnostics");
                this.sendSessionMessage(new Mapper(this.$completionId, mapperDiagnostics));
            }

            public void groups(@NotNull Map<RawFullLineProposal, ? extends List<RawFullLineProposal>> grouped) {
                Intrinsics.checkNotNullParameter(grouped, (String)"grouped");
                this.sendSessionMessage(new Grouped(this.$completionId, grouped));
            }

            public void filteredRaw(@NotNull List<? extends Pair<? extends FullLineProposal, FullLineMerger.FilterReason>> items) {
                Intrinsics.checkNotNullParameter(items, (String)"items");
                this.sendSessionMessage(new FilteredRaw(this.$completionId, items));
            }

            public void analyzed(@NotNull List<AnalyzedFullLineProposal> proposals) {
                Intrinsics.checkNotNullParameter(proposals, (String)"proposals");
                this.sendSessionMessage(new Analyzed(this.$completionId, proposals));
            }

            public void filteredAnalyzed(@NotNull List<? extends Pair<? extends FullLineProposal, FullLineMerger.FilterReason>> items) {
                Intrinsics.checkNotNullParameter(items, (String)"items");
                this.sendSessionMessage(new FilteredAnalyzed(this.$completionId, items));
            }

            public void resultProposals(@NotNull List<AnalyzedFullLineProposal> proposals) {
                Intrinsics.checkNotNullParameter(proposals, (String)"proposals");
                this.sendSessionMessage(new ResultProposals(this.$completionId, proposals));
            }

            public void addCachedProposals(@NotNull List<AnalyzedFullLineProposal> proposals) {
                Intrinsics.checkNotNullParameter(proposals, (String)"proposals");
                this.sendSessionMessage(new AddCachedProposals(this.$completionId, proposals));
            }

            public void triggerModelResponse(@NotNull RelevanceModelResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                this.sendSessionMessage(new TriggerModelMessage(this.$completionId, response2));
            }

            public void filterModelResponse(@NotNull RelevanceModelResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                this.sendSessionMessage(new FilterModelMessage(this.$completionId, response2));
            }

            public void skipReason(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                this.sendSessionMessage(new SkipReason(this.$completionId, reason));
            }

            public void silentCompletion() {
                this.sendSessionMessage(new SilentCompletion(this.$completionId));
            }

            public void composedContext(@NotNull ComposedContext context2) {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                this.sendSessionMessage(new ContextMessage(this.$completionId, context2));
            }

            private final void sendSessionMessage(SessionMessage sessionMessage) {
                if (!DiagnosticsService.access$getDispatcher$p(this.this$0).hasListeners()) {
                    return;
                }
                ((DiagnosticsListener)DiagnosticsService.access$getDispatcher$p(this.this$0).getMulticaster()).messageReceived(sessionMessage);
            }
        };
    }

    @NotNull
    public final FullLineNativeServerLogger nativeServerLogger(@NotNull FullLineLogger fullLineLogger, @NotNull NativeServerId serverId) {
        Intrinsics.checkNotNullParameter((Object)fullLineLogger, (String)"fullLineLogger");
        Intrinsics.checkNotNullParameter((Object)serverId, (String)"serverId");
        return new FullLineNativeServerLogger(fullLineLogger, serverId, this){
            private final /* synthetic */ FullLineLogger $$delegate_0;
            final /* synthetic */ NativeServerId $serverId;
            final /* synthetic */ DiagnosticsService this$0;
            {
                this.$serverId = $serverId;
                this.this$0 = $receiver;
                this.$$delegate_0 = $fullLineLogger;
            }

            public boolean isDebugEnabled() {
                return this.$$delegate_0.isDebugEnabled();
            }

            public void debug(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.$$delegate_0.debug(text);
            }

            public void debug(@NotNull String text, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$$delegate_0.debug(text, throwable);
            }

            public void error(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$$delegate_0.error(throwable);
            }

            public void info(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.$$delegate_0.info(text);
            }

            public void warn(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.$$delegate_0.warn(text);
            }

            public void warn(@NotNull String text, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$$delegate_0.warn(text, throwable);
            }

            public void grpcChannelState(@NotNull String state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                this.sendNativeServerMessage(new GrpcChannelState(this.$serverId, state));
            }

            public void processStarted() {
                this.sendNativeServerMessage(new ProcessStarted(this.$serverId));
            }

            public void processTerminated(int exitCode) {
                this.sendNativeServerMessage(new ProcessTerminated(this.$serverId, exitCode));
            }

            public void connectionAddress(@NotNull String hostname, int port) {
                Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
                this.sendNativeServerMessage(new ConnectionAddress(this.$serverId, hostname, port));
            }

            private final void sendNativeServerMessage(NativeServerMessage nativeServerMessage) {
                if (!DiagnosticsService.access$getDispatcher$p(this.this$0).hasListeners()) {
                    return;
                }
                ((DiagnosticsListener)DiagnosticsService.access$getDispatcher$p(this.this$0).getMulticaster()).messageReceived(nativeServerMessage);
            }
        };
    }

    public static final /* synthetic */ EventDispatcher access$getDispatcher$p(DiagnosticsService $this) {
        return $this.dispatcher;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsService$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsService;", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nlog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 log.kt\norg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,220:1\n42#2,3:221\n*S KotlinDebug\n*F\n+ 1 log.kt\norg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsService$Companion\n*L\n216#1:221,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DiagnosticsService getInstance() {
            boolean $i$f$service = false;
            Class<DiagnosticsService> serviceClass$iv = DiagnosticsService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (DiagnosticsService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

