/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.diagnostics;

import com.intellij.diagnostic.logging.DefaultLogFilterModel;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogConsolePreferences;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.text.DateFormatUtil;
import java.io.File;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.platform.diagnostics.FullLinePart;
import org.jetbrains.completion.full.line.platform.diagnostics.LineAppendableReader;
import org.jetbrains.completion.full.line.platform.diagnostics.TextMessage;
import org.jetbrains.completion.full.line.settings.FullLineBundle;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \b2\u00020\u0001:\u0005\b\t\n\u000b\fJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u0082\u0001\u0003\r\u000e\u000f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsLog;", "", "addMessage", "", "message", "Lorg/jetbrains/completion/full/line/platform/diagnostics/TextMessage;", "prepareMessage", "", "Companion", "Console", "InMemory", "LogFilterModel", "Test", "Lorg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsLog$Console;", "Lorg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsLog$InMemory;", "Lorg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsLog$Test;", "intellij.fullLine"})
public interface DiagnosticsLog {
    public static final /* synthetic */ Companion Companion;

    public void addMessage(@NotNull TextMessage var1);

    @NotNull
    default public String prepareMessage(@NotNull TextMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = DateFormatUtil.formatTime((long)message.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatTime(...)");
        String time = string;
        String part = StringsKt.padStart$default((String)message.getPart().toString(), (int)Companion.getPAD_COUNT(), (char)'\u0000', (int)2, null);
        return "[ " + time + " | " + part + " ] " + message.getText();
    }

    static {
        Companion = org.jetbrains.completion.full.line.platform.diagnostics.DiagnosticsLog$Companion.$$INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsLog$Companion;", "", "()V", "PAD_COUNT", "", "getPAD_COUNT", "()I", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nDiagnosticsLogConsole.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticsLogConsole.kt\norg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsLog$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1#2:151\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static final int PAD_COUNT;

        private Companion() {
        }

        public final int getPAD_COUNT() {
            return PAD_COUNT;
        }

        static {
            $$INSTANCE = new Companion();
            Iterator iterator2 = ((Iterable)FullLinePart.getEntries()).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            FullLinePart it = (FullLinePart)((Object)iterator2.next());
            boolean bl = false;
            int n = it.name().length();
            while (iterator2.hasNext()) {
                FullLinePart it2 = (FullLinePart)((Object)iterator2.next());
                $i$a$-maxOf-DiagnosticsLog$Companion$PAD_COUNT$1 = false;
                int n2 = it2.name().length();
                if (n >= n2) continue;
                n = n2;
            }
            PAD_COUNT = n;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsLog$Console;", "Lcom/intellij/diagnostic/logging/LogConsoleBase;", "Lorg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsLog;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "reader", "Lorg/jetbrains/completion/full/line/platform/diagnostics/LineAppendableReader;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/completion/full/line/platform/diagnostics/LineAppendableReader;)V", "isDisposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "addMessage", "", "message", "Lorg/jetbrains/completion/full/line/platform/diagnostics/TextMessage;", "dispose", "isActive", "", "intellij.fullLine"})
    public static final class Console
    extends LogConsoleBase
    implements DiagnosticsLog {
        @NotNull
        private final LineAppendableReader reader;
        @NotNull
        private final AtomicBoolean isDisposed;

        private Console(Project project, LineAppendableReader reader) {
            super(project, (Reader)reader, FullLineBundle.Companion.message("full.line.diagnostics.tab.title", new Object[0]), true, (com.intellij.diagnostic.logging.LogFilterModel)new LogFilterModel(project));
            this.reader = reader;
            this.isDisposed = new AtomicBoolean(false);
        }

        public Console(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this(project, new LineAppendableReader());
        }

        public boolean isActive() {
            return true;
        }

        @Override
        public void addMessage(@NotNull TextMessage message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (!this.isDisposed.get()) {
                this.reader.appendLine(this.prepareMessage(message));
            }
        }

        public void dispose() {
            super.dispose();
            this.isDisposed.set(true);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsLog$InMemory;", "Lorg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsLog;", "()V", "logFile", "Ljava/io/File;", "addMessage", "", "message", "Lorg/jetbrains/completion/full/line/platform/diagnostics/TextMessage;", "appendToFile", "", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nDiagnosticsLogConsole.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticsLogConsole.kt\norg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsLog$InMemory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1#2:151\n*E\n"})
    public static final class InMemory
    implements DiagnosticsLog {
        @Nullable
        private final File logFile;

        /*
         * WARNING - void declaration
         */
        public InMemory() {
            File file2;
            void it;
            RegistryValue registryValue;
            RegistryValue registryValue2 = registryValue = Registry.get((String)"full.line.diagnostics.file");
            InMemory inMemory = this;
            boolean bl3 = false;
            boolean bl2 = it.isChangedFromDefault();
            InMemory inMemory2 = inMemory;
            Object object = bl2 ? registryValue : null;
            if (object != null && (object = object.asString()) != null) {
                void it2;
                Object bl3 = object;
                inMemory = inMemory2;
                boolean bl4 = false;
                file2 = new File((String)it2);
                inMemory2 = inMemory;
            } else {
                file2 = null;
            }
            inMemory2.logFile = file2;
            File file3 = this.logFile;
            boolean bl5 = file3 != null ? !file3.exists() : false;
            if (bl5) {
                this.logFile.getParentFile().mkdirs();
                this.logFile.createNewFile();
            }
        }

        @Override
        public void addMessage(@NotNull TextMessage message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            String msg = this.prepareMessage(message) + "\n";
            this.appendToFile(msg);
        }

        private final void appendToFile(String message) {
            block0: {
                File file2 = this.logFile;
                if (file2 == null) break block0;
                FilesKt.appendText$default((File)file2, (String)message, null, (int)2, null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsLog$LogFilterModel;", "Lcom/intellij/diagnostic/logging/DefaultLogFilterModel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isApplicable", "", "line", "", "processLine", "Lcom/intellij/diagnostic/logging/LogFilterModel$MyProcessingResult;", "intellij.fullLine"})
    private static final class LogFilterModel
    extends DefaultLogFilterModel {
        public LogFilterModel(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project);
        }

        public boolean isApplicable(@Nullable String line2) {
            return true;
        }

        @NotNull
        public LogFilterModel.MyProcessingResult processLine(@Nullable String line2) {
            return new LogFilterModel.MyProcessingResult(LogConsolePreferences.getProcessOutputTypes((String)"INFO"), true, "");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsLog$Test;", "Lorg/jetbrains/completion/full/line/platform/diagnostics/DiagnosticsLog;", "()V", "shouldLog", "", "addMessage", "", "message", "Lorg/jetbrains/completion/full/line/platform/diagnostics/TextMessage;", "intellij.fullLine"})
    public static final class Test
    implements DiagnosticsLog {
        private final boolean shouldLog;

        @Override
        public void addMessage(@NotNull TextMessage message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (!this.shouldLog) {
                return;
            }
            String msg = this.prepareMessage(message);
            System.out.println((Object)msg);
        }
    }
}

