/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.ProposalsFilter;
import org.jetbrains.completion.full.line.RawFullLineProposal;
import org.jetbrains.completion.full.line.platform.HighEntropyFilter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B'\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/completion/full/line/platform/HighEntropyFilter;", "Lorg/jetbrains/completion/full/line/ProposalsFilter$Adapter;", "lastLine", "", "description", "charset", "limit", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;D)V", "secretRegexp", "Lkotlin/text/Regex;", "calculateShannonEntropy", "str", "checkRawFullLine", "", "proposal", "Lorg/jetbrains/completion/full/line/RawFullLineProposal;", "Base64", "Hex", "Lorg/jetbrains/completion/full/line/platform/HighEntropyFilter$Base64;", "Lorg/jetbrains/completion/full/line/platform/HighEntropyFilter$Hex;", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nHighEntropyFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighEntropyFilter.kt\norg/jetbrains/completion/full/line/platform/HighEntropyFilter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,77:1\n1247#2,2:78\n1099#3,3:80\n*S KotlinDebug\n*F\n+ 1 HighEntropyFilter.kt\norg/jetbrains/completion/full/line/platform/HighEntropyFilter\n*L\n20#1:78,2\n26#1:80,3\n*E\n"})
public abstract class HighEntropyFilter
extends ProposalsFilter.Adapter {
    @NotNull
    private final String lastLine;
    @NotNull
    private final String charset;
    private final double limit;
    @NotNull
    private final Regex secretRegexp;

    private HighEntropyFilter(String lastLine, String description, String charset, double limit) {
        super(description);
        this.lastLine = lastLine;
        this.charset = charset;
        this.limit = limit;
        this.secretRegexp = new Regex("(^|['\"])(?<secret>[" + this.charset + "]+)($|['\"])");
    }

    @Override
    public boolean checkRawFullLine(@NotNull RawFullLineProposal proposal) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
            Sequence $this$any$iv = SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)Regex.findAll$default((Regex)this.secretRegexp, (CharSequence)(this.lastLine + proposal.getSuggestion()), (int)0, (int)2, null), (Function1)checkRawFullLine.1.INSTANCE), (Function1)((Function1)new Function1<String, Double>((Object)this){

                @NotNull
                public final Double invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((HighEntropyFilter)this.receiver).calculateShannonEntropy(p0);
                }
            }));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                double it = ((Number)element$iv).doubleValue();
                boolean bl2 = false;
                if (!(it > this.limit)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return !bl;
    }

    /*
     * WARNING - void declaration
     */
    public double calculateShannonEntropy(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (((CharSequence)str).length() == 0) {
            return 0.0;
        }
        double ln2 = Math.log(2.0);
        CharSequence charSequence = this.charset;
        double d = 0.0;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c;
            char c2 = c = charSequence.charAt(i);
            double d2 = d;
            boolean bl = false;
            CharSequence $this$count$iv = str;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int j = 0; j < $this$count$iv.length(); ++j) {
                void x;
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(j);
                boolean bl2 = false;
                if (!(it == x)) continue;
                ++count$iv;
            }
            double p = (double)count$iv / (double)str.length();
            double d3 = p > 0.0 ? -p * Math.log(p) / ln2 : 0.0;
            d = d2 + d3;
        }
        return d;
    }

    public /* synthetic */ HighEntropyFilter(String lastLine, String description, String charset, double limit, DefaultConstructorMarker $constructor_marker) {
        this(lastLine, description, charset, limit);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/completion/full/line/platform/HighEntropyFilter$Base64;", "Lorg/jetbrains/completion/full/line/platform/HighEntropyFilter;", "lastLine", "", "(Ljava/lang/String;)V", "intellij.fullLine"})
    public static final class Base64
    extends HighEntropyFilter {
        public Base64(@NotNull String lastLine) {
            Intrinsics.checkNotNullParameter((Object)lastLine, (String)"lastLine");
            super(lastLine, "Base64 High Entropy String", CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)((Iterable)new CharRange('0', '9'))), (CharSequence)"", null, null, (int)0, null, null, (int)62, null) + "+/\\-_=", 4.5, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/completion/full/line/platform/HighEntropyFilter$Hex;", "Lorg/jetbrains/completion/full/line/platform/HighEntropyFilter;", "lastLine", "", "(Ljava/lang/String;)V", "calculateShannonEntropy", "", "str", "intellij.fullLine"})
    public static final class Hex
    extends HighEntropyFilter {
        public Hex(@NotNull String lastLine) {
            Intrinsics.checkNotNullParameter((Object)lastLine, (String)"lastLine");
            super(lastLine, "Hex High Entropy String", "0123456789abcdefABCDEF", 3.0, null);
        }

        @Override
        public double calculateShannonEntropy(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            double entropy = super.calculateShannonEntropy(str);
            return entropy - (str.length() < 2 || StringsKt.toIntOrNull((String)str) == null ? 0.0 : 1.2 / Math.log(str.length()) * Math.log(2.0));
        }
    }
}

