/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.FullLineProposalsContext;
import org.jetbrains.completion.full.line.RawFullLineProposal;
import org.jetbrains.completion.full.line.language.enclosure.FullLineEnclosures;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;
import org.jetbrains.completion.full.line.platform.FullLineProposalMatcher;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000eH\u0002J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010*\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/completion/full/line/platform/FullLineProposalMatcher;", "", "languageSupporter", "Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupporter;", "context", "Lorg/jetbrains/completion/full/line/FullLineProposalsContext;", "(Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupporter;Lorg/jetbrains/completion/full/line/FullLineProposalsContext;)V", "enclosures", "Lorg/jetbrains/completion/full/line/language/enclosure/FullLineEnclosures;", "calculateSuffixLength", "", "proposal", "Lorg/jetbrains/completion/full/line/RawFullLineProposal;", "prefix", "", "findSimilarityNeglectingSpaces", "", "lineAfterCompletion", "matchProposalEnd", "matchProposalStart", "tokenize", "Lorg/jetbrains/completion/full/line/platform/FullLineProposalMatcher$MatchToken;", "MatchToken", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nFullLineProposalMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineProposalMatcher.kt\norg/jetbrains/completion/full/line/platform/FullLineProposalMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n766#2:145\n857#2,2:146\n1839#3,14:148\n1#4:162\n*S KotlinDebug\n*F\n+ 1 FullLineProposalMatcher.kt\norg/jetbrains/completion/full/line/platform/FullLineProposalMatcher\n*L\n18#1:145\n18#1:146,2\n35#1:148,14\n*E\n"})
public final class FullLineProposalMatcher {
    @NotNull
    private final FullLineProposalsContext context;
    @NotNull
    private final FullLineEnclosures enclosures;

    public FullLineProposalMatcher(@NotNull FullLineLanguageSupporter languageSupporter, @NotNull FullLineProposalsContext context2) {
        Intrinsics.checkNotNullParameter((Object)languageSupporter, (String)"languageSupporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.enclosures = languageSupporter.getEnclosures();
    }

    public final int matchProposalStart(@NotNull RawFullLineProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        return StringsKt.commonPrefixWith$default((CharSequence)StringsKt.drop((String)proposal.getSuggestion(), (int)this.context.getPrefix().length()), (CharSequence)this.context.getLineAfterOffset(), (boolean)false, (int)2, null).length();
    }

    /*
     * WARNING - void declaration
     */
    public final int matchProposalEnd(@NotNull RawFullLineProposal proposal) {
        int n;
        Integer maxSimilarity2;
        Object v4;
        void $this$minByOrNull$iv;
        List list2;
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        String string = proposal.getDetails().getMatchedAfterOffset();
        int prefixAfterOffsetLength = string != null ? string.length() : 0;
        Set<Integer> set = proposal.getDetails().getMatchedEnclosuresIndices();
        if (set != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!(it < proposal.getSuggestion().length())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List matchedEnclosures = list2;
        Integer n2 = (Integer)CollectionsKt.maxOrNull((Iterable)matchedEnclosures);
        int n3 = n2 != null ? n2 + 1 : 0;
        int suggestionMatchStartOffset = Math.max(prefixAfterOffsetLength, n3);
        String actualLineAfterOffset = StringsKt.drop((String)this.context.getLineAfterOffset(), (int)(prefixAfterOffsetLength + matchedEnclosures.size()));
        List<Integer> similarity = this.findSimilarityNeglectingSpaces(actualLineAfterOffset, proposal.getSuggestion());
        int suggestionWithoutSuffixLength = proposal.getSuggestion().length() - this.calculateSuffixLength(proposal, this.context.getPrefix());
        Sequence $i$f$filterTo = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.drop((Sequence)SequencesKt.withIndex((Sequence)CollectionsKt.asSequence((Iterable)similarity)), (int)(this.context.getPrefix().length() + suggestionMatchStartOffset)), (Function1)((Function1)new Function1<IndexedValue<? extends Integer>, Boolean>(suggestionWithoutSuffixLength){
            final /* synthetic */ int $suggestionWithoutSuffixLength;
            {
                this.$suggestionWithoutSuffixLength = $suggestionWithoutSuffixLength;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IndexedValue<Integer> indexedValue) {
                Intrinsics.checkNotNullParameter(indexedValue, (String)"<name for destructuring parameter 0>");
                int index = indexedValue.component1();
                int score = ((Number)indexedValue.component2()).intValue();
                return index + score >= this.$suggestionWithoutSuffixLength;
            }
        })), (Function1)matchProposalEnd.maxSimilarity.2.INSTANCE);
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v4 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v4 = minElem$iv;
            } else {
                IndexedValue it = (IndexedValue)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getIndex();
                do {
                    Object e$iv = iterator$iv.next();
                    IndexedValue it2 = (IndexedValue)e$iv;
                    $i$a$-minByOrNull-FullLineProposalMatcher$matchProposalEnd$maxSimilarity$3 = false;
                    int v$iv = it2.getIndex();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v4 = minElem$iv;
            }
        }
        IndexedValue indexedValue = v4;
        Integer n4 = maxSimilarity2 = indexedValue != null ? Integer.valueOf(indexedValue.getIndex()) : null;
        if (n4 != null) {
            int index = ((Number)n4).intValue();
            boolean bl = false;
            n = proposal.getSuggestion().length() - index;
        } else {
            n = 0;
        }
        return n;
    }

    private final int calculateSuffixLength(RawFullLineProposal proposal, String prefix2) {
        int length;
        String suggestion = proposal.getSuggestion();
        String string = proposal.getDetails().getMatchedAfterOffset();
        int prefixAfterOffsetLength = string != null ? string.length() : 0;
        int maxLength = suggestion.length() - prefix2.length() - prefixAfterOffsetLength;
        for (length = 0; length < maxLength && this.enclosures.isClose(suggestion.charAt(suggestion.length() - 1 - length)); ++length) {
        }
        return length;
    }

    private final List<Integer> findSimilarityNeglectingSpaces(String lineAfterCompletion2, String proposal) {
        int n;
        List<MatchToken> lineTokens = this.tokenize(lineAfterCompletion2);
        List<MatchToken> proposalTokens = this.tokenize(proposal);
        int length = lineTokens.size() + 1 + proposalTokens.size();
        int[] zTokens = new int[length];
        int l = 0;
        int r = 0;
        for (int i = 1; i < length; ++i) {
            if (i <= r) {
                zTokens[i] = Math.min(r - i + 1, zTokens[i - l]);
            }
            while (i + zTokens[i] < length && Intrinsics.areEqual((Object)FullLineProposalMatcher.findSimilarityNeglectingSpaces$getToken(lineTokens, proposalTokens, zTokens[i]), (Object)FullLineProposalMatcher.findSimilarityNeglectingSpaces$getToken(lineTokens, proposalTokens, i + zTokens[i]))) {
                int n2 = i;
                zTokens[n2] = zTokens[n2] + 1;
                int cfr_ignored_0 = zTokens[n2];
            }
            if (i + zTokens[i] - 1 <= r) continue;
            l = i;
            r = i + zTokens[i] - 1;
        }
        int[] proposalTokensLengthPrefixSum = new int[proposalTokens.size() + 1];
        int n3 = proposalTokens.size();
        for (int i = 0; i < n3; ++i) {
            proposalTokensLengthPrefixSum[i + 1] = proposalTokensLengthPrefixSum[i] + proposalTokens.get(i).getLength();
        }
        n3 = proposal.length();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n3);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n = n4++;
            ArrayList<Integer> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(0);
        }
        List z = arrayList;
        int offsetToProposal = lineTokens.size() + 1;
        int actualIndex = 0;
        n = proposalTokens.size();
        for (int i = 0; i < n; ++i) {
            if (zTokens[i + offsetToProposal] != 0) {
                z.set(actualIndex, proposalTokensLengthPrefixSum[i + zTokens[i + offsetToProposal]] - proposalTokensLengthPrefixSum[i]);
            }
            actualIndex += proposalTokens.get(i).getLength();
        }
        return z;
    }

    private final List<MatchToken> tokenize(String $this$tokenize) {
        List list2;
        List $this$tokenize_u24lambda_u244 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        int index = 0;
        while (index < $this$tokenize.length()) {
            if (FullLineProposalMatcher.tokenize$lambda$4$char($this$tokenize, index) == ' ') {
                int initialIndex = index;
                while (index < $this$tokenize.length() && FullLineProposalMatcher.tokenize$lambda$4$char($this$tokenize, index) == ' ') {
                    ++index;
                }
                ((Collection)$this$tokenize_u24lambda_u244).add(new MatchToken.Spaces(index - initialIndex));
                continue;
            }
            ((Collection)$this$tokenize_u24lambda_u244).add(new MatchToken.Symbol(FullLineProposalMatcher.tokenize$lambda$4$char($this$tokenize, index)));
            ++index;
        }
        return CollectionsKt.build((List)list2);
    }

    private static final MatchToken findSimilarityNeglectingSpaces$getToken(List<? extends MatchToken> lineTokens, List<? extends MatchToken> proposalTokens, int index) {
        return index < lineTokens.size() ? lineTokens.get(index) : (index == lineTokens.size() ? (MatchToken)MatchToken.Virtual.INSTANCE : proposalTokens.get(index - lineTokens.size() - 1));
    }

    private static final char tokenize$lambda$4$char(String $this_tokenize, int index) {
        return $this_tokenize.charAt(index);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/completion/full/line/platform/FullLineProposalMatcher$MatchToken;", "", "()V", "length", "", "getLength", "()I", "Spaces", "Symbol", "Virtual", "Lorg/jetbrains/completion/full/line/platform/FullLineProposalMatcher$MatchToken$Spaces;", "Lorg/jetbrains/completion/full/line/platform/FullLineProposalMatcher$MatchToken$Symbol;", "Lorg/jetbrains/completion/full/line/platform/FullLineProposalMatcher$MatchToken$Virtual;", "intellij.fullLine"})
    private static abstract class MatchToken {
        private MatchToken() {
        }

        public final int getLength() {
            int n;
            MatchToken matchToken = this;
            if (matchToken instanceof Symbol) {
                n = 1;
            } else if (matchToken instanceof Spaces) {
                n = ((Spaces)this).getCount();
            } else if (matchToken instanceof Virtual) {
                n = 0;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return n;
        }

        public /* synthetic */ MatchToken(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/completion/full/line/platform/FullLineProposalMatcher$MatchToken$Spaces;", "Lorg/jetbrains/completion/full/line/platform/FullLineProposalMatcher$MatchToken;", "count", "", "(I)V", "getCount", "()I", "equals", "", "other", "", "hashCode", "intellij.fullLine"})
        public static final class Spaces
        extends MatchToken {
            private final int count;

            public Spaces(int count) {
                super(null);
                this.count = count;
            }

            public final int getCount() {
                return this.count;
            }

            public boolean equals(@Nullable Object other) {
                return other instanceof Spaces;
            }

            public int hashCode() {
                return 0;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/completion/full/line/platform/FullLineProposalMatcher$MatchToken$Symbol;", "Lorg/jetbrains/completion/full/line/platform/FullLineProposalMatcher$MatchToken;", "sym", "", "(C)V", "getSym", "()C", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.fullLine"})
        public static final class Symbol
        extends MatchToken {
            private final char sym;

            public Symbol(char sym) {
                super(null);
                this.sym = sym;
            }

            public final char getSym() {
                return this.sym;
            }

            public final char component1() {
                return this.sym;
            }

            @NotNull
            public final Symbol copy(char sym) {
                return new Symbol(sym);
            }

            public static /* synthetic */ Symbol copy$default(Symbol symbol, char c, int n, Object object) {
                if ((n & 1) != 0) {
                    c = symbol.sym;
                }
                return symbol.copy(c);
            }

            @NotNull
            public String toString() {
                return "Symbol(sym=" + this.sym + ")";
            }

            public int hashCode() {
                return Character.hashCode(this.sym);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Symbol)) {
                    return false;
                }
                Symbol symbol = (Symbol)other;
                return this.sym == symbol.sym;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/completion/full/line/platform/FullLineProposalMatcher$MatchToken$Virtual;", "Lorg/jetbrains/completion/full/line/platform/FullLineProposalMatcher$MatchToken;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.fullLine"})
        public static final class Virtual
        extends MatchToken {
            @NotNull
            public static final Virtual INSTANCE = new Virtual();

            private Virtual() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Virtual";
            }

            public int hashCode() {
                return -1592021710;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Virtual)) {
                    return false;
                }
                Virtual cfr_ignored_0 = (Virtual)other;
                return true;
            }
        }
    }
}

