/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.fullLine.core.icons.FullLineIcons;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.ml.impl.correctness.checker.CorrectnessError;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.AnalyzedFullLineProposal;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupportHolder;
import org.jetbrains.completion.full.line.platform.FullLineProposedElement;
import org.jetbrains.completion.full.line.platform.handlers.FullLineSmartInsertHandler;
import org.jetbrains.completion.full.line.services.MLRankingFacade;
import org.jetbrains.completion.full.line.settings.FullLineSettings;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0012\u001a\u00020\u0004J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010\u001b\u001a\u00020\u0015*\u00020\u001aH\u0002J\f\u0010\u001c\u001a\u00020\u0015*\u00020\u001aH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/completion/full/line/platform/FullLineLookupElement;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Lorg/jetbrains/completion/full/line/platform/FullLineProposedElement;", "prefix", "", "proposal", "Lorg/jetbrains/completion/full/line/AnalyzedFullLineProposal;", "holder", "Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupportHolder;", "(Ljava/lang/String;Lorg/jetbrains/completion/full/line/AnalyzedFullLineProposal;Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupportHolder;)V", "getPrefix", "()Ljava/lang/String;", "getProposal", "()Lorg/jetbrains/completion/full/line/AnalyzedFullLineProposal;", "settings", "Lorg/jetbrains/completion/full/line/settings/FullLineSettings;", "suffix", "getSuffix", "full", "getLookupString", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "renderElement", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "renderMatchedEnclosures", "renderRedCode", "Companion", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nFullLineProposedElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineProposedElement.kt\norg/jetbrains/completion/full/line/platform/FullLineLookupElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1855#2,2:97\n766#2:100\n857#2,2:101\n1#3:99\n*S KotlinDebug\n*F\n+ 1 FullLineProposedElement.kt\norg/jetbrains/completion/full/line/platform/FullLineLookupElement\n*L\n60#1:97,2\n69#1:100\n69#1:101,2\n*E\n"})
public final class FullLineLookupElement
extends LookupElement
implements FullLineProposedElement {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private final String prefix;
    @NotNull
    private final AnalyzedFullLineProposal proposal;
    @NotNull
    private final FullLineLanguageSupportHolder holder;
    @NotNull
    private final FullLineSettings settings;
    @NotNull
    private static final BuildNumber NEW_RED_CODE_UI_BUILD_VERSION;
    @Deprecated
    @NotNull
    public static final String TYPE_TEXT = "Full Line";
    @NotNull
    private static final DecimalFormat scoreFormatter;

    public FullLineLookupElement(@NotNull String prefix2, @NotNull AnalyzedFullLineProposal proposal, @NotNull FullLineLanguageSupportHolder holder) {
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.prefix = prefix2;
        this.proposal = proposal;
        this.holder = holder;
        this.settings = FullLineSettings.Companion.getInstance();
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @Override
    @NotNull
    public AnalyzedFullLineProposal getProposal() {
        return this.proposal;
    }

    @NotNull
    public final String getSuffix() {
        return this.getProposal().getSuffix();
    }

    @NotNull
    public final String full() {
        return this.getProposal().getSuggestion() + this.getProposal().getSuffix();
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        LookupElementPresentation lookupElementPresentation;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        super.renderElement(presentation);
        LookupElementPresentation $this$renderElement_u24lambda_u240 = lookupElementPresentation = presentation;
        boolean bl = false;
        $this$renderElement_u24lambda_u240.setTypeText(FullLineLookupElement.Companion.typeText());
        String string = this.getProposal().getSuffix();
        Object object = this.settings.showScore() ? " " + scoreFormatter.format(this.getProposal().getScore() * (double)100) + "%" : null;
        if (object == null) {
            object = "";
        }
        $this$renderElement_u24lambda_u240.setTailText(string + "\t" + object);
        $this$renderElement_u24lambda_u240.setIcon(FullLineIcons.Lookup.Regular);
        this.renderRedCode($this$renderElement_u24lambda_u240);
        this.renderMatchedEnclosures($this$renderElement_u24lambda_u240);
    }

    private final void renderRedCode(LookupElementPresentation $this$renderRedCode) {
        if (!FullLineSettings.Companion.getInstance().checkIncorrectCode(this.holder.getLanguage())) {
            return;
        }
        List<CorrectnessError> errors = this.getProposal().getCorrectnessState().errors();
        if (errors.isEmpty()) {
            return;
        }
        if (ApplicationInfo.getInstance().getBuild().compareTo(NEW_RED_CODE_UI_BUILD_VERSION) >= 0) {
            Iterable $this$forEach$iv = errors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CorrectnessError it = (CorrectnessError)element$iv;
                boolean bl = false;
                $this$renderRedCode.decorateItemTextRange(it.getLocation(), LookupElementPresentation.LookupItemDecoration.ERROR);
            }
        } else {
            $this$renderRedCode.setIcon(FullLineIcons.Lookup.RedCode);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderMatchedEnclosures(LookupElementPresentation $this$renderMatchedEnclosures) {
        void $this$filterTo$iv$iv;
        Iterable<Integer> it;
        Set<Integer> set;
        block6: {
            block5: {
                Set<Integer> set2;
                set = this.getProposal().getDetails().getMatchedEnclosuresIndices();
                if (set == null) break block5;
                it = set2 = set;
                boolean bl = false;
                set = !((Collection)it).isEmpty() ? set2 : null;
                if (set != null) break block6;
            }
            return;
        }
        Set<Integer> matchedIndices = set;
        Iterable $this$filter$iv = matchedIndices;
        boolean $i$f$filter = false;
        it = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it2 = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(it2 < this.getProposal().getSuggestion().length())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator2 = ((List)destination$iv$iv).iterator();
        while (iterator2.hasNext()) {
            int index = ((Number)iterator2.next()).intValue();
            $this$renderMatchedEnclosures.decorateItemTextRange(new TextRange(index, index + 1), LookupElementPresentation.LookupItemDecoration.HIGHLIGHT_MATCHED);
        }
    }

    @NotNull
    public String getLookupString() {
        return this.getProposal().getSuggestion();
    }

    public void handleInsert(@NotNull InsertionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        MLRankingFacade mLRankingFacade = MLRankingFacade.Companion.getInstance();
        if (mLRankingFacade != null) {
            Project project = context2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            mLRankingFacade.fireLookupElementSelected(project);
        }
        new FullLineSmartInsertHandler(this.holder).handleInsert(context2, this);
    }

    static {
        DecimalFormat decimalFormat;
        Companion = new Companion(null);
        BuildNumber buildNumber = BuildNumber.fromString((String)"232");
        Intrinsics.checkNotNull((Object)buildNumber);
        NEW_RED_CODE_UI_BUILD_VERSION = buildNumber;
        DecimalFormat $this$scoreFormatter_u24lambda_u244 = decimalFormat = new DecimalFormat("#.####");
        boolean bl = false;
        $this$scoreFormatter_u24lambda_u244.setRoundingMode(RoundingMode.DOWN);
        scoreFormatter = decimalFormat;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\tH\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/completion/full/line/platform/FullLineLookupElement$Companion;", "", "()V", "NEW_RED_CODE_UI_BUILD_VERSION", "Lcom/intellij/openapi/util/BuildNumber;", "Lorg/jetbrains/annotations/Nullable;", "getNEW_RED_CODE_UI_BUILD_VERSION", "()Lcom/intellij/openapi/util/BuildNumber;", "TYPE_TEXT", "", "scoreFormatter", "Ljava/text/DecimalFormat;", "typeText", "intellij.fullLine"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BuildNumber getNEW_RED_CODE_UI_BUILD_VERSION() {
            return NEW_RED_CODE_UI_BUILD_VERSION;
        }

        private final String typeText() {
            return FullLineLookupElement.TYPE_TEXT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

