/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginEnableStateChangedListener;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ApplicationKt;
import java.net.URL;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.FullLineNotifications;
import org.jetbrains.completion.full.line.feedback.ExplicitFeedback;
import org.jetbrains.completion.full.line.feedback.FeedbackApi;
import org.jetbrains.completion.full.line.platform.PluginsActivitySubscriberFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/completion/full/line/platform/DisableListener;", "Lcom/intellij/ide/plugins/PluginStateListener;", "Lcom/intellij/ide/plugins/PluginEnableStateChangedListener;", "()V", "install", "", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "isUninstallNotUpdate", "", "onOff", "cause", "", "stateChanged", "pluginDescriptors", "", "enable", "uninstall", "Companion", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nDisableListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisableListener.kt\norg/jetbrains/completion/full/line/platform/DisableListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,57:1\n1726#2,3:58\n12474#3,2:61\n9#4:63\n*S KotlinDebug\n*F\n+ 1 DisableListener.kt\norg/jetbrains/completion/full/line/platform/DisableListener\n*L\n29#1:58,3\n48#1:61,2\n52#1:63\n*E\n"})
public final class DisableListener
implements PluginStateListener,
PluginEnableStateChangedListener {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOG;

    private DisableListener() {
    }

    public void install(@NotNull IdeaPluginDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
    }

    public void uninstall(@NotNull IdeaPluginDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!Intrinsics.areEqual((Object)descriptor.getPluginId().getIdString(), (Object)"org.jetbrains.completion.full.line")) {
            return;
        }
        if (!this.isUninstallNotUpdate()) {
            return;
        }
        this.onOff("uninstalled");
    }

    public void stateChanged(@NotNull Collection<? extends IdeaPluginDescriptor> pluginDescriptors, boolean enable) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter(pluginDescriptors, (String)"pluginDescriptors");
            if (enable) {
                return;
            }
            Iterable $this$all$iv = pluginDescriptors;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    IdeaPluginDescriptor it = (IdeaPluginDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getPluginId().getIdString(), (Object)"org.jetbrains.completion.full.line")) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        if (!ApplicationKt.getApplication().isEAP()) {
            return;
        }
        this.onOff("disabled");
    }

    private final void onOff(String cause) {
        LOG.info("Full Line plugin is " + cause);
        String mostPopularLanguage = ExplicitFeedback.INSTANCE.getMostPopularLanguage();
        URL url = FeedbackApi.INSTANCE.exitSurvey(mostPopularLanguage);
        if (Boolean.parseBoolean(System.getProperty("full.line.uninstall.in-ide.notification"))) {
            String string = mostPopularLanguage;
            if (string == null) {
                string = "none";
            }
            FullLineNotifications.Feedback.INSTANCE.showUninstallFeedbackRequest(string);
        } else {
            BrowserUtil.browse((URL)url);
        }
    }

    private final boolean isUninstallNotUpdate() {
        boolean bl;
        block1: {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            Object[] $this$any$iv = stackTraceElementArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                StackTraceElement it = (StackTraceElement)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getMethodName(), (Object)"uninstallAndUpdateUi")) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public /* synthetic */ DisableListener(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0002H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/completion/full/line/platform/DisableListener$Companion;", "Lorg/jetbrains/completion/full/line/platform/PluginsActivitySubscriberFactory;", "Lorg/jetbrains/completion/full/line/platform/DisableListener;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createSubscriber", "intellij.fullLine"})
    public static final class Companion
    extends PluginsActivitySubscriberFactory<DisableListener> {
        private Companion() {
        }

        @Override
        @NotNull
        protected DisableListener createSubscriber() {
            return new DisableListener(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

