/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.ProposalTransformer;
import org.jetbrains.completion.full.line.RawFullLineProposal;
import org.jetbrains.completion.full.line.platform.diagnostics.DiagnosticsService;
import org.jetbrains.completion.full.line.platform.diagnostics.FullLineLogger;
import org.jetbrains.completion.full.line.platform.diagnostics.FullLinePart;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010H\u0004J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/completion/full/line/platform/DiagnosableProposalTransformer;", "Lorg/jetbrains/completion/full/line/ProposalTransformer;", "name", "", "(Ljava/lang/String;)V", "invocations", "", "mappings", "", "Lorg/jetbrains/completion/full/line/platform/DiagnosableProposalTransformer$Mapping;", "totalTimeMs", "", "diagnoseMapping", "Lorg/jetbrains/completion/full/line/RawFullLineProposal;", "original", "getTransformed", "Lkotlin/Function0;", "provideDiagnostics", "Lorg/jetbrains/completion/full/line/platform/DiagnosableProposalTransformer$MapperDiagnostics;", "Companion", "MapperDiagnostics", "Mapping", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nProposalTransformers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProposalTransformers.kt\norg/jetbrains/completion/full/line/platform/DiagnosableProposalTransformer\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 log.kt\norg/jetbrains/completion/full/line/platform/diagnostics/LogKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,222:1\n31#2,6:223\n59#3:229\n11#4:230\n*S KotlinDebug\n*F\n+ 1 ProposalTransformers.kt\norg/jetbrains/completion/full/line/platform/DiagnosableProposalTransformer\n*L\n36#1:223,6\n59#1:229\n59#1:230\n*E\n"})
public abstract class DiagnosableProposalTransformer
implements ProposalTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private double totalTimeMs;
    private int invocations;
    @NotNull
    private final List<Mapping> mappings;
    @NotNull
    private static final FullLineLogger LOG;

    public DiagnosableProposalTransformer(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.mappings = new ArrayList();
    }

    @NotNull
    public final MapperDiagnostics provideDiagnostics() {
        return new MapperDiagnostics(this.name, this.totalTimeMs, this.invocations, this.mappings);
    }

    @NotNull
    protected final RawFullLineProposal diagnoseMapping(@NotNull RawFullLineProposal original, @NotNull Function0<RawFullLineProposal> getTransformed) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter(getTransformed, (String)"getTransformed");
        if (!LOG.isDebugEnabled()) {
            return (RawFullLineProposal)getTransformed.invoke();
        }
        int n = this.invocations;
        this.invocations = n + 1;
        Object transformed = null;
        boolean $i$f$measureNanoTime = false;
        long start$iv = System.nanoTime();
        boolean bl = false;
        transformed = getTransformed.invoke();
        long timeNs = System.nanoTime() - start$iv;
        this.totalTimeMs += Duration.toDouble-impl((long)DurationKt.toDuration((long)timeNs, (DurationUnit)DurationUnit.NANOSECONDS), (DurationUnit)DurationUnit.MILLISECONDS);
        if (transformed != original) {
            ((Collection)this.mappings).add(new Mapping(original, (RawFullLineProposal)transformed));
        }
        return (RawFullLineProposal)transformed;
    }

    static {
        FullLinePart part$iv = FullLinePart.PRE_PROCESSING;
        boolean $i$f$logger = false;
        DiagnosticsService diagnosticsService = DiagnosticsService.Companion.getInstance();
        boolean $i$f$logger2 = false;
        Logger logger2 = Logger.getInstance(DiagnosableProposalTransformer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = diagnosticsService.logger(part$iv, logger2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/completion/full/line/platform/DiagnosableProposalTransformer$Companion;", "", "()V", "LOG", "Lorg/jetbrains/completion/full/line/platform/diagnostics/FullLineLogger;", "intellij.fullLine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/completion/full/line/platform/DiagnosableProposalTransformer$MapperDiagnostics;", "", "name", "", "totalTimeMs", "", "invocations", "", "mappings", "", "Lorg/jetbrains/completion/full/line/platform/DiagnosableProposalTransformer$Mapping;", "(Ljava/lang/String;DILjava/util/List;)V", "getInvocations", "()I", "getMappings", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getTotalTimeMs", "()D", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.fullLine"})
    public static final class MapperDiagnostics {
        @NotNull
        private final String name;
        private final double totalTimeMs;
        private final int invocations;
        @NotNull
        private final List<Mapping> mappings;

        public MapperDiagnostics(@NotNull String name, double totalTimeMs, int invocations, @NotNull List<Mapping> mappings) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
            this.name = name;
            this.totalTimeMs = totalTimeMs;
            this.invocations = invocations;
            this.mappings = mappings;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final double getTotalTimeMs() {
            return this.totalTimeMs;
        }

        public final int getInvocations() {
            return this.invocations;
        }

        @NotNull
        public final List<Mapping> getMappings() {
            return this.mappings;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final double component2() {
            return this.totalTimeMs;
        }

        public final int component3() {
            return this.invocations;
        }

        @NotNull
        public final List<Mapping> component4() {
            return this.mappings;
        }

        @NotNull
        public final MapperDiagnostics copy(@NotNull String name, double totalTimeMs, int invocations, @NotNull List<Mapping> mappings) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
            return new MapperDiagnostics(name, totalTimeMs, invocations, mappings);
        }

        public static /* synthetic */ MapperDiagnostics copy$default(MapperDiagnostics mapperDiagnostics, String string, double d, int n, List list2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = mapperDiagnostics.name;
            }
            if ((n2 & 2) != 0) {
                d = mapperDiagnostics.totalTimeMs;
            }
            if ((n2 & 4) != 0) {
                n = mapperDiagnostics.invocations;
            }
            if ((n2 & 8) != 0) {
                list2 = mapperDiagnostics.mappings;
            }
            return mapperDiagnostics.copy(string, d, n, list2);
        }

        @NotNull
        public String toString() {
            return "MapperDiagnostics(name=" + this.name + ", totalTimeMs=" + this.totalTimeMs + ", invocations=" + this.invocations + ", mappings=" + this.mappings + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Double.hashCode(this.totalTimeMs);
            result = result * 31 + Integer.hashCode(this.invocations);
            result = result * 31 + ((Object)this.mappings).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MapperDiagnostics)) {
                return false;
            }
            MapperDiagnostics mapperDiagnostics = (MapperDiagnostics)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)mapperDiagnostics.name)) {
                return false;
            }
            if (Double.compare(this.totalTimeMs, mapperDiagnostics.totalTimeMs) != 0) {
                return false;
            }
            if (this.invocations != mapperDiagnostics.invocations) {
                return false;
            }
            return Intrinsics.areEqual(this.mappings, mapperDiagnostics.mappings);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/completion/full/line/platform/DiagnosableProposalTransformer$Mapping;", "", "original", "Lorg/jetbrains/completion/full/line/RawFullLineProposal;", "transformed", "(Lorg/jetbrains/completion/full/line/RawFullLineProposal;Lorg/jetbrains/completion/full/line/RawFullLineProposal;)V", "getOriginal", "()Lorg/jetbrains/completion/full/line/RawFullLineProposal;", "getTransformed", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.fullLine"})
    public static final class Mapping {
        @NotNull
        private final RawFullLineProposal original;
        @NotNull
        private final RawFullLineProposal transformed;

        public Mapping(@NotNull RawFullLineProposal original, @NotNull RawFullLineProposal transformed) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)transformed, (String)"transformed");
            this.original = original;
            this.transformed = transformed;
        }

        @NotNull
        public final RawFullLineProposal getOriginal() {
            return this.original;
        }

        @NotNull
        public final RawFullLineProposal getTransformed() {
            return this.transformed;
        }

        @NotNull
        public final RawFullLineProposal component1() {
            return this.original;
        }

        @NotNull
        public final RawFullLineProposal component2() {
            return this.transformed;
        }

        @NotNull
        public final Mapping copy(@NotNull RawFullLineProposal original, @NotNull RawFullLineProposal transformed) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)transformed, (String)"transformed");
            return new Mapping(original, transformed);
        }

        public static /* synthetic */ Mapping copy$default(Mapping mapping, RawFullLineProposal rawFullLineProposal, RawFullLineProposal rawFullLineProposal2, int n, Object object) {
            if ((n & 1) != 0) {
                rawFullLineProposal = mapping.original;
            }
            if ((n & 2) != 0) {
                rawFullLineProposal2 = mapping.transformed;
            }
            return mapping.copy(rawFullLineProposal, rawFullLineProposal2);
        }

        @NotNull
        public String toString() {
            return "Mapping(original=" + this.original + ", transformed=" + this.transformed + ")";
        }

        public int hashCode() {
            int result = this.original.hashCode();
            result = result * 31 + this.transformed.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Mapping)) {
                return false;
            }
            Mapping mapping = (Mapping)other;
            if (!Intrinsics.areEqual((Object)this.original, (Object)mapping.original)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.transformed, (Object)mapping.transformed);
        }
    }
}

