/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.mlRanking;

import com.intellij.completion.ml.ranker.local.DecisionFunctionWithLanguages;
import com.intellij.completion.ml.ranker.local.LocalZipModelProvider;
import com.intellij.internal.ml.DecisionFunction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0003J\r\u0010\u0014\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\f\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006 "}, d2={"Lorg/jetbrains/completion/full/line/mlRanking/FullLineRelevanceModelsUtil;", "", "registryPathKey", "", "(Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "localModel", "Lorg/jetbrains/completion/full/line/mlRanking/FullLineRelevanceModelsUtil$LocalModalInfo;", "registry", "Lcom/intellij/openapi/util/registry/RegistryValue;", "threshold", "", "Ljava/lang/Double;", "getModel", "Lcom/intellij/internal/ml/DecisionFunction;", "languageId", "getThreshold", "()Ljava/lang/Double;", "initModelFromPathToZipSynchronously", "", "isPathToTheModelChanged", "", "isPathToTheModelSetAndValid", "loadModelAndThreshold", "pathToZip", "scheduleInitModel", "Ljava/util/concurrent/Future;", "LocalModalInfo", "intellij.fullLine.mlRanking"})
@SourceDebugExtension(value={"SMAP\nFullLineRelevanceModelsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineRelevanceModelsUtil.kt\norg/jetbrains/completion/full/line/mlRanking/FullLineRelevanceModelsUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,89:1\n11#2:90\n*S KotlinDebug\n*F\n+ 1 FullLineRelevanceModelsUtil.kt\norg/jetbrains/completion/full/line/mlRanking/FullLineRelevanceModelsUtil\n*L\n19#1:90\n*E\n"})
public abstract class FullLineRelevanceModelsUtil {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final ExecutorService executor;
    @Nullable
    private volatile LocalModalInfo localModel;
    @Nullable
    private volatile Double threshold;
    @NotNull
    private final RegistryValue registry;

    public FullLineRelevanceModelsUtil(@NotNull String registryPathKey) {
        Intrinsics.checkNotNullParameter((Object)registryPathKey, (String)"registryPathKey");
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(FullLineRelevanceModelsUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.LOG = logger2;
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"FLCC pool executor");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createSequentialApplicationPoolExecutor(...)");
        this.executor = executorService;
        RegistryValue registryValue = Registry.get((String)registryPathKey);
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"get(...)");
        this.registry = registryValue;
    }

    @Nullable
    public final DecisionFunction getModel(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        if (!this.isPathToTheModelSetAndValid()) {
            this.localModel = null;
            return null;
        }
        if (this.isPathToTheModelChanged()) {
            this.scheduleInitModel();
            return null;
        }
        LocalModalInfo localModalInfo = this.localModel;
        if (localModalInfo == null) {
            return null;
        }
        LocalModalInfo resLocalModel = localModalInfo;
        Set<String> set = resLocalModel.getLanguages();
        String string = languageId;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return set.contains(string2) ? resLocalModel.getDecisionFunction() : null;
    }

    @Nullable
    public final Double getThreshold() {
        return this.threshold;
    }

    private final Future<?> scheduleInitModel() {
        Future<?> future = this.executor.submit(() -> FullLineRelevanceModelsUtil.scheduleInitModel$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        return future;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPathToTheModelSetAndValid() {
        if (!this.registry.isChangedFromDefault()) return false;
        String string = this.registry.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        Path path2 = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path path3 = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        return true;
    }

    private final boolean isPathToTheModelChanged() {
        LocalModalInfo localModalInfo = this.localModel;
        return !Intrinsics.areEqual((Object)this.registry.asString(), (Object)(localModalInfo != null ? localModalInfo.getPath() : null));
    }

    private final void initModelFromPathToZipSynchronously() {
        this.localModel = null;
        this.threshold = null;
        long startTime = System.currentTimeMillis();
        String string = this.registry.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String pathToZip = string;
        this.loadModelAndThreshold(pathToZip);
        long endTime = System.currentTimeMillis();
        this.LOG.info("Full Line relevance model initialization took: " + (endTime - startTime) + " ms.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadModelAndThreshold(String pathToZip) {
        try {
            Closeable closeable = new ZipFile(pathToZip);
            Throwable throwable = null;
            try {
                LocalZipModelProvider localZipModelProvider;
                ZipFile file2 = (ZipFile)closeable;
                boolean bl = false;
                if (LocalZipModelProvider.Companion.findModelProvider(file2) == null) {
                    return;
                }
                LocalZipModelProvider loader = localZipModelProvider;
                DecisionFunctionWithLanguages decisionFunctionWithLanguages = loader.loadModel(file2);
                DecisionFunction decisionFunction = decisionFunctionWithLanguages.component1();
                List languages2 = decisionFunctionWithLanguages.component2();
                this.localModel = new LocalModalInfo(decisionFunction, pathToZip, CollectionsKt.toSet((Iterable)languages2));
                InputStream inputStream2 = file2.getInputStream(file2.getEntry("threshold.txt"));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
                Closeable closeable2 = inputStream2;
                Charset charset = Charsets.UTF_8;
                closeable2 = new InputStreamReader((InputStream)closeable2, charset);
                int n = 8192;
                String string = (closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n)).readLine();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readLine(...)");
                this.threshold = Double.parseDouble(string);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable t) {
            this.LOG.error(t);
        }
    }

    private static final void scheduleInitModel$lambda$0(FullLineRelevanceModelsUtil this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.initModelFromPathToZipSynchronously();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/completion/full/line/mlRanking/FullLineRelevanceModelsUtil$LocalModalInfo;", "", "decisionFunction", "Lcom/intellij/internal/ml/DecisionFunction;", "path", "", "languages", "", "(Lcom/intellij/internal/ml/DecisionFunction;Ljava/lang/String;Ljava/util/Set;)V", "getDecisionFunction", "()Lcom/intellij/internal/ml/DecisionFunction;", "getLanguages", "()Ljava/util/Set;", "getPath", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.fullLine.mlRanking"})
    private static final class LocalModalInfo {
        @NotNull
        private final DecisionFunction decisionFunction;
        @NotNull
        private final String path;
        @NotNull
        private final Set<String> languages;

        public LocalModalInfo(@NotNull DecisionFunction decisionFunction, @NotNull String path2, @NotNull Set<String> languages2) {
            Intrinsics.checkNotNullParameter((Object)decisionFunction, (String)"decisionFunction");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(languages2, (String)"languages");
            this.decisionFunction = decisionFunction;
            this.path = path2;
            this.languages = languages2;
        }

        @NotNull
        public final DecisionFunction getDecisionFunction() {
            return this.decisionFunction;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final Set<String> getLanguages() {
            return this.languages;
        }

        @NotNull
        public final DecisionFunction component1() {
            return this.decisionFunction;
        }

        @NotNull
        public final String component2() {
            return this.path;
        }

        @NotNull
        public final Set<String> component3() {
            return this.languages;
        }

        @NotNull
        public final LocalModalInfo copy(@NotNull DecisionFunction decisionFunction, @NotNull String path2, @NotNull Set<String> languages2) {
            Intrinsics.checkNotNullParameter((Object)decisionFunction, (String)"decisionFunction");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(languages2, (String)"languages");
            return new LocalModalInfo(decisionFunction, path2, languages2);
        }

        public static /* synthetic */ LocalModalInfo copy$default(LocalModalInfo localModalInfo, DecisionFunction decisionFunction, String string, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                decisionFunction = localModalInfo.decisionFunction;
            }
            if ((n & 2) != 0) {
                string = localModalInfo.path;
            }
            if ((n & 4) != 0) {
                set = localModalInfo.languages;
            }
            return localModalInfo.copy(decisionFunction, string, set);
        }

        @NotNull
        public String toString() {
            return "LocalModalInfo(decisionFunction=" + this.decisionFunction + ", path=" + this.path + ", languages=" + this.languages + ")";
        }

        public int hashCode() {
            int result = this.decisionFunction.hashCode();
            result = result * 31 + this.path.hashCode();
            result = result * 31 + ((Object)this.languages).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LocalModalInfo)) {
                return false;
            }
            LocalModalInfo localModalInfo = (LocalModalInfo)other;
            if (!Intrinsics.areEqual((Object)this.decisionFunction, (Object)localModalInfo.decisionFunction)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)localModalInfo.path)) {
                return false;
            }
            return Intrinsics.areEqual(this.languages, localModalInfo.languages);
        }
    }
}

