/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.markers;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.markers.Marker;
import org.jetbrains.completion.full.line.markers.MarkerFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001e\u0010\u0011\u001a\u00020\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/completion/full/line/markers/MarkerFile;", "", "language", "", "file", "Ljava/io/File;", "rootFolder", "escape", "", "(Ljava/lang/String;Ljava/io/File;Ljava/io/File;Z)V", "getFile", "()Ljava/io/File;", "marker", "Lorg/jetbrains/completion/full/line/markers/Marker;", "getMarker", "()Lorg/jetbrains/completion/full/line/markers/Marker;", "commentLiterals", "findExtraData", "comments", "", "prop", "findExtraDatas", "Companion", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nMarkerFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkerFile.kt\norg/jetbrains/completion/full/line/markers/MarkerFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n959#2,7:97\n1549#2:104\n1620#2,3:105\n1549#2:108\n1620#2,3:109\n223#2,2:112\n1549#2:114\n1620#2,3:115\n766#2:118\n857#2,2:119\n1549#2:121\n1620#2,3:122\n*S KotlinDebug\n*F\n+ 1 MarkerFile.kt\norg/jetbrains/completion/full/line/markers/MarkerFile\n*L\n16#1:97,7\n17#1:104\n17#1:105,3\n69#1:108\n69#1:109,3\n69#1:112,2\n77#1:114\n77#1:115,3\n77#1:118\n77#1:119,2\n79#1:121\n79#1:122,3\n*E\n"})
public final class MarkerFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @NotNull
    private final File rootFolder;
    @NotNull
    private final Marker marker;

    /*
     * WARNING - void declaration
     */
    public MarkerFile(@NotNull String language2, @NotNull File file2, @NotNull File rootFolder, boolean escape) {
        String $this$mapTo$iv$iv;
        void $this$map$iv;
        Object it;
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)rootFolder, (String)"rootFolder");
        this.file = file2;
        this.rootFolder = rootFolder;
        String comment = this.commentLiterals(language2);
        List lines = StringsKt.lines((CharSequence)FilesKt.readText$default((File)this.file, null, (int)1, null));
        Iterable $this$takeWhile$iv = lines;
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            it = (String)item$iv;
            boolean bl = false;
            if (!(StringsKt.startsWith$default((String)it, (String)comment, (boolean)false, (int)2, null) || StringsKt.isBlank((CharSequence)((CharSequence)it)))) break;
            list$iv.add(item$iv);
        }
        $this$takeWhile$iv = list$iv;
        boolean $i$f$map = false;
        list$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        it = $this$mapTo$iv$iv.iterator();
        while (it.hasNext()) {
            void it2;
            Object item$iv$iv = it.next();
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.removePrefix((String)it2, (CharSequence)comment));
        }
        List commentSection = (List)destination$iv$iv;
        String result = this.findExtraData(commentSection, "result");
        try {
            $this$mapTo$iv$iv = this.findExtraData(commentSection, "prefix");
        }
        catch (Exception e) {
            $this$mapTo$iv$iv = "";
        }
        String prefix2 = $this$mapTo$iv$iv;
        List<String> expected = this.findExtraDatas(commentSection, "expected");
        List<String> notExpected = this.findExtraDatas(commentSection, "!expected");
        String context2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)lines, (int)commentSection.size()), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        int offset = StringsKt.lastIndexOf$default((CharSequence)context2, (String)"<caret>", (int)0, (boolean)false, (int)6, null);
        String it3 = StringsKt.take((String)context2, (int)offset);
        boolean bl = false;
        String code = escape ? StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)it3, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\t", (String)"\\t", (boolean)false, (int)4, null) : it3;
        String testcase = FilesKt.getNameWithoutExtension((File)FilesKt.relativeTo((File)this.file, (File)this.rootFolder));
        String filename = FilesKt.relativeTo((File)this.file, (File)this.rootFolder).getParent();
        Regex resultRegex = new Regex(StringsKt.replace$default((String)result, (String)"{", (String)"\\{", (boolean)false, (int)4, null));
        Intrinsics.checkNotNull((Object)filename);
        this.marker = new Marker(testcase, code, offset, filename, expected, notExpected, prefix2, resultRegex);
    }

    public /* synthetic */ MarkerFile(String string, File file2, File file3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(string, file2, file3, bl);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final Marker getMarker() {
        return this.marker;
    }

    private final String commentLiterals(String language2) {
        String string = language2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return switch (string) {
            case "python" -> "#";
            case "java" -> "//";
            case "kotlin" -> "//";
            case "typescript" -> "//";
            case "javascript" -> "//";
            default -> throw new IllegalArgumentException("Passed unknown language");
        };
    }

    /*
     * WARNING - void declaration
     */
    private final String findExtraData(List<String> comments, String prop) {
        Object element$iv2;
        block2: {
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv = comments;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            Iterable $this$first$iv = (List)destination$iv$iv;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                String it = (String)element$iv2;
                boolean bl = false;
                CharSequence charSequence = it;
                if (!new Regex(prop + "\\s*=\\s*<.*>").matches(charSequence)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        String it = (String)element$iv2;
        boolean bl = false;
        String string = it.substring((prop + " = <").length(), it.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private final List<String> findExtraDatas(List<String> comments, String prop) {
        Iterable $this$filterTo$iv$iv;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = comments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            if (!new Regex(prop + "\\s*=\\s*<.*>").matches(charSequence)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.substring((prop + " = <").length(), it.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/completion/full/line/markers/MarkerFile$Companion;", "", "()V", "readMarkers", "", "Lorg/jetbrains/completion/full/line/markers/MarkerFile;", "rootFolder", "Ljava/io/File;", "language", "", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nMarkerFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkerFile.kt\norg/jetbrains/completion/full/line/markers/MarkerFile$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1360#2:97\n1446#2,5:98\n1549#2:103\n1620#2,3:104\n*S KotlinDebug\n*F\n+ 1 MarkerFile.kt\norg/jetbrains/completion/full/line/markers/MarkerFile$Companion\n*L\n91#1:97\n91#1:98,5\n92#1:103\n92#1:104,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<MarkerFile> readMarkers(@NotNull File rootFolder, @NotNull String language2) {
            void $this$mapTo$iv$iv;
            Object list$iv$iv;
            File it;
            Iterable $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Intrinsics.checkNotNullParameter((Object)rootFolder, (String)"rootFolder");
            Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
            Iterable<Object> iterable = Files.walk(FilesKt.resolve((File)rootFolder, (String)language2).toPath(), new FileVisitOption[0]).map(arg_0 -> Companion.readMarkers$lambda$0(readMarkers.directories.1.INSTANCE, arg_0)).filter(arg_0 -> Companion.readMarkers$lambda$1(readMarkers.directories.2.INSTANCE, arg_0)).filter(arg_0 -> Companion.readMarkers$lambda$2(readMarkers.directories.3.INSTANCE, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"toList(...)");
            iterable = iterable;
            boolean $i$f$flatMap = false;
            void var6_5 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (File)element$iv$iv;
                boolean bl = false;
                Object[] objectArray = it.listFiles();
                Intrinsics.checkNotNull((Object)objectArray);
                list$iv$iv = ArraysKt.toList((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List directories2 = (List)destination$iv$iv;
            Iterable $this$map$iv = directories2;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(new MarkerFile(language2, it, rootFolder, false));
            }
            return (List)destination$iv$iv;
        }

        private static final File readMarkers$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (File)$tmp0.invoke(p0);
        }

        private static final boolean readMarkers$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean readMarkers$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

