/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.logs;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.LocalInferenceType;
import org.jetbrains.completion.full.line.LocalModelDescriptor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001 B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bJ \u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/completion/full/line/logs/FullLineCodeCompletionLogs;", "", "()V", "EXIT_CODE", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "FAILED_DOWNLOAD", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "FAILED_DOWNLOAD_ID", "", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "LOCAL_INFERENCE_TYPE", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lorg/jetbrains/completion/full/line/LocalInferenceType;", "MODEL_VERSION", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "SERVER_START", "SERVER_TERMINATED", "SUCCESSFULLY_DOWNLOAD", "SUCCESSFULLY_DOWNLOAD_ID", "failedDownload", "", "localModelDescriptor", "Lorg/jetbrains/completion/full/line/LocalModelDescriptor;", "modelVersion", "reportDownload", "eventId", "serverStarted", "serverTerminated", "exitCode", "", "successfullyDownload", "Logger", "intellij.fullLine.core"})
@SourceDebugExtension(value={"SMAP\nFullLineCodeCompletionLogs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineCodeCompletionLogs.kt\norg/jetbrains/completion/full/line/logs/FullLineCodeCompletionLogs\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,88:1\n261#2,3:89\n*S KotlinDebug\n*F\n+ 1 FullLineCodeCompletionLogs.kt\norg/jetbrains/completion/full/line/logs/FullLineCodeCompletionLogs\n*L\n42#1:89,3\n*E\n"})
public final class FullLineCodeCompletionLogs {
    @NotNull
    public static final FullLineCodeCompletionLogs INSTANCE;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final StringEventField MODEL_VERSION;
    @NotNull
    private static final EnumEventField<LocalInferenceType> LOCAL_INFERENCE_TYPE;
    @NotNull
    public static final String SUCCESSFULLY_DOWNLOAD_ID = "model.downloaded.successfully";
    @NotNull
    private static final VarargEventId SUCCESSFULLY_DOWNLOAD;
    @NotNull
    public static final String FAILED_DOWNLOAD_ID = "model.downloaded.failed";
    @NotNull
    private static final VarargEventId FAILED_DOWNLOAD;
    @NotNull
    private static final VarargEventId SERVER_START;
    @NotNull
    private static final IntEventField EXIT_CODE;
    @NotNull
    private static final VarargEventId SERVER_TERMINATED;

    private FullLineCodeCompletionLogs() {
    }

    public final void successfullyDownload(@NotNull LocalModelDescriptor localModelDescriptor, @NotNull String modelVersion) {
        Intrinsics.checkNotNullParameter((Object)localModelDescriptor, (String)"localModelDescriptor");
        Intrinsics.checkNotNullParameter((Object)modelVersion, (String)"modelVersion");
        this.reportDownload(SUCCESSFULLY_DOWNLOAD, localModelDescriptor, modelVersion);
    }

    public final void failedDownload(@NotNull LocalModelDescriptor localModelDescriptor, @NotNull String modelVersion) {
        Intrinsics.checkNotNullParameter((Object)localModelDescriptor, (String)"localModelDescriptor");
        Intrinsics.checkNotNullParameter((Object)modelVersion, (String)"modelVersion");
        this.reportDownload(FAILED_DOWNLOAD, localModelDescriptor, modelVersion);
    }

    private final void reportDownload(VarargEventId eventId, LocalModelDescriptor localModelDescriptor, String modelVersion) {
        EventPair[] eventPairArray = new EventPair[]{EventFields.Language.with((Object)localModelDescriptor.getLanguage()), LOCAL_INFERENCE_TYPE.with((Object)localModelDescriptor.getInferenceType()), MODEL_VERSION.with((Object)modelVersion)};
        eventId.log(eventPairArray);
    }

    public final void serverStarted(@NotNull LocalModelDescriptor localModelDescriptor) {
        Intrinsics.checkNotNullParameter((Object)localModelDescriptor, (String)"localModelDescriptor");
        EventPair[] eventPairArray = new EventPair[]{EventFields.Language.with((Object)localModelDescriptor.getLanguage()), LOCAL_INFERENCE_TYPE.with((Object)localModelDescriptor.getInferenceType())};
        SERVER_START.log(eventPairArray);
    }

    public final void serverTerminated(@NotNull LocalModelDescriptor localModelDescriptor, int exitCode) {
        Intrinsics.checkNotNullParameter((Object)localModelDescriptor, (String)"localModelDescriptor");
        EventPair[] eventPairArray = new EventPair[]{EventFields.Language.with((Object)localModelDescriptor.getLanguage()), LOCAL_INFERENCE_TYPE.with((Object)localModelDescriptor.getInferenceType()), EXIT_CODE.with((Object)exitCode)};
        SERVER_TERMINATED.log(eventPairArray);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$iv;
        INSTANCE = new FullLineCodeCompletionLogs();
        GROUP = new EventLogGroup("full.line.code.completion.details", 2, null, 4, null);
        MODEL_VERSION = EventFields.StringValidatedByInlineRegexp((String)"model_version", (String)"[0-9.]+-(jvm|native)-(onnx|llama)(-beta)?");
        EventField[] eventFieldArray = EventFields.INSTANCE;
        String name$iv = "local_inference_type";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        LOCAL_INFERENCE_TYPE = new EnumEventField(name$iv, LocalInferenceType.class, null, transform$iv);
        eventFieldArray = new EventField[]{EventFields.Language, LOCAL_INFERENCE_TYPE, MODEL_VERSION};
        SUCCESSFULLY_DOWNLOAD = GROUP.registerVarargEvent(SUCCESSFULLY_DOWNLOAD_ID, eventFieldArray);
        eventFieldArray = new EventField[]{EventFields.Language, LOCAL_INFERENCE_TYPE, MODEL_VERSION};
        FAILED_DOWNLOAD = GROUP.registerVarargEvent(FAILED_DOWNLOAD_ID, eventFieldArray);
        eventFieldArray = new EventField[]{EventFields.Language, LOCAL_INFERENCE_TYPE};
        SERVER_START = GROUP.registerVarargEvent("native.server.started", eventFieldArray);
        EXIT_CODE = EventFields.Int((String)"exit_code");
        eventFieldArray = new EventField[]{EventFields.Language, LOCAL_INFERENCE_TYPE, EXIT_CODE};
        SERVER_TERMINATED = GROUP.registerVarargEvent("native.server.terminated", eventFieldArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/completion/full/line/logs/FullLineCodeCompletionLogs$Logger;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "intellij.fullLine.core"})
    public static final class Logger
    extends CounterUsagesCollector {
        @NotNull
        public static final Logger INSTANCE = new Logger();

        private Logger() {
        }

        @NotNull
        public EventLogGroup getGroup() {
            return GROUP;
        }
    }
}

