/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.tokenizer;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.local.tokenizer.BaseEncoder;
import org.jetbrains.completion.full.line.local.tokenizer.Tokenizer;
import org.jetbrains.completion.full.line.local.utils.Caching;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 -2\u00020\u0001:\u0001-B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0016J\u0014\u0010\u0019\u001a\u00020\u000b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eJ \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001e2\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u001e0\u001eJ\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u000bH\u0016J>\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e2\u0006\u0010 \u001a\u00020\u000b2\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\"2\b\b\u0002\u0010$\u001a\u00020\"2\b\b\u0002\u0010%\u001a\u00020&H\u0002J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eH\u0016JH\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u001e0\u001e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001e2\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\"2\b\b\u0002\u0010$\u001a\u00020\"2\b\b\u0002\u0010%\u001a\u00020&J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bRf\u0010\t\u001aZ\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \f*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\r0\r \f*,\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \f*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\r0\r\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\b\u00a8\u0006."}, d2={"Lorg/jetbrains/completion/full/line/local/tokenizer/FullLineTokenizer;", "Lorg/jetbrains/completion/full/line/local/tokenizer/Tokenizer;", "encoder", "Lorg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder;", "(Lorg/jetbrains/completion/full/line/local/tokenizer/BaseEncoder;)V", "eosTokenId", "", "getEosTokenId", "()I", "idsByRegexCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "kotlin.jvm.PlatformType", "", "invalidIds", "getInvalidIds", "()Ljava/util/Set;", "vocab", "", "getVocab", "()Ljava/util/Map;", "vocabIds", "getVocabIds", "vocabSize", "getVocabSize", "decode", "id", "ids", "", "separator", "", "encode", "sentence", "bos", "", "eos", "reverse", "dropoutProb", "", "sentences", "idsByRegex", "regex", "Lkotlin/text/Regex;", "isValidString", "s", "Companion", "intellij.fullLine.local"})
@SourceDebugExtension(value={"SMAP\nFullLineTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineTokenizer.kt\norg/jetbrains/completion/full/line/local/tokenizer/FullLineTokenizer\n+ 2 Caching.kt\norg/jetbrains/completion/full/line/local/utils/Caching\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,530:1\n7#2,4:531\n1559#3:535\n1590#3,4:536\n1549#3:540\n1620#3,3:541\n11095#4:544\n11430#4,3:545\n*S KotlinDebug\n*F\n+ 1 FullLineTokenizer.kt\norg/jetbrains/completion/full/line/local/tokenizer/FullLineTokenizer\n*L\n139#1:531,4\n226#1:535\n226#1:536,4\n193#1:540\n193#1:541,3\n205#1:544\n205#1:545,3\n*E\n"})
public final class FullLineTokenizer
implements Tokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private BaseEncoder encoder;
    private final int vocabSize;
    private final int eosTokenId;
    @NotNull
    private final Set<Integer> invalidIds;
    private final Cache<String, Set<Integer>> idsByRegexCache;
    @NotNull
    private final Map<String, Integer> vocab;
    @NotNull
    private final Set<Integer> vocabIds;

    /*
     * WARNING - void declaration
     */
    private FullLineTokenizer(BaseEncoder encoder) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        this.encoder = encoder;
        this.vocabSize = this.encoder.vocabSize$intellij_fullLine_local();
        this.eosTokenId = this.encoder.getBpeState$intellij_fullLine_local().getSpecialTokens().getEosId();
        Object[] objectArray = new Integer[]{this.encoder.getBpeState$intellij_fullLine_local().getSpecialTokens().getUnkId(), this.encoder.getBpeState$intellij_fullLine_local().getSpecialTokens().getPadId(), this.encoder.getBpeState$intellij_fullLine_local().getSpecialTokens().getBosId(), this.encoder.getBpeState$intellij_fullLine_local().getSpecialTokens().getEosId()};
        this.invalidIds = SetsKt.setOf((Object[])objectArray);
        Object $this$iv = Caching.INSTANCE;
        long total$iv = 100L;
        long minutes$iv = 5L;
        boolean $i$f$default = false;
        this.idsByRegexCache = Caffeine.newBuilder().maximumSize(total$iv).expireAfterAccess(minutes$iv, TimeUnit.MINUTES).build();
        $this$iv = this.encoder.vocabulary$intellij_fullLine_local();
        FullLineTokenizer fullLineTokenizer = this;
        boolean $i$f$mapIndexed = false;
        void var4_9 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void s;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)s, (Object)((int)index)));
        }
        fullLineTokenizer.vocab = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        this.vocabIds = CollectionsKt.toHashSet((Iterable)this.getVocab().values());
    }

    @Override
    public int getVocabSize() {
        return this.vocabSize;
    }

    @Override
    public int getEosTokenId() {
        return this.eosTokenId;
    }

    @Override
    @NotNull
    public Set<Integer> getInvalidIds() {
        return this.invalidIds;
    }

    @NotNull
    public final List<List<Integer>> encode(@NotNull List<String> sentences, boolean bos, boolean eos, boolean reverse, double dropoutProb) {
        Intrinsics.checkNotNullParameter(sentences, (String)"sentences");
        if (dropoutProb < 0.0 || dropoutProb > 1.0) {
            throw new IllegalArgumentException("dropoutProb value must be in the range [0, 1]. Current value of dropoutProb = " + dropoutProb);
        }
        BaseEncoder.EncodingResult encodingResult = this.encoder.encodeAsIds(sentences, bos, eos, reverse, dropoutProb);
        if (encodingResult.getStatus().getCode() != 0 || encodingResult.getIds() == null) {
            throw new IllegalArgumentException(encodingResult.getStatus().getMessage());
        }
        return encodingResult.getIds();
    }

    public static /* synthetic */ List encode$default(FullLineTokenizer fullLineTokenizer, List list2, boolean bl, boolean bl2, boolean bl3, double d, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            d = 0.0;
        }
        return fullLineTokenizer.encode(list2, bl, bl2, bl3, d);
    }

    @NotNull
    public final List<String> decode(@NotNull List<? extends List<Integer>> ids2) {
        Intrinsics.checkNotNullParameter(ids2, (String)"ids");
        return this.encoder.decodeIds(ids2).getSentences();
    }

    private final List<Integer> encode(String sentence, boolean bos, boolean eos, boolean reverse, double dropoutProb) {
        return this.encode(CollectionsKt.listOf((Object)sentence), bos, eos, reverse, dropoutProb).get(0);
    }

    static /* synthetic */ List encode$default(FullLineTokenizer fullLineTokenizer, String string, boolean bl, boolean bl2, boolean bl3, double d, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            d = 0.0;
        }
        return fullLineTokenizer.encode(string, bl, bl2, bl3, d);
    }

    @NotNull
    public final String decode(@NotNull List<Integer> ids2) {
        Intrinsics.checkNotNullParameter(ids2, (String)"ids");
        return this.decode(CollectionsKt.listOf(ids2)).get(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<int[]> encode(@NotNull List<String> sentences) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(sentences, (String)"sentences");
        Iterable $this$map$iv = this.encode(sentences, false, false, false, 0.0);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list2 = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionsKt.toIntArray((Collection)((Collection)it)));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public int[] encode(@NotNull String sentence) {
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        return CollectionsKt.toIntArray((Collection)this.encode(sentence, false, false, false, 0.0));
    }

    @Override
    @NotNull
    public String decode(@NotNull int[] ids2) {
        Intrinsics.checkNotNullParameter((Object)ids2, (String)"ids");
        return this.decode(CollectionsKt.listOf((Object)ArraysKt.toList((int[])ids2))).get(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String decode(@NotNull int[] ids2, @NotNull String separator) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ids2, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        int[] $this$map$iv = ids2;
        boolean $i$f$map = false;
        int[] nArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.decode((int)it));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)separator, null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    public String decode(int id) {
        return this.encoder.idToSubword$intellij_fullLine_local(id, true);
    }

    @Override
    public boolean isValidString(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return true;
    }

    @Override
    @NotNull
    public Set<Integer> idsByRegex(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Object object = this.idsByRegexCache.get((Object)regex.getPattern(), arg_0 -> FullLineTokenizer.idsByRegex$lambda$2((Function1)new Function1<String, Set<? extends Integer>>(this, regex){
            final /* synthetic */ FullLineTokenizer this$0;
            final /* synthetic */ Regex $regex;
            {
                this.this$0 = $receiver;
                this.$regex = $regex;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Set<Integer> invoke(String it) {
                void $this$filterKeys$iv;
                Map<String, Integer> map = this.this$0.getVocab();
                Regex regex = this.$regex;
                boolean $i$f$filterKeys = false;
                LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                    String it2 = (String)entry$iv.getKey();
                    boolean bl = false;
                    if (!regex.containsMatchIn((CharSequence)it2)) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                return CollectionsKt.toSet((Iterable)((Map)result$iv).values());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Set)object;
    }

    @Override
    @NotNull
    public Map<String, Integer> getVocab() {
        return this.vocab;
    }

    @Override
    @NotNull
    public Set<Integer> getVocabIds() {
        return this.vocabIds;
    }

    private static final Set idsByRegex$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    public /* synthetic */ FullLineTokenizer(BaseEncoder encoder, DefaultConstructorMarker $constructor_marker) {
        this(encoder);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/completion/full/line/local/tokenizer/FullLineTokenizer$Companion;", "", "()V", "load", "Lorg/jetbrains/completion/full/line/local/tokenizer/FullLineTokenizer;", "modelFile", "Ljava/io/File;", "intellij.fullLine.local"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FullLineTokenizer load(@NotNull File modelFile) {
            Intrinsics.checkNotNullParameter((Object)modelFile, (String)"modelFile");
            return new FullLineTokenizer(BaseEncoder.Companion.load(modelFile), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

