/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.generation.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.local.generation.generation.SearchState;
import org.jetbrains.completion.full.line.local.generation.search.BeamSearchNode;
import org.jetbrains.completion.full.line.local.tokenizer.Tokenizer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/completion/full/line/local/generation/search/BeamSearchGraph;", "", "tokenizer", "Lorg/jetbrains/completion/full/line/local/tokenizer/Tokenizer;", "(Lorg/jetbrains/completion/full/line/local/tokenizer/Tokenizer;)V", "currentId", "", "nodes", "", "Lorg/jetbrains/completion/full/line/local/generation/search/BeamSearchNode;", "getNodes", "()Ljava/util/List;", "terminateHypotheses", "", "step", "indices", "", "update", "searchState", "Lorg/jetbrains/completion/full/line/local/generation/generation/SearchState;", "intellij.fullLine.local"})
@SourceDebugExtension(value={"SMAP\nBeamSearchInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeamSearchInfo.kt\norg/jetbrains/completion/full/line/local/generation/search/BeamSearchGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n618#2,12:81\n766#2:93\n857#2,2:94\n*S KotlinDebug\n*F\n+ 1 BeamSearchInfo.kt\norg/jetbrains/completion/full/line/local/generation/search/BeamSearchGraph\n*L\n20#1:81,12\n42#1:93\n42#1:94,2\n*E\n"})
public final class BeamSearchGraph {
    @NotNull
    private final Tokenizer tokenizer;
    @NotNull
    private final List<BeamSearchNode> nodes;
    private int currentId;

    public BeamSearchGraph(@NotNull Tokenizer tokenizer) {
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this.tokenizer = tokenizer;
        this.nodes = new ArrayList();
    }

    @NotNull
    public final List<BeamSearchNode> getNodes() {
        return this.nodes;
    }

    public final void update(@NotNull SearchState searchState) {
        Intrinsics.checkNotNullParameter((Object)searchState, (String)"searchState");
        int step = searchState.getLength() - 1;
        Iterator iterator2 = ArraysKt.zip((int[])searchState.getSortMask(), (int[])searchState.getLastPredictions()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            Pair id = (Pair)iterator2.next();
            String text = this.tokenizer.decode(((Number)id.getSecond()).intValue());
            BeamSearchNode parent = null;
            if (step != 0) {
                Iterable $this$single$iv = this.nodes;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    BeamSearchNode it = (BeamSearchNode)element$iv;
                    boolean bl = false;
                    if (!(it.getStep() == step - 1 && it.getStepId() == ((Number)id.getFirst()).intValue())) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                parent = single$iv;
            }
            int n2 = this.currentId;
            this.currentId = n2 + 1;
            BeamSearchNode node = new BeamSearchNode(n2, i, ((Number)id.getSecond()).intValue(), text, text, step, Math.exp(((Number)searchState.getHypothesesScores().get(i)).doubleValue()), Math.exp(((Number)CollectionsKt.last(searchState.getHypothesesProbabilities().get(i))).doubleValue()), parent, false, 512, null);
            this.nodes.add(node);
            if (parent == null) continue;
            parent.addChild(node);
            node.setFullText(parent.getFullText() + text);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void terminateHypotheses(int step, @NotNull List<Integer> indices) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        Iterable $this$filter$iv = this.nodes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BeamSearchNode it = (BeamSearchNode)element$iv$iv;
            boolean bl = false;
            if (!(it.getStep() == step)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List lastStepHypotheses = (List)destination$iv$iv;
        int currentId = 0;
        Iterator iterator2 = lastStepHypotheses.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            BeamSearchNode hyp = (BeamSearchNode)iterator2.next();
            if (indices.contains(hyp.getStepId())) {
                hyp.setStepId(lastStepHypotheses.size() - indices.size() + currentId++);
                hyp.setTerminated(true);
                continue;
            }
            hyp.setStepId(i - currentId);
        }
    }
}

