/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.files;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.LocalModelDescriptor;
import org.jetbrains.completion.full.line.LocalModelDescriptorKt;
import org.jetbrains.completion.full.line.local.HostApi;
import org.jetbrains.completion.full.line.local.JarModelExtractException;
import org.jetbrains.completion.full.line.local.ModelDownloadNetworkException;
import org.jetbrains.completion.full.line.local.ModelSchema;
import org.jetbrains.completion.full.line.local.ModelSchemaKt;
import org.jetbrains.completion.full.line.local.NativeServerExtractException;
import org.jetbrains.completion.full.line.local.NativeServerSchema;
import org.jetbrains.completion.full.line.local.files.LocalModelsDownloadManager;
import org.jetbrains.completion.full.line.logs.FullLineCodeCompletionLogs;
import org.jetbrains.completion.full.line.platform.diagnostics.DiagnosticsService;
import org.jetbrains.completion.full.line.platform.diagnostics.FullLineLogger;
import org.jetbrains.completion.full.line.platform.diagnostics.FullLinePart;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0007J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/completion/full/line/local/files/LocalModelsDownloadManager;", "", "root", "Ljava/io/File;", "(Ljava/io/File;)V", "collectFilesToDownload", "", "Lcom/intellij/util/download/DownloadableFileDescription;", "model", "Lorg/jetbrains/completion/full/line/local/ModelSchema;", "downloadableService", "Lcom/intellij/util/download/DownloadableFileService;", "localModelDescriptor", "Lorg/jetbrains/completion/full/line/LocalModelDescriptor;", "download", "downloadFiles", "", "filesToDownload", "schema", "downloadModelSchema", "version", "", "extractModel", "tag", "modelFolder", "extractNativeServer", "modelJar", "Companion", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nLocalModelsDownloadManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalModelsDownloadManager.kt\norg/jetbrains/completion/full/line/local/files/LocalModelsDownloadManager\n+ 2 converter.kt\norg/jetbrains/completion/full/line/local/ConverterKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 log.kt\norg/jetbrains/completion/full/line/platform/diagnostics/LogKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,154:1\n13#2,2:155\n766#3:157\n857#3,2:158\n1109#4,2:160\n13309#4,2:162\n59#5:164\n11#6:165\n*S KotlinDebug\n*F\n+ 1 LocalModelsDownloadManager.kt\norg/jetbrains/completion/full/line/local/files/LocalModelsDownloadManager\n*L\n57#1:155,2\n101#1:157\n101#1:158,2\n137#1:160,2\n137#1:162,2\n151#1:164\n151#1:165\n*E\n"})
public final class LocalModelsDownloadManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File root;
    @NotNull
    private static final FullLineLogger LOG;

    public LocalModelsDownloadManager(@NotNull File root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
    }

    @RequiresBackgroundThread
    @NotNull
    public final ModelSchema download(@NotNull LocalModelDescriptor localModelDescriptor) {
        Intrinsics.checkNotNullParameter((Object)localModelDescriptor, (String)"localModelDescriptor");
        String version = LocalModelDescriptorKt.selectModelVersion(localModelDescriptor);
        try {
            ModelSchema schema = this.downloadModelSchema(localModelDescriptor, version);
            DownloadableFileService downloadService = DownloadableFileService.getInstance();
            Intrinsics.checkNotNull((Object)downloadService);
            List<DownloadableFileDescription> filesToDownload = this.collectFilesToDownload(schema, downloadService, localModelDescriptor);
            LOG.info(CollectionsKt.joinToString$default((Iterable)filesToDownload, (CharSequence)"\n", (CharSequence)"Files to download:\n", null, (int)0, null, (Function1)download.1.INSTANCE, (int)28, null));
            this.downloadFiles(downloadService, filesToDownload, localModelDescriptor, schema);
            FullLineCodeCompletionLogs.INSTANCE.successfullyDownload(localModelDescriptor, version);
            return schema;
        }
        catch (ModelDownloadNetworkException e) {
            FullLineCodeCompletionLogs.INSTANCE.failedDownload(localModelDescriptor, version);
            throw e;
        }
    }

    private final ModelSchema downloadModelSchema(LocalModelDescriptor localModelDescriptor, String version) {
        String string;
        String host = HostApi.Companion.getInstance(version).model(localModelDescriptor);
        RequestBuilder request = HttpRequests.request((String)(host + "/" + version + "/model.xml"));
        try {
            string = (String)request.connect(LocalModelsDownloadManager::downloadModelSchema$lambda$0);
        }
        catch (IOException e) {
            throw new ModelDownloadNetworkException(e);
        }
        String content = string;
        Intrinsics.checkNotNull((Object)content);
        String xml$iv = content;
        boolean $i$f$decodeFromXml = false;
        Element element = JDOMUtil.load((CharSequence)xml$iv);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
        Element a$iv = element;
        return (ModelSchema)XmlSerializer.deserialize((Element)a$iv, ModelSchema.class);
    }

    private final List<DownloadableFileDescription> collectFilesToDownload(ModelSchema model, DownloadableFileService downloadableService, LocalModelDescriptor localModelDescriptor) {
        List list2;
        String modelHost = HostApi.Companion.getInstance(model).model(localModelDescriptor);
        String tag = localModelDescriptor.tag();
        String fileName = this.modelJar(tag, model.getVersion());
        List $this$collectFilesToDownload_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        DownloadableFileDescription downloadableFileDescription = downloadableService.createFileDescription(modelHost + "/" + model.getVersion() + "/" + fileName, fileName);
        Intrinsics.checkNotNullExpressionValue((Object)downloadableFileDescription, (String)"createFileDescription(...)");
        $this$collectFilesToDownload_u24lambda_u241.add(downloadableFileDescription);
        NativeServerSchema nativeServerSchema = model.getNative();
        if (nativeServerSchema != null) {
            NativeServerSchema nativeSchema = nativeServerSchema;
            String serverHost = HostApi.Companion.getInstance(nativeSchema).server(nativeSchema.getVersion(), nativeSchema.getArchive());
            DownloadableFileDescription downloadableFileDescription2 = downloadableService.createFileDescription(serverHost, nativeSchema.getArchive());
            Intrinsics.checkNotNullExpressionValue((Object)downloadableFileDescription2, (String)"createFileDescription(...)");
            $this$collectFilesToDownload_u24lambda_u241.add(downloadableFileDescription2);
        }
        return CollectionsKt.build((List)list2);
    }

    /*
     * WARNING - void declaration
     */
    private final void downloadFiles(DownloadableFileService downloadableService, List<? extends DownloadableFileDescription> filesToDownload, LocalModelDescriptor localModelDescriptor, ModelSchema schema) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        FileDownloader fileDownloader = downloadableService.createDownloader(filesToDownload, localModelDescriptor.getLanguage().getDisplayName() + " model");
        Intrinsics.checkNotNullExpressionValue((Object)fileDownloader, (String)"createDownloader(...)");
        FileDownloader downloader = fileDownloader;
        File modelFolder = FilesKt.resolve((File)this.root, (String)schema.uid());
        try {
            downloader.download(modelFolder);
            LOG.info(filesToDownload.size() + " files successfully download to " + modelFolder.getAbsolutePath());
        }
        catch (IOException e) {
            throw new ModelDownloadNetworkException(e);
        }
        this.extractModel(localModelDescriptor.tag(), schema.getVersion(), modelFolder);
        this.extractNativeServer(schema, modelFolder);
        Iterable e = SequencesKt.toList((Sequence)((Sequence)FilesKt.walkTopDown((File)modelFolder)));
        FullLineLogger fullLineLogger = LOG;
        boolean $i$f$filter = false;
        void var9_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.isFile()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        fullLineLogger.info(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", (CharSequence)"Result files:\n", null, (int)0, null, (Function1)downloadFiles.2.INSTANCE, (int)28, null));
    }

    private final void extractNativeServer(ModelSchema schema, File modelFolder) {
        block2: {
            NativeServerSchema nativeServerSchema = schema.getNative();
            if (nativeServerSchema == null) break block2;
            NativeServerSchema nativeSchema = nativeServerSchema;
            boolean bl = false;
            Path archive = FilesKt.resolve((File)modelFolder, (String)nativeSchema.getArchive()).toPath();
            Path extracted = FilesKt.resolve((File)modelFolder, (String)ModelSchemaKt.extractedName(nativeSchema)).toPath();
            try {
                ZipUtil.extract((Path)archive, (Path)extracted, null, (boolean)true);
                Intrinsics.checkNotNull((Object)extracted);
                LOG.info("Archive with native server extracted to " + ((Object)extracted.toAbsolutePath()).toString());
            }
            catch (IOException e) {
                throw new NativeServerExtractException(e);
            }
            Intrinsics.checkNotNull((Object)archive);
            PathKt.delete$default((Path)archive, (boolean)false, (int)1, null);
        }
    }

    private final void extractModel(String tag, String version, File modelFolder) {
        Object element$iv2;
        File extracted;
        block5: {
            Path archive = FilesKt.resolve((File)modelFolder, (String)this.modelJar(tag, version)).toPath();
            extracted = FilesKt.resolve((File)modelFolder, (String)("temp-" + tag + ".zip"));
            try {
                ZipUtil.extract((Path)archive, (Path)extracted.toPath(), null, (boolean)true);
                LOG.info("Jar file with model extracted to " + extracted.getAbsolutePath());
            }
            catch (IOException e) {
                throw new JarModelExtractException(e);
            }
            Intrinsics.checkNotNull((Object)archive);
            PathKt.delete$default((Path)archive, (boolean)false, (int)1, null);
            File[] fileArray = extracted.listFiles();
            Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
            Object[] $this$first$iv = fileArray;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                File it = (File)element$iv2;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)(tag + "-"), (boolean)false, (int)2, null)) {
                    continue;
                }
                break block5;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        File[] fileArray = ((File)element$iv2).listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
        Object[] $this$forEach$iv = fileArray;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            Path path2;
            Path path3;
            File it = (File)element$iv3;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.toPath(), (String)"toPath(...)");
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Intrinsics.checkNotNullExpressionValue((Object)FilesKt.resolve((File)modelFolder, (String)string).toPath(), (String)"toPath(...)");
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.move(path3, path2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"move(...)");
        }
        FilesKt.deleteRecursively((File)extracted);
    }

    private final String modelJar(String tag, String version) {
        String string = tag.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String fixedId = string;
        if (Intrinsics.areEqual((Object)fixedId, (Object)"python")) {
            fixedId = "python-v2";
        }
        return "local-model-" + fixedId + "-" + version + ".jar";
    }

    private static final String downloadModelSchema$lambda$0(HttpRequests.Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BufferedReader bufferedReader = it.getReader();
        Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"getReader(...)");
        return TextStreamsKt.readText((Reader)bufferedReader);
    }

    static {
        FullLinePart part$iv = FullLinePart.MODELS_MANAGER;
        boolean $i$f$logger = false;
        DiagnosticsService diagnosticsService = DiagnosticsService.Companion.getInstance();
        boolean $i$f$logger2 = false;
        Logger logger2 = Logger.getInstance(LocalModelsDownloadManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = diagnosticsService.logger(part$iv, logger2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/completion/full/line/local/files/LocalModelsDownloadManager$Companion;", "", "()V", "LOG", "Lorg/jetbrains/completion/full/line/platform/diagnostics/FullLineLogger;", "intellij.fullLine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

