/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.files;

import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.FullLineNotifications;
import org.jetbrains.completion.full.line.FullLinePluginInfo;
import org.jetbrains.completion.full.line.local.files.DownloadModelConsentPolicy;
import org.jetbrains.completion.full.line.settings.FullLineBundle;

@Service(value={Service.Level.APP})
@State(name="DownloadModelConsentState", storages={@Storage(value="full.line.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0000H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0000H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u001c\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dJ\u001c\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dJ\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002R&\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/completion/full/line/local/files/LocalModelsDownloadConsentManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "()V", "value", "Lorg/jetbrains/completion/full/line/local/files/DownloadModelConsentPolicy;", "consentPolicy", "getConsentPolicy", "()Lorg/jetbrains/completion/full/line/local/files/DownloadModelConsentPolicy;", "setConsentPolicy", "(Lorg/jetbrains/completion/full/line/local/files/DownloadModelConsentPolicy;)V", "consentedLanguages", "", "Lcom/intellij/lang/Language;", "lastNotificationTimestamps", "", "", "", "getState", "grantLanguageConsent", "", "language", "isConsentCompletelyRefused", "", "isConsented", "loadState", "state", "shouldNotificationBeShown", "withGrantingConsent", "onConsentGranted", "Lkotlin/Function0;", "withRequestingConsent", "withdrawLanguageConsent", "Companion", "intellij.fullLine"})
public final class LocalModelsDownloadConsentManager
implements PersistentStateComponent<LocalModelsDownloadConsentManager> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Transient
    @NotNull
    private final Set<Language> consentedLanguages = new LinkedHashSet();
    @Property
    @MapAnnotation(keyAttributeName="language", valueAttributeName="lastNotificationTimestamp")
    @NotNull
    private final Map<String, Long> lastNotificationTimestamps = new LinkedHashMap();
    @Property
    @NotNull
    private volatile DownloadModelConsentPolicy consentPolicy = org.jetbrains.completion.full.line.local.files.LocalModelsDownloadConsentManager$Companion.access$defaultPolicy(Companion);
    private static final long notificationPeriodDuration = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.DAYS);

    @NotNull
    public final DownloadModelConsentPolicy getConsentPolicy() {
        return this.consentPolicy;
    }

    public final void setConsentPolicy(@NotNull DownloadModelConsentPolicy value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        ThreadingAssertions.assertEventDispatchThread();
        this.consentPolicy = value;
    }

    public final boolean isConsented(@NotNull Language language2) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        return this.consentPolicy == DownloadModelConsentPolicy.AUTOMATICALLY || this.consentedLanguages.contains(language2);
    }

    public final void withRequestingConsent(@NotNull Language language2, @NotNull Function0<Unit> onConsentGranted) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        Intrinsics.checkNotNullParameter(onConsentGranted, (String)"onConsentGranted");
        if (this.isConsented(language2)) {
            onConsentGranted.invoke();
            return;
        }
        if (this.isConsentCompletelyRefused() || !this.shouldNotificationBeShown(language2)) {
            return;
        }
        if (ConfigImportHelper.isFirstSession() || ConfigImportHelper.isConfigImported()) {
            return;
        }
        String string = FullLineBundle.Companion.message("full.line.ask.download.model.title", new Object[0]);
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)language2.getDisplayName(), (String)"getDisplayName(...)");
        String string2 = FullLineBundle.Companion.message("full.line.ask.download.model.content", objectArray);
        objectArray = new AnAction[]{FullLineNotifications.INSTANCE.action(FullLineBundle.Companion.message("full.line.ask.download.model.action.consented.content", new Object[0]), (Function2<? super AnActionEvent, ? super Notification, Unit>)((Function2)new Function2<AnActionEvent, Notification, Unit>(this, language2, onConsentGranted){
            final /* synthetic */ LocalModelsDownloadConsentManager this$0;
            final /* synthetic */ Language $language;
            final /* synthetic */ Function0<Unit> $onConsentGranted;
            {
                this.this$0 = $receiver;
                this.$language = $language;
                this.$onConsentGranted = $onConsentGranted;
                super(2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@Nullable AnActionEvent anActionEvent, @NotNull Notification notification2) {
                Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                LocalModelsDownloadConsentManager.access$grantLanguageConsent(this.this$0, this.$language);
                try {
                    this.$onConsentGranted.invoke();
                }
                finally {
                    LocalModelsDownloadConsentManager.access$withdrawLanguageConsent(this.this$0, this.$language);
                    notification2.expire();
                }
            }
        })), FullLineNotifications.INSTANCE.action(FullLineBundle.Companion.message("full.line.ask.download.model.action.consent.automatic.content", new Object[0]), (Function2<? super AnActionEvent, ? super Notification, Unit>)((Function2)new Function2<AnActionEvent, Notification, Unit>(this, onConsentGranted){
            final /* synthetic */ LocalModelsDownloadConsentManager this$0;
            final /* synthetic */ Function0<Unit> $onConsentGranted;
            {
                this.this$0 = $receiver;
                this.$onConsentGranted = $onConsentGranted;
                super(2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@Nullable AnActionEvent anActionEvent, @NotNull Notification notification2) {
                Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                this.this$0.setConsentPolicy(DownloadModelConsentPolicy.AUTOMATICALLY);
                try {
                    this.$onConsentGranted.invoke();
                }
                finally {
                    notification2.expire();
                }
            }
        })), FullLineNotifications.INSTANCE.action(FullLineBundle.Companion.message("full.line.ask.download.model.action.consent.manual.content", new Object[0]), (Function2<? super AnActionEvent, ? super Notification, Unit>)((Function2)new Function2<AnActionEvent, Notification, Unit>(this){
            final /* synthetic */ LocalModelsDownloadConsentManager this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@Nullable AnActionEvent anActionEvent, @NotNull Notification notification2) {
                Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                this.this$0.setConsentPolicy(DownloadModelConsentPolicy.MANUALLY);
                notification2.expire();
            }
        }))};
        FullLineNotifications.showFullContentBalloon$default(FullLineNotifications.INSTANCE, null, string, string2, NotificationType.INFORMATION, (AnAction[])objectArray, null, 32, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void withGrantingConsent(@NotNull Language language2, @NotNull Function0<Unit> onConsentGranted) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        Intrinsics.checkNotNullParameter(onConsentGranted, (String)"onConsentGranted");
        if (this.isConsented(language2)) {
            onConsentGranted.invoke();
        } else {
            this.grantLanguageConsent(language2);
            try {
                onConsentGranted.invoke();
            }
            finally {
                this.withdrawLanguageConsent(language2);
            }
        }
    }

    private final void grantLanguageConsent(Language language2) {
        if (!(!this.isConsentCompletelyRefused())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        ((Collection)this.consentedLanguages).add(language2);
    }

    private final void withdrawLanguageConsent(Language language2) {
        if (!(!this.isConsentCompletelyRefused())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!this.isConsented(language2)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        ((Collection)this.consentedLanguages).remove(language2);
    }

    private final boolean isConsentCompletelyRefused() {
        return this.consentPolicy == DownloadModelConsentPolicy.MANUALLY;
    }

    private final boolean shouldNotificationBeShown(Language language2) {
        boolean bl;
        Long l = this.lastNotificationTimestamps.get(language2.getID());
        long lastTimestamp = l != null ? l : 0L;
        long currentTime = System.currentTimeMillis();
        if (Duration.compareTo-LRDsOJo((long)DurationKt.toDuration((long)(currentTime - lastTimestamp), (DurationUnit)DurationUnit.MILLISECONDS), (long)notificationPeriodDuration) > 0) {
            Map<String, Long> map = this.lastNotificationTimestamps;
            String string = language2.getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
            String string2 = string;
            Long l2 = currentTime;
            map.put(string2, l2);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public LocalModelsDownloadConsentManager getState() {
        return this;
    }

    public void loadState(@NotNull LocalModelsDownloadConsentManager state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public static final /* synthetic */ void access$grantLanguageConsent(LocalModelsDownloadConsentManager $this, Language language2) {
        $this.grantLanguageConsent(language2);
    }

    public static final /* synthetic */ void access$withdrawLanguageConsent(LocalModelsDownloadConsentManager $this, Language language2) {
        $this.withdrawLanguageConsent(language2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\n"}, d2={"Lorg/jetbrains/completion/full/line/local/files/LocalModelsDownloadConsentManager$Companion;", "", "()V", "notificationPeriodDuration", "Lkotlin/time/Duration;", "J", "defaultPolicy", "Lorg/jetbrains/completion/full/line/local/files/DownloadModelConsentPolicy;", "getInstance", "Lorg/jetbrains/completion/full/line/local/files/LocalModelsDownloadConsentManager;", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nLocalModelsDownloadConsentManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalModelsDownloadConsentManager.kt\norg/jetbrains/completion/full/line/local/files/LocalModelsDownloadConsentManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,182:1\n42#2,3:183\n*S KotlinDebug\n*F\n+ 1 LocalModelsDownloadConsentManager.kt\norg/jetbrains/completion/full/line/local/files/LocalModelsDownloadConsentManager$Companion\n*L\n169#1:183,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalModelsDownloadConsentManager getInstance() {
            boolean $i$f$service = false;
            Class<LocalModelsDownloadConsentManager> serviceClass$iv = LocalModelsDownloadConsentManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (LocalModelsDownloadConsentManager)object;
        }

        private final DownloadModelConsentPolicy defaultPolicy() {
            return ApplicationKt.getApplication().isUnitTestMode() ? DownloadModelConsentPolicy.AUTOMATICALLY : (FullLinePluginInfo.INSTANCE.isMarketplaceBuild() ? DownloadModelConsentPolicy.AUTOMATICALLY : DownloadModelConsentPolicy.ASK_BEFORE_DOWNLOAD);
        }

        public static final /* synthetic */ DownloadModelConsentPolicy access$defaultPolicy(Companion $this) {
            return $this.defaultPolicy();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

