/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.files;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.completion.full.line.LocalModelDescriptor;
import org.jetbrains.completion.full.line.LocalModelDescriptorKt;
import org.jetbrains.completion.full.line.local.HostApi;
import org.jetbrains.completion.full.line.local.ModelSchema;
import org.jetbrains.completion.full.line.local.ModelSchemaKt;
import org.jetbrains.completion.full.line.local.NativeServerSchema;
import org.jetbrains.completion.full.line.local.files.LocalModelsFilesService;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/completion/full/line/local/files/LocalModelsBundleManager;", "", "()V", "extractNativeServerFromBundle", "Ljava/io/File;", "schema", "Lorg/jetbrains/completion/full/line/local/ModelSchema;", "destination", "getFileFromZip", "", "zipFilePath", "name", "", "getFileURL", "Ljava/net/URL;", "tag", "version", "file", "isBundled", "", "descriptor", "Lorg/jetbrains/completion/full/line/LocalModelDescriptor;", "unpackBundled", "unpackBundledFromLib", "Companion", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nLocalModelsBundleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalModelsBundleManager.kt\norg/jetbrains/completion/full/line/local/files/LocalModelsBundleManager\n+ 2 converter.kt\norg/jetbrains/completion/full/line/local/ConverterKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,118:1\n13#2,2:119\n13#2,2:124\n1#3:121\n1855#4,2:122\n1855#4,2:126\n123#5,2:128\n*S KotlinDebug\n*F\n+ 1 LocalModelsBundleManager.kt\norg/jetbrains/completion/full/line/local/files/LocalModelsBundleManager\n*L\n35#1:119,2\n66#1:124,2\n50#1:122,2\n72#1:126,2\n105#1:128,2\n*E\n"})
public final class LocalModelsBundleManager {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean isBundled(@NotNull LocalModelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        String tag = descriptor.tag();
        File file2 = PluginPathManager.getPluginResource(this.getClass(), (String)("full-line-model-" + tag + ".zip"));
        return file2 != null ? file2.exists() : false;
    }

    @Nullable
    public final ModelSchema unpackBundled(@NotNull LocalModelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        String tag = descriptor.tag();
        File file2 = PluginPathManager.getPluginResource(this.getClass(), (String)("full-line-model-" + tag + ".zip"));
        if (file2 == null) {
            return null;
        }
        File bundleModelFile = file2;
        if (!bundleModelFile.exists()) {
            return null;
        }
        byte[] schemaContent = this.getFileFromZip(bundleModelFile, "model.xml");
        String xml$iv = StringsKt.decodeToString((byte[])schemaContent);
        boolean $i$f$decodeFromXml22 = false;
        Element element = JDOMUtil.load((CharSequence)xml$iv);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
        Object a$iv = element;
        ModelSchema schema = (ModelSchema)XmlSerializer.deserialize((Element)a$iv, ModelSchema.class);
        if (!Intrinsics.areEqual((Object)schema.getVersion(), (Object)LocalModelDescriptorKt.selectModelVersion(descriptor))) {
            return null;
        }
        Object[] $i$f$decodeFromXml22 = new String[]{"model.xml", schema.getBinary().getPath(), schema.getBpe().getPath(), schema.getConfig().getPath()};
        List filesToMoveFromModel = CollectionsKt.listOf((Object[])$i$f$decodeFromXml22);
        Object it = a$iv = FilesKt.resolve((File)LocalModelsFilesService.Companion.getInstance().getRoot(), (String)schema.uid());
        boolean bl = false;
        Files.createDirectories(((File)it).toPath(), new FileAttribute[0]);
        Object destination = a$iv;
        Iterable $this$forEach$iv = filesToMoveFromModel;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl2 = false;
            byte[] input = this.getFileFromZip(bundleModelFile, it2);
            FilesKt.writeBytes((File)FilesKt.resolve((File)destination, (String)it2), (byte[])input);
        }
        this.extractNativeServerFromBundle(schema, (File)destination);
        return schema;
    }

    @TestOnly
    @Nullable
    public final ModelSchema unpackBundledFromLib(@NotNull LocalModelDescriptor descriptor) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        String string = descriptor.getCustomTag();
        if (string == null) {
            String string2 = descriptor.getLanguage().getID();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getID(...)");
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        }
        String tag = string;
        String version = LocalModelDescriptorKt.selectModelVersion(descriptor);
        URL uRL = this.getFileURL(tag, version, "model.xml");
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
        String schemaContent = new String(byArray, charset);
        boolean $i$f$decodeFromXml = false;
        Object[] objectArray = JDOMUtil.load((CharSequence)schemaContent);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"load(...)");
        Object[] a$iv = objectArray;
        ModelSchema schema = (ModelSchema)XmlSerializer.deserialize((Element)a$iv, ModelSchema.class);
        a$iv = new String[]{"model.xml", schema.getBinary().getPath(), schema.getBpe().getPath(), schema.getConfig().getPath()};
        List filesToMoveFromModel = CollectionsKt.listOf((Object[])a$iv);
        File it = file2 = FilesKt.resolve((File)LocalModelsFilesService.Companion.getInstance().getRoot(), (String)schema.uid());
        boolean bl = false;
        Files.createDirectories(it.toPath(), new FileAttribute[0]);
        File destination = file2;
        Iterable $this$forEach$iv = filesToMoveFromModel;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl2 = false;
            InputStream input = this.getFileURL(tag, version, it2).openStream();
            File file3 = FilesKt.resolve((File)destination, (String)it2);
            Intrinsics.checkNotNull((Object)input);
            FilesKt.writeBytes((File)file3, (byte[])ByteStreamsKt.readBytes((InputStream)input));
        }
        this.extractNativeServerFromBundle(schema, destination);
        return schema;
    }

    private final File extractNativeServerFromBundle(ModelSchema schema, File destination) {
        NativeServerSchema nativeServerSchema = schema.getNative();
        Intrinsics.checkNotNull((Object)nativeServerSchema);
        NativeServerSchema nativeSchema = nativeServerSchema;
        File file2 = PluginPathManager.getPluginResource(this.getClass(), (String)"full-line-native.zip");
        if (file2 == null) {
            return null;
        }
        File bundleServerFile = file2;
        byte[] nativeBytes = this.getFileFromZip(bundleServerFile, HostApi.Companion.getOs() + "/" + HostApi.Companion.getCpu() + "/" + nativeSchema.getArchive());
        File temp = FilesKt.resolve((File)LocalModelsFilesService.Companion.getInstance().getRoot(), (String)("temp-" + UUID.randomUUID() + ".zip"));
        try {
            FilesKt.writeBytes((File)temp, (byte[])nativeBytes);
            ZipUtil.extract((Path)temp.toPath(), (Path)FilesKt.resolve((File)destination, (String)ModelSchemaKt.extractedName(nativeSchema)).toPath(), null, (boolean)true);
            temp.delete();
        }
        finally {
            temp.delete();
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final byte[] getFileFromZip(File zipFilePath, String name) {
        byte[] byArray;
        Closeable closeable = new ZipFile(zipFilePath);
        Throwable throwable = null;
        try {
            Object element$iv2;
            ZipFile zip2;
            block6: {
                void $this$first$iv;
                zip2 = (ZipFile)closeable;
                boolean bl = false;
                Enumeration<? extends ZipEntry> enumeration = zip2.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
                Sequence sequence2 = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    ZipEntry it = (ZipEntry)element$iv2;
                    boolean bl2 = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!StringsKt.endsWith$default((String)string, (String)name, (boolean)false, (int)2, null)) continue;
                    break block6;
                }
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            ZipEntry it = (ZipEntry)element$iv2;
            boolean bl = false;
            InputStream inputStream2 = zip2.getInputStream(it);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
            byArray = ByteStreamsKt.readBytes((InputStream)inputStream2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    private final URL getFileURL(String tag, String version, String file2) {
        URL uRL = this.getClass().getClassLoader().getResource(tag + "-" + version + "/" + file2);
        Intrinsics.checkNotNull((Object)uRL);
        return uRL;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/completion/full/line/local/files/LocalModelsBundleManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/completion/full/line/local/files/LocalModelsBundleManager;", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nLocalModelsBundleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalModelsBundleManager.kt\norg/jetbrains/completion/full/line/local/files/LocalModelsBundleManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,118:1\n42#2,3:119\n*S KotlinDebug\n*F\n+ 1 LocalModelsBundleManager.kt\norg/jetbrains/completion/full/line/local/files/LocalModelsBundleManager$Companion\n*L\n115#1:119,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalModelsBundleManager getInstance() {
            boolean $i$f$service = false;
            Class<LocalModelsBundleManager> serviceClass$iv = LocalModelsBundleManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (LocalModelsBundleManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

