/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.kotlin.supporters.correctness;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.ml.impl.correctness.checker.CorrectnessError;
import com.intellij.platform.ml.impl.correctness.checker.CustomSemanticChecker;
import com.intellij.platform.ml.impl.correctness.checker.Severity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.kotlin.supporters.KotlinFullLineSupporter;
import org.jetbrains.completion.full.line.kotlin.supporters.KotlinImportFixer;
import org.jetbrains.completion.full.line.kotlin.supporters.correctness.KotlinSemanticChecker;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.components.KtDiagnosticCheckerFilter;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnosticWithPsi;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J.\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00122\u0006\u0010\b\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/completion/full/line/kotlin/supporters/correctness/KotlinSemanticChecker;", "Lcom/intellij/platform/ml/impl/correctness/checker/CustomSemanticChecker;", "()V", "findErrors", "", "Lcom/intellij/platform/ml/impl/correctness/checker/CorrectnessError;", "originalPsi", "Lcom/intellij/psi/PsiFile;", "element", "Lcom/intellij/psi/PsiElement;", "offset", "", "prefix", "", "suggestion", "findErrorsByKotlinDiagnostics", "getUnresolvedReferenceSeverity", "Lcom/intellij/platform/ml/impl/correctness/checker/Severity;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Companion", "intellij.fullLine.kotlin"})
@SourceDebugExtension(value={"SMAP\nKotlinCorrectnessChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCorrectnessChecker.kt\norg/jetbrains/completion/full/line/kotlin/supporters/correctness/KotlinSemanticChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 4 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,174:1\n1#2:175\n1#2:198\n29#3,2:176\n46#4:178\n60#4,4:179\n65#4,2:186\n67#4:204\n1360#5:183\n1446#5,2:184\n1603#5,9:188\n1855#5:197\n1856#5:199\n1612#5:200\n1448#5,3:201\n11#6:205\n*S KotlinDebug\n*F\n+ 1 KotlinCorrectnessChecker.kt\norg/jetbrains/completion/full/line/kotlin/supporters/correctness/KotlinSemanticChecker\n*L\n92#1:198\n84#1:176,2\n84#1:178\n84#1:179,4\n84#1:186,2\n84#1:204\n85#1:183\n85#1:184,2\n92#1:188,9\n92#1:197\n92#1:199\n92#1:200\n85#1:201,3\n114#1:205\n*E\n"})
final class KotlinSemanticChecker
extends CustomSemanticChecker {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Lazy<List<String>> CRITICAL_ERRORS$delegate;
    @NotNull
    private static final Lazy<List<String>> ACCEPTABLE_ERRORS$delegate;

    @NotNull
    public List<CorrectnessError> findErrors(@NotNull PsiFile originalPsi, @NotNull PsiElement element, int offset, @NotNull String prefix2, @NotNull String suggestion) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)originalPsi, (String)"originalPsi");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        KotlinSemanticChecker kotlinSemanticChecker = this;
        try {
            KotlinSemanticChecker $this$findErrors_u24lambda_u240 = kotlinSemanticChecker;
            boolean bl = false;
            object = Result.constructor-impl($this$findErrors_u24lambda_u240.findErrorsByKotlinDiagnostics(element, offset, prefix2, suggestion));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        List foundErrors = (List)LoggerKt.getOrLogException((Object)object, (Logger)LOG);
        if (foundErrors != null) {
            return foundErrors;
        }
        TextRange textRange = TextRange.allOf((String)suggestion);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"allOf(...)");
        return CollectionsKt.listOf((Object)new CorrectnessError(textRange, Severity.CRITICAL, "Unexpected exception during analyzing Kotlin code"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<CorrectnessError> findErrorsByKotlinDiagnostics(PsiElement element, int offset, String prefix2, String suggestion) {
        List list2;
        void this_$iv$iv$iv;
        void this_$iv$iv;
        if (!(element instanceof KtElement)) {
            return CollectionsKt.emptyList();
        }
        KtElement useSiteKtElement$iv = (KtElement)element;
        boolean $i$f$analyze = false;
        Project project = useSiteKtElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtAnalysisSessionProvider ktAnalysisSessionProvider = KtAnalysisSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyse = false;
        void var9_9 = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession(useSiteKtElement$iv);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        this_$iv$iv$iv.getTokenFactory().beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            void $this$flatMapTo$iv$iv;
            KtAnalysisSession $this$findErrorsByKotlinDiagnostics_u24lambda_u243 = analysisSession$iv$iv$iv;
            boolean bl = false;
            Iterable $this$flatMap$iv = $this$findErrorsByKotlinDiagnostics_u24lambda_u243.getDiagnostics((KtElement)element, KtDiagnosticCheckerFilter.ONLY_COMMON_CHECKERS);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapNotNullTo$iv$iv;
                Severity severity;
                KtDiagnosticWithPsi diagnostic = (KtDiagnosticWithPsi)element$iv$iv;
                boolean bl2 = false;
                String string = diagnostic.getFactoryName();
                if ((Intrinsics.areEqual((Object)string, (Object)FirErrors.INSTANCE.getUNRESOLVED_REFERENCE().getName()) ? this.getUnresolvedReferenceSeverity($this$findErrorsByKotlinDiagnostics_u24lambda_u243, (KtElement)element) : (CollectionsKt.contains((Iterable)Companion.getCRITICAL_ERRORS(), (Object)string) ? Severity.CRITICAL : (CollectionsKt.contains((Iterable)Companion.getACCEPTABLE_ERRORS(), (Object)string) ? Severity.ACCEPTABLE : null))) == null) {
                    List list3 = CollectionsKt.emptyList();
                    return list3;
                }
                Severity severity2 = severity;
                Iterable $this$mapNotNull$iv = diagnostic.getTextRanges();
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    CorrectnessError correctnessError;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    TextRange errorTextRange = (TextRange)element$iv$iv2;
                    boolean bl4 = false;
                    if (this.getLocationInSuggestion(errorTextRange, offset, prefix2, suggestion) == null) {
                        correctnessError = null;
                    } else {
                        TextRange errorLocation;
                        String string2 = diagnostic.getFactoryName();
                        if (string2 == null) {
                            string2 = "unknown Kotlin diagnostics problem";
                        }
                        correctnessError = new CorrectnessError(errorLocation, severity2, string2);
                    }
                    if (correctnessError == null) continue;
                    CorrectnessError it$iv$iv = correctnessError;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        finally {
            this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
        return list2;
    }

    private final Severity getUnresolvedReferenceSeverity(KtAnalysisSession $this$getUnresolvedReferenceSeverity, KtElement element) {
        if (!(element instanceof KtSimpleNameExpression)) {
            return null;
        }
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinLanguage, (String)"INSTANCE");
        FullLineLanguageSupporter fullLineLanguageSupporter = FullLineLanguageSupporter.Companion.getInstance((Language)kotlinLanguage);
        Intrinsics.checkNotNull((Object)fullLineLanguageSupporter, (String)"null cannot be cast to non-null type org.jetbrains.completion.full.line.kotlin.supporters.KotlinFullLineSupporter");
        KotlinImportFixer importFixer2 = ((KotlinFullLineSupporter)fullLineLanguageSupporter).getImportFixer();
        return importFixer2.isFixableByAutoImport((KtSimpleNameExpression)element) ? Severity.ACCEPTABLE : Severity.CRITICAL;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(KotlinSemanticChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        CRITICAL_ERRORS$delegate = LazyKt.lazy((Function0)Companion.CRITICAL_ERRORS.2.INSTANCE);
        ACCEPTABLE_ERRORS$delegate = LazyKt.lazy((Function0)Companion.ACCEPTABLE_ERRORS.2.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/completion/full/line/kotlin/supporters/correctness/KotlinSemanticChecker$Companion;", "", "()V", "ACCEPTABLE_ERRORS", "", "", "getACCEPTABLE_ERRORS", "()Ljava/util/List;", "ACCEPTABLE_ERRORS$delegate", "Lkotlin/Lazy;", "CRITICAL_ERRORS", "getCRITICAL_ERRORS", "CRITICAL_ERRORS$delegate", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.fullLine.kotlin"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final List<String> getCRITICAL_ERRORS() {
            Lazy lazy = CRITICAL_ERRORS$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public final List<String> getACCEPTABLE_ERRORS() {
            Lazy lazy = ACCEPTABLE_ERRORS$delegate;
            return (List)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

