/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.kotlin.supporters;

import com.intellij.lang.Language;
import com.intellij.platform.ml.impl.correctness.checker.CorrectnessCheckerBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.FullLineCompletionMode;
import org.jetbrains.completion.full.line.FullLineParams;
import org.jetbrains.completion.full.line.ProposalTransformer;
import org.jetbrains.completion.full.line.ProposalsFilter;
import org.jetbrains.completion.full.line.ValuableCharacterAfterCaretFilter;
import org.jetbrains.completion.full.line.kotlin.relevance.models.KotlinInlineFilterModelService;
import org.jetbrains.completion.full.line.kotlin.supporters.KotlinEnclosuresLexer;
import org.jetbrains.completion.full.line.kotlin.supporters.KotlinFullLineSupporter;
import org.jetbrains.completion.full.line.kotlin.supporters.KotlinImportFixer;
import org.jetbrains.completion.full.line.language.CodeFormatter;
import org.jetbrains.completion.full.line.language.FullLinePipelineConfiguration;
import org.jetbrains.completion.full.line.language.FullLineStringLiteralSupporter;
import org.jetbrains.completion.full.line.language.LangState;
import org.jetbrains.completion.full.line.language.ModelSettings;
import org.jetbrains.completion.full.line.language.SkipLocationReason;
import org.jetbrains.completion.full.line.language.enclosure.FullLineEnclosures;
import org.jetbrains.completion.full.line.language.enclosure.FullLineEnclosuresLexer;
import org.jetbrains.completion.full.line.language.supporters.BaseFullLineLanguageSupporter;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSettings;
import org.jetbrains.completion.full.line.relevance.RelevanceModelService;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.NotUnderContentRootModuleInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u00109\u001a\u00020:H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\b\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0016\u001a\u00020\u00178VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\b\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010%R\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010%R\u0014\u00100\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010%R\u001b\u00102\u001a\u0002038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010\b\u001a\u0004\b4\u00105\u00a8\u0006="}, d2={"Lorg/jetbrains/completion/full/line/kotlin/supporters/KotlinFullLineSupporter;", "Lorg/jetbrains/completion/full/line/language/supporters/BaseFullLineLanguageSupporter;", "()V", "correctnessChecker", "Lcom/intellij/platform/ml/impl/correctness/checker/CorrectnessCheckerBase;", "getCorrectnessChecker", "()Lcom/intellij/platform/ml/impl/correctness/checker/CorrectnessCheckerBase;", "correctnessChecker$delegate", "Lkotlin/Lazy;", "defaultModelSettings", "Lorg/jetbrains/completion/full/line/language/ModelSettings;", "getDefaultModelSettings", "()Lorg/jetbrains/completion/full/line/language/ModelSettings;", "enclosures", "Lorg/jetbrains/completion/full/line/language/enclosure/FullLineEnclosures;", "getEnclosures", "()Lorg/jetbrains/completion/full/line/language/enclosure/FullLineEnclosures;", "enclosuresLexer", "Lorg/jetbrains/completion/full/line/language/enclosure/FullLineEnclosuresLexer;", "getEnclosuresLexer", "()Lorg/jetbrains/completion/full/line/language/enclosure/FullLineEnclosuresLexer;", "enclosuresLexer$delegate", "formatter", "Lorg/jetbrains/completion/full/line/language/CodeFormatter;", "getFormatter", "()Lorg/jetbrains/completion/full/line/language/CodeFormatter;", "formatter$delegate", "importFixer", "Lorg/jetbrains/completion/full/line/kotlin/supporters/KotlinImportFixer;", "getImportFixer", "()Lorg/jetbrains/completion/full/line/kotlin/supporters/KotlinImportFixer;", "inlineFilterModelService", "Lorg/jetbrains/completion/full/line/relevance/RelevanceModelService;", "getInlineFilterModelService", "()Lorg/jetbrains/completion/full/line/relevance/RelevanceModelService;", "isInOnlineExperiment", "", "()Z", "langState", "Lorg/jetbrains/completion/full/line/language/LangState;", "getLangState", "()Lorg/jetbrains/completion/full/line/language/LangState;", "languageSettings", "Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSettings;", "getLanguageSettings", "()Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSettings;", "shouldRefreshModelOnStartup", "getShouldRefreshModelOnStartup", "showInSettings", "getShowInSettings", "stringLiteralSupporter", "Lorg/jetbrains/completion/full/line/language/FullLineStringLiteralSupporter;", "getStringLiteralSupporter", "()Lorg/jetbrains/completion/full/line/language/FullLineStringLiteralSupporter;", "stringLiteralSupporter$delegate", "configurePipeline", "Lorg/jetbrains/completion/full/line/language/FullLinePipelineConfiguration;", "parameters", "Lorg/jetbrains/completion/full/line/FullLineParams;", "skipLocation", "Lorg/jetbrains/completion/full/line/language/SkipLocationReason;", "intellij.fullLine.kotlin"})
public final class KotlinFullLineSupporter
extends BaseFullLineLanguageSupporter {
    private final boolean isInOnlineExperiment;
    @NotNull
    private final Lazy formatter$delegate = LazyKt.lazy((Function0)formatter.2.INSTANCE);
    @NotNull
    private final LangState langState = new LangState(true, false, true, null, false, true, 1, false, 0, 410, null);
    @NotNull
    private final ModelSettings defaultModelSettings;
    @NotNull
    private final FullLineLanguageSettings languageSettings;
    @NotNull
    private final RelevanceModelService inlineFilterModelService;
    @NotNull
    private final KotlinImportFixer importFixer;
    @NotNull
    private final FullLineEnclosures enclosures;
    @NotNull
    private final Lazy enclosuresLexer$delegate;
    @NotNull
    private final Lazy stringLiteralSupporter$delegate;
    @NotNull
    private final Lazy correctnessChecker$delegate;
    private final boolean shouldRefreshModelOnStartup;

    public KotlinFullLineSupporter() {
        this.isInOnlineExperiment = true;
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinLanguage, (String)"INSTANCE");
        this.defaultModelSettings = new ModelSettings((Language)kotlinLanguage, null, "0.1.146-native-onnx-bundle", "0.1.143-native-llama-bundle", null, null, 0, 0, false, 0.0, 0.0, null, null, false, false, null, false, null, 196592, null);
        this.languageSettings = new FullLineLanguageSettings(null, null, 3, null);
        this.inlineFilterModelService = new KotlinInlineFilterModelService();
        this.importFixer = new KotlinImportFixer();
        this.enclosures = new FullLineEnclosures(super.getEnclosures().getOpenToCloseBrackets(), SetsKt.plus(super.getEnclosures().getStringMarkers(), (Object)Character.valueOf('`')));
        this.enclosuresLexer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KotlinEnclosuresLexer>(this){
            final /* synthetic */ KotlinFullLineSupporter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final KotlinEnclosuresLexer invoke() {
                return new KotlinEnclosuresLexer(this.this$0.getEnclosures());
            }
        }));
        this.stringLiteralSupporter$delegate = LazyKt.lazy((Function0)stringLiteralSupporter.2.INSTANCE);
        this.correctnessChecker$delegate = LazyKt.lazy((Function0)correctnessChecker.2.INSTANCE);
        this.shouldRefreshModelOnStartup = PlatformUtils.isIntelliJ();
    }

    @Override
    public boolean getShowInSettings() {
        return KotlinPluginModeProvider.Companion.isK1Mode();
    }

    @Override
    public boolean isInOnlineExperiment() {
        return this.isInOnlineExperiment;
    }

    @Override
    @NotNull
    public CodeFormatter getFormatter() {
        Lazy lazy = this.formatter$delegate;
        return (CodeFormatter)lazy.getValue();
    }

    @Override
    @NotNull
    public LangState getLangState() {
        return this.langState;
    }

    @Override
    @NotNull
    protected ModelSettings getDefaultModelSettings() {
        return this.defaultModelSettings;
    }

    @Override
    @NotNull
    public FullLineLanguageSettings getLanguageSettings() {
        return this.languageSettings;
    }

    @Override
    @NotNull
    public RelevanceModelService getInlineFilterModelService() {
        return this.inlineFilterModelService;
    }

    @Override
    @NotNull
    public KotlinImportFixer getImportFixer() {
        return this.importFixer;
    }

    @Override
    @NotNull
    public FullLineEnclosures getEnclosures() {
        return this.enclosures;
    }

    @Override
    @NotNull
    public FullLineEnclosuresLexer getEnclosuresLexer() {
        Lazy lazy = this.enclosuresLexer$delegate;
        return (FullLineEnclosuresLexer)lazy.getValue();
    }

    @Override
    @NotNull
    public FullLineStringLiteralSupporter getStringLiteralSupporter() {
        Lazy lazy = this.stringLiteralSupporter$delegate;
        return (FullLineStringLiteralSupporter)lazy.getValue();
    }

    @NotNull
    public CorrectnessCheckerBase getCorrectnessChecker() {
        Lazy lazy = this.correctnessChecker$delegate;
        return (CorrectnessCheckerBase)lazy.getValue();
    }

    @Override
    public boolean getShouldRefreshModelOnStartup() {
        return this.shouldRefreshModelOnStartup;
    }

    @Override
    @Nullable
    public SkipLocationReason skipLocation(@NotNull FullLineParams parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        if (KotlinPluginModeProvider.Companion.isK2Mode()) {
            return SkipLocationReason.KOTLIN_K2_PLUGIN;
        }
        PsiFile completionFile = parameters.getOriginalFile();
        if (ModuleInfoProviderUtils.getModuleInfo((PsiElement)((PsiElement)completionFile)) instanceof NotUnderContentRootModuleInfo) {
            return SkipLocationReason.KOTLIN_CODE_OUTSIDE_OF_PROJECT_SOURCES;
        }
        return super.skipLocation(parameters);
    }

    @Override
    @NotNull
    public FullLinePipelineConfiguration configurePipeline(@NotNull FullLineParams parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        FullLinePipelineConfiguration configuration = super.configurePipeline(parameters);
        return new FullLinePipelineConfiguration(configuration, parameters){
            private final /* synthetic */ FullLinePipelineConfiguration $$delegate_0;
            @NotNull
            private final List<ProposalsFilter> additionalFilters;
            {
                this.$$delegate_0 = $configuration;
                this.additionalFilters = CollectionsKt.plus((Collection)$configuration.getAdditionalFilters(), (Object)new ValuableCharacterAfterCaretFilter(CollectionsKt.listOf((Object)Character.valueOf('>')), $parameters));
            }

            @NotNull
            public List<ProposalTransformer> getAdditionalTransformers() {
                return this.$$delegate_0.getAdditionalTransformers();
            }

            @NotNull
            public FullLineCompletionMode getMode() {
                return this.$$delegate_0.getMode();
            }

            @NotNull
            public List<ProposalsFilter> getAdditionalFilters() {
                return this.additionalFilters;
            }
        };
    }
}

