/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.js.supporters.utils;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.ProposalTransformer;
import org.jetbrains.completion.full.line.RawFullLineProposal;
import org.jetbrains.completion.full.line.js.supporters.utils.XmlTagsUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/completion/full/line/js/supporters/utils/JSDialectTrimAlreadyClosingTagPartTransformer;", "Lorg/jetbrains/completion/full/line/ProposalTransformer;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Document;I)V", "closestTag", "Lcom/intellij/psi/xml/XmlTag;", "isTagAlreadyClosed", "", "transform", "Lorg/jetbrains/completion/full/line/RawFullLineProposal;", "proposal", "intellij.fullLine.js"})
public final class JSDialectTrimAlreadyClosingTagPartTransformer
implements ProposalTransformer {
    @Nullable
    private final XmlTag closestTag;
    private final boolean isTagAlreadyClosed;

    public JSDialectTrimAlreadyClosingTagPartTransformer(@NotNull PsiFile file2, @NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        XmlTag xmlTag = this.closestTag = XmlTagsUtils.INSTANCE.findClosestTagOnSameLine(file2, document, offset);
        this.isTagAlreadyClosed = xmlTag != null ? XmlTagsUtils.INSTANCE.isTagClosed(xmlTag) : false;
    }

    @Override
    @NotNull
    public RawFullLineProposal transform(@NotNull RawFullLineProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        if (this.closestTag == null || !this.isTagAlreadyClosed) {
            return proposal;
        }
        String string = this.closestTag.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        return proposal.withSuggestion(StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)proposal.getSuggestion(), (CharSequence)("</" + name)), (CharSequence)("</" + name + ">")));
    }
}

