/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.feedback;

import com.intellij.codeInsight.inline.completion.InlineCompletionEventAdapter;
import com.intellij.codeInsight.inline.completion.InlineCompletionEventType;
import com.intellij.codeInsight.inline.completion.InlineCompletionProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.feedback.ExplicitFeedback;
import org.jetbrains.completion.full.line.platform.inline.FullLineInlineCompletionProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\tH\u0002J\u0014\u0010\u0014\u001a\u00020\u0013*\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/completion/full/line/feedback/ExplicitFeedbackInlineCompletionListener;", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventAdapter;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "fullLineProviderName", "", "kotlin.jvm.PlatformType", "state", "Lorg/jetbrains/completion/full/line/feedback/ExplicitFeedbackInlineCompletionListener$State;", "onHide", "", "event", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Hide;", "onRequest", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Request;", "onShow", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Show;", "isFeedbackSupported", "", "isFullLine", "Ljava/lang/Class;", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionProvider;", "State", "intellij.fullLine"})
final class ExplicitFeedbackInlineCompletionListener
implements InlineCompletionEventAdapter {
    @NotNull
    private final Editor editor;
    @Nullable
    private State state;
    private final String fullLineProviderName;

    public ExplicitFeedbackInlineCompletionListener(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.fullLineProviderName = FullLineInlineCompletionProvider.class.getName();
    }

    public void onRequest(@NotNull InlineCompletionEventType.Request event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean bl = this.isFullLine(event.getProvider());
        Language language2 = event.getRequest().getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
        this.state = new State(bl, false, language2, 2, null);
    }

    public void onShow(@NotNull InlineCompletionEventType.Show event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (((CharSequence)event.getElement().getText()).length() > 0) {
            State state = this.state;
            this.state = state != null ? State.copy$default(state, false, true, null, 5, null) : null;
        }
    }

    public void onHide(@NotNull InlineCompletionEventType.Hide event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        State state = this.state;
        if (state == null) {
            return;
        }
        State state2 = state;
        if (this.isFeedbackSupported(state2) && event.isCurrentlyDisplaying() && ExplicitFeedback.INSTANCE.isSupported()) {
            ExplicitFeedback.INSTANCE.fireFullLineShown(state2.getLanguage(), this.editor.getProject());
        }
        this.state = null;
    }

    private final boolean isFullLine(Class<? extends InlineCompletionProvider> $this$isFullLine) {
        return Intrinsics.areEqual((Object)$this$isFullLine.getName(), (Object)this.fullLineProviderName);
    }

    private final boolean isFeedbackSupported(State $this$isFeedbackSupported) {
        return $this$isFeedbackSupported.isFullLineProvider() && $this$isFeedbackSupported.getElementsShown();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/completion/full/line/feedback/ExplicitFeedbackInlineCompletionListener$State;", "", "isFullLineProvider", "", "elementsShown", "language", "Lcom/intellij/lang/Language;", "(ZZLcom/intellij/lang/Language;)V", "getElementsShown", "()Z", "getLanguage", "()Lcom/intellij/lang/Language;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.fullLine"})
    private static final class State {
        private final boolean isFullLineProvider;
        private final boolean elementsShown;
        @NotNull
        private final Language language;

        public State(boolean isFullLineProvider, boolean elementsShown, @NotNull Language language2) {
            Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
            this.isFullLineProvider = isFullLineProvider;
            this.elementsShown = elementsShown;
            this.language = language2;
        }

        public /* synthetic */ State(boolean bl, boolean bl2, Language language2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2, language2);
        }

        public final boolean isFullLineProvider() {
            return this.isFullLineProvider;
        }

        public final boolean getElementsShown() {
            return this.elementsShown;
        }

        @NotNull
        public final Language getLanguage() {
            return this.language;
        }

        public final boolean component1() {
            return this.isFullLineProvider;
        }

        public final boolean component2() {
            return this.elementsShown;
        }

        @NotNull
        public final Language component3() {
            return this.language;
        }

        @NotNull
        public final State copy(boolean isFullLineProvider, boolean elementsShown, @NotNull Language language2) {
            Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
            return new State(isFullLineProvider, elementsShown, language2);
        }

        public static /* synthetic */ State copy$default(State state, boolean bl, boolean bl2, Language language2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = state.isFullLineProvider;
            }
            if ((n & 2) != 0) {
                bl2 = state.elementsShown;
            }
            if ((n & 4) != 0) {
                language2 = state.language;
            }
            return state.copy(bl, bl2, language2);
        }

        @NotNull
        public String toString() {
            return "State(isFullLineProvider=" + this.isFullLineProvider + ", elementsShown=" + this.elementsShown + ", language=" + this.language + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isFullLineProvider);
            result = result * 31 + Boolean.hashCode(this.elementsShown);
            result = result * 31 + this.language.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (this.isFullLineProvider != state.isFullLineProvider) {
                return false;
            }
            if (this.elementsShown != state.elementsShown) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.language, (Object)state.language);
        }
    }
}

