/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.feedback;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.completion.full.line.FullLineNotifications;
import org.jetbrains.completion.full.line.FullLinePluginInfo;
import org.jetbrains.completion.full.line.feedback.ExplicitFeedbackStateComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u0013J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\u0012\u0010\u0016\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0007R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/completion/full/line/feedback/ExplicitFeedback;", "", "()V", "<set-?>", "", "sessionsToNotify", "getSessionsToNotify", "()I", "setSessionsToNotify", "(I)V", "fireFullLineShown", "", "language", "Lcom/intellij/lang/Language;", "project", "Lcom/intellij/openapi/project/Project;", "getMostPopularLanguage", "", "isAlreadyRequested", "", "isSupported", "isSupportedInEap", "requestFeedbackIfNeeded", "reset", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nExplicitFeedback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExplicitFeedback.kt\norg/jetbrains/completion/full/line/feedback/ExplicitFeedback\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class ExplicitFeedback {
    @NotNull
    public static final ExplicitFeedback INSTANCE = new ExplicitFeedback();
    private static int sessionsToNotify = 100;

    private ExplicitFeedback() {
    }

    public final int getSessionsToNotify() {
        return sessionsToNotify;
    }

    @TestOnly
    public final void setSessionsToNotify(int n) {
        sessionsToNotify = n;
    }

    public final boolean isSupported() {
        return this.isAlreadyRequested() ? false : (ApplicationKt.getApplication().isUnitTestMode() ? true : (FullLinePluginInfo.INSTANCE.isMarketplaceBuild() ? true : ApplicationKt.getApplication().isEAP() && this.isSupportedInEap()));
    }

    public final void fireFullLineShown(@NotNull Language language2, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        if (!this.isSupported()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        ExplicitFeedbackStateComponent.Companion.getInstance().fireFullLineShown(language2);
        this.requestFeedbackIfNeeded(project);
    }

    @Nullable
    public final String getMostPopularLanguage() {
        return ExplicitFeedbackStateComponent.Companion.getInstance().getMostPopularLanguage();
    }

    @TestOnly
    public final void reset() {
        ExplicitFeedbackStateComponent.Companion.getInstance().loadState(new ExplicitFeedbackStateComponent());
    }

    private final boolean isAlreadyRequested() {
        return ExplicitFeedbackStateComponent.Companion.getInstance().isNotificationShown();
    }

    private final void requestFeedbackIfNeeded(Project project) {
        ExplicitFeedbackStateComponent feedbackStateComponent = ExplicitFeedbackStateComponent.Companion.getInstance();
        if (feedbackStateComponent.getSessionsCount() >= sessionsToNotify) {
            String mostPopularLanguage = this.getMostPopularLanguage();
            if (mostPopularLanguage == null) {
                boolean bl = false;
                String string = "No stats are provided. Cannot retrieve the most popular language.";
                throw new IllegalArgumentException(string.toString());
            }
            FullLineNotifications.Feedback.INSTANCE.showShareFeedbackRequest(project, mostPopularLanguage);
            feedbackStateComponent.fireNotificationShown();
        }
    }

    private final boolean isSupportedInEap() {
        String string = ApplicationNamesInfo.getInstance().getFullProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullProductName(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return StringsKt.contains$default((CharSequence)string2, (CharSequence)"goland", (boolean)false, (int)2, null);
    }
}

