/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.actions;

import com.intellij.codeInsight.completion.actions.CodeCompletionAction;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.LocalModelDescriptor;
import org.jetbrains.completion.full.line.actions.FullLineStartupActivityKt;
import org.jetbrains.completion.full.line.language.ModelSettings;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;
import org.jetbrains.completion.full.line.local.files.LocalModelsBundleManager;
import org.jetbrains.completion.full.line.local.files.LocalModelsDownloadConsentManager;
import org.jetbrains.completion.full.line.local.files.LocalModelsFilesService;
import org.jetbrains.completion.full.line.models.ModelTypeKt;
import org.jetbrains.completion.full.line.settings.FullLineSettings;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"connectLookupAndInlineCalls", "", "project", "Lcom/intellij/openapi/project/Project;", "refreshImportantLocalModelsOnStartup", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nFullLineStartupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineStartupActivity.kt\norg/jetbrains/completion/full/line/actions/FullLineStartupActivityKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n766#2:94\n857#2,2:95\n766#2:97\n857#2,2:98\n1603#2,9:100\n1855#2:109\n1856#2:111\n1612#2:112\n766#2:113\n857#2,2:114\n1855#2,2:116\n1#3:110\n*S KotlinDebug\n*F\n+ 1 FullLineStartupActivity.kt\norg/jetbrains/completion/full/line/actions/FullLineStartupActivityKt\n*L\n61#1:94\n61#1:95,2\n62#1:97\n62#1:98,2\n63#1:100,9\n63#1:109\n63#1:111\n63#1:112\n67#1:113\n67#1:114,2\n70#1:116,2\n63#1:110\n*E\n"})
public final class FullLineStartupActivityKt {
    public static final void refreshImportantLocalModelsOnStartup() {
        Iterable $this$mapNotNullTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        FullLineSettings settings = FullLineSettings.Companion.getInstance();
        Iterable $this$filter$iv = FullLineSettings.Companion.getAvailableLanguagesWithModel();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Language)element$iv$iv;
            boolean bl = false;
            if (!settings.isEnabled((Language)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Language)element$iv$iv;
            boolean bl = false;
            FullLineLanguageSupporter fullLineLanguageSupporter = FullLineLanguageSupporter.Companion.getInstance((Language)it);
            if (!(fullLineLanguageSupporter != null ? fullLineLanguageSupporter.getShouldRefreshModelOnStartup() : false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            LocalModelDescriptor it$iv$iv;
            ModelSettings modelSettings;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            Language language2 = (Language)element$iv$iv;
            boolean bl2 = false;
            if ((FullLineLanguageSupporter.Companion.modelSettingsFor(language2) == null ? null : new LocalModelDescriptor(language2, ModelTypeKt.asLocalInferenceType(modelSettings.getModelType()), modelSettings.getCustomTag())) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LocalModelDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(LocalModelsDownloadConsentManager.Companion.getInstance().isConsented(((LocalModelDescriptor)it).getLanguage()) || LocalModelsBundleManager.Companion.getInstance().isBundled((LocalModelDescriptor)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalModelDescriptor descriptor = (LocalModelDescriptor)element$iv;
            boolean bl = false;
            LocalModelsFilesService manager = LocalModelsFilesService.Companion.getInstance();
            manager.refreshAsyncFor(descriptor);
        }
    }

    public static final void connectLookupAndInlineCalls(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Topic topic = AnActionListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new AnActionListener(){
            @NotNull
            private final Lazy inlineAction$delegate;
            {
                this.inlineAction$delegate = LazyKt.lazy((Function0)connectLookupAndInlineCalls.inlineAction.2.INSTANCE);
            }

            public final EditorActionHandler getInlineAction() {
                Lazy lazy = this.inlineAction$delegate;
                return (EditorActionHandler)lazy.getValue();
            }

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!(action2 instanceof CodeCompletionAction)) {
                    return;
                }
                if (!FullLineSettings.Companion.getInstance().isGreyTextMode()) {
                    return;
                }
                Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
                if (editor == null) {
                    return;
                }
                Editor editor2 = editor;
                Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
                if (caret == null) {
                    return;
                }
                Caret caret2 = caret;
                this.getInlineAction().execute(editor2, caret2, event.getDataContext());
            }
        });
    }
}

