/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.inline.completion.InlineCompletionRequest;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.FullLineCompletionType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0015J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\u0014H\u00c6\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0007H\u00c6\u0003J\t\u0010-\u001a\u00020\tH\u00c6\u0003J\t\u0010.\u001a\u00020\u000bH\u00c6\u0003J\t\u0010/\u001a\u00020\rH\u00c6\u0003J\u000b\u00100\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000b\u00101\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\u000b\u00102\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003Ju\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00c6\u0001J\u0013\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00107\u001a\u00020\u000bH\u00d6\u0001J\u0006\u00108\u001a\u000205J\u0006\u00109\u001a\u000205J\u0006\u0010:\u001a\u000205J\u000e\u0010;\u001a\u0002052\u0006\u0010<\u001a\u00020\tJ\t\u0010=\u001a\u00020>H\u00d6\u0001R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010'\u00a8\u0006?"}, d2={"Lorg/jetbrains/completion/full/line/FullLineParams;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "language", "Lcom/intellij/lang/Language;", "originalFile", "Lcom/intellij/psi/PsiFile;", "completionType", "Lorg/jetbrains/completion/full/line/FullLineCompletionType;", "offset", "", "position", "Lcom/intellij/psi/PsiElement;", "originalPosition", "completion", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "lookupItemPrefix", "Lcom/intellij/codeInsight/lookup/LookupElement;", "inline", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionRequest;", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/lang/Language;Lcom/intellij/psi/PsiFile;Lorg/jetbrains/completion/full/line/FullLineCompletionType;ILcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/codeInsight/completion/CompletionParameters;Lcom/intellij/codeInsight/lookup/LookupElement;Lcom/intellij/codeInsight/inline/completion/InlineCompletionRequest;)V", "getCompletion", "()Lcom/intellij/codeInsight/completion/CompletionParameters;", "getCompletionType", "()Lorg/jetbrains/completion/full/line/FullLineCompletionType;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getInline", "()Lcom/intellij/codeInsight/inline/completion/InlineCompletionRequest;", "getLanguage", "()Lcom/intellij/lang/Language;", "getLookupItemPrefix", "()Lcom/intellij/codeInsight/lookup/LookupElement;", "getOffset", "()I", "getOriginalFile", "()Lcom/intellij/psi/PsiFile;", "getOriginalPosition", "()Lcom/intellij/psi/PsiElement;", "getPosition", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "isBasicCompletion", "isInline", "isLookup", "isSameCompletionType", "type", "toString", "", "intellij.fullLine.core"})
public final class FullLineParams {
    @NotNull
    private final Editor editor;
    @NotNull
    private final Language language;
    @NotNull
    private final PsiFile originalFile;
    @NotNull
    private final FullLineCompletionType completionType;
    private final int offset;
    @NotNull
    private final PsiElement position;
    @Nullable
    private final PsiElement originalPosition;
    @Nullable
    private final CompletionParameters completion;
    @Nullable
    private final LookupElement lookupItemPrefix;
    @Nullable
    private final InlineCompletionRequest inline;

    public FullLineParams(@NotNull Editor editor, @NotNull Language language2, @NotNull PsiFile originalFile, @NotNull FullLineCompletionType completionType, int offset, @NotNull PsiElement position, @Nullable PsiElement originalPosition, @Nullable CompletionParameters completion2, @Nullable LookupElement lookupItemPrefix, @Nullable InlineCompletionRequest inline) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)((Object)completionType), (String)"completionType");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.editor = editor;
        this.language = language2;
        this.originalFile = originalFile;
        this.completionType = completionType;
        this.offset = offset;
        this.position = position;
        this.originalPosition = originalPosition;
        this.completion = completion2;
        this.lookupItemPrefix = lookupItemPrefix;
        this.inline = inline;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public final PsiFile getOriginalFile() {
        return this.originalFile;
    }

    @NotNull
    public final FullLineCompletionType getCompletionType() {
        return this.completionType;
    }

    public final int getOffset() {
        return this.offset;
    }

    @NotNull
    public final PsiElement getPosition() {
        return this.position;
    }

    @Nullable
    public final PsiElement getOriginalPosition() {
        return this.originalPosition;
    }

    @Nullable
    public final CompletionParameters getCompletion() {
        return this.completion;
    }

    @Nullable
    public final LookupElement getLookupItemPrefix() {
        return this.lookupItemPrefix;
    }

    @Nullable
    public final InlineCompletionRequest getInline() {
        return this.inline;
    }

    public final boolean isBasicCompletion() {
        CompletionParameters completionParameters = this.completion;
        return (completionParameters != null ? completionParameters.getCompletionType() : null) == CompletionType.BASIC;
    }

    public final boolean isLookup() {
        return this.completionType == FullLineCompletionType.LOOKUP;
    }

    public final boolean isInline() {
        return this.completionType == FullLineCompletionType.INLINE;
    }

    public final boolean isSameCompletionType(@NotNull FullLineCompletionType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.completionType == type;
    }

    @NotNull
    public final Editor component1() {
        return this.editor;
    }

    @NotNull
    public final Language component2() {
        return this.language;
    }

    @NotNull
    public final PsiFile component3() {
        return this.originalFile;
    }

    @NotNull
    public final FullLineCompletionType component4() {
        return this.completionType;
    }

    public final int component5() {
        return this.offset;
    }

    @NotNull
    public final PsiElement component6() {
        return this.position;
    }

    @Nullable
    public final PsiElement component7() {
        return this.originalPosition;
    }

    @Nullable
    public final CompletionParameters component8() {
        return this.completion;
    }

    @Nullable
    public final LookupElement component9() {
        return this.lookupItemPrefix;
    }

    @Nullable
    public final InlineCompletionRequest component10() {
        return this.inline;
    }

    @NotNull
    public final FullLineParams copy(@NotNull Editor editor, @NotNull Language language2, @NotNull PsiFile originalFile, @NotNull FullLineCompletionType completionType, int offset, @NotNull PsiElement position, @Nullable PsiElement originalPosition, @Nullable CompletionParameters completion2, @Nullable LookupElement lookupItemPrefix, @Nullable InlineCompletionRequest inline) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)((Object)completionType), (String)"completionType");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return new FullLineParams(editor, language2, originalFile, completionType, offset, position, originalPosition, completion2, lookupItemPrefix, inline);
    }

    public static /* synthetic */ FullLineParams copy$default(FullLineParams fullLineParams, Editor editor, Language language2, PsiFile psiFile2, FullLineCompletionType fullLineCompletionType, int n, PsiElement psiElement, PsiElement psiElement2, CompletionParameters completionParameters, LookupElement lookupElement, InlineCompletionRequest inlineCompletionRequest, int n2, Object object) {
        if ((n2 & 1) != 0) {
            editor = fullLineParams.editor;
        }
        if ((n2 & 2) != 0) {
            language2 = fullLineParams.language;
        }
        if ((n2 & 4) != 0) {
            psiFile2 = fullLineParams.originalFile;
        }
        if ((n2 & 8) != 0) {
            fullLineCompletionType = fullLineParams.completionType;
        }
        if ((n2 & 0x10) != 0) {
            n = fullLineParams.offset;
        }
        if ((n2 & 0x20) != 0) {
            psiElement = fullLineParams.position;
        }
        if ((n2 & 0x40) != 0) {
            psiElement2 = fullLineParams.originalPosition;
        }
        if ((n2 & 0x80) != 0) {
            completionParameters = fullLineParams.completion;
        }
        if ((n2 & 0x100) != 0) {
            lookupElement = fullLineParams.lookupItemPrefix;
        }
        if ((n2 & 0x200) != 0) {
            inlineCompletionRequest = fullLineParams.inline;
        }
        return fullLineParams.copy(editor, language2, psiFile2, fullLineCompletionType, n, psiElement, psiElement2, completionParameters, lookupElement, inlineCompletionRequest);
    }

    @NotNull
    public String toString() {
        return "FullLineParams(editor=" + this.editor + ", language=" + this.language + ", originalFile=" + this.originalFile + ", completionType=" + this.completionType + ", offset=" + this.offset + ", position=" + this.position + ", originalPosition=" + this.originalPosition + ", completion=" + this.completion + ", lookupItemPrefix=" + this.lookupItemPrefix + ", inline=" + this.inline + ")";
    }

    public int hashCode() {
        int result = this.editor.hashCode();
        result = result * 31 + this.language.hashCode();
        result = result * 31 + this.originalFile.hashCode();
        result = result * 31 + this.completionType.hashCode();
        result = result * 31 + Integer.hashCode(this.offset);
        result = result * 31 + this.position.hashCode();
        result = result * 31 + (this.originalPosition == null ? 0 : this.originalPosition.hashCode());
        result = result * 31 + (this.completion == null ? 0 : this.completion.hashCode());
        result = result * 31 + (this.lookupItemPrefix == null ? 0 : this.lookupItemPrefix.hashCode());
        result = result * 31 + (this.inline == null ? 0 : this.inline.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FullLineParams)) {
            return false;
        }
        FullLineParams fullLineParams = (FullLineParams)other;
        if (!Intrinsics.areEqual((Object)this.editor, (Object)fullLineParams.editor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.language, (Object)fullLineParams.language)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.originalFile, (Object)fullLineParams.originalFile)) {
            return false;
        }
        if (this.completionType != fullLineParams.completionType) {
            return false;
        }
        if (this.offset != fullLineParams.offset) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.position, (Object)fullLineParams.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.originalPosition, (Object)fullLineParams.originalPosition)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.completion, (Object)fullLineParams.completion)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lookupItemPrefix, (Object)fullLineParams.lookupItemPrefix)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.inline, (Object)fullLineParams.inline);
    }
}

