/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.fullLine.ruby.supporters.correctness;

import com.intellij.openapi.util.TextRange;
import com.intellij.platform.ml.impl.correctness.checker.CorrectnessError;
import com.intellij.platform.ml.impl.correctness.checker.CustomSemanticChecker;
import com.intellij.platform.ml.impl.correctness.checker.Severity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

final class RubyDuplicateDeclarationsChecker
extends CustomSemanticChecker {
    RubyDuplicateDeclarationsChecker() {
    }

    @NotNull
    public List<CorrectnessError> findErrors(@NotNull PsiFile originalFile, @NotNull PsiElement element, final int offset, final @NotNull String prefix2, final @NotNull String suggestion) {
        if (originalFile == null) {
            RubyDuplicateDeclarationsChecker.$$$reportNull$$$0(0);
        }
        if (element == null) {
            RubyDuplicateDeclarationsChecker.$$$reportNull$$$0(1);
        }
        if (prefix2 == null) {
            RubyDuplicateDeclarationsChecker.$$$reportNull$$$0(2);
        }
        if (suggestion == null) {
            RubyDuplicateDeclarationsChecker.$$$reportNull$$$0(3);
        }
        if (!(originalFile instanceof RFile)) {
            List<CorrectnessError> list2 = Collections.emptyList();
            if (list2 == null) {
                RubyDuplicateDeclarationsChecker.$$$reportNull$$$0(4);
            }
            return list2;
        }
        final ArrayList<CorrectnessError> errors = new ArrayList<CorrectnessError>();
        RubyElementVisitor visitor2 = new RubyElementVisitor(){

            public void visitRClass(@NotNull RClass clazz) {
                FQN fqn;
                if (clazz == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((fqn = clazz.getFQNWithNesting()) == FQN.INVALID) {
                    return;
                }
                TextRange location = (TextRange)ObjectUtils.doIfNotNull((Object)clazz.getClassName(), it -> RubyDuplicateDeclarationsChecker.this.getLocationInSuggestion(it.getTextRange(), offset, prefix2, suggestion));
                if (location == null) {
                    return;
                }
                PsiFile psiFile2 = clazz.getContainingFile();
                if (!(psiFile2 instanceof RFile)) {
                    return;
                }
                RFile file2 = (RFile)psiFile2;
                for (RContainer container : RContainerUtil.getStructureElementsRecursively((RContainer)file2)) {
                    if (clazz.equals(container) || container instanceof RObjectClass || !(container instanceof RClass) || !fqn.equals(container.getFQNWithNesting())) continue;
                    errors.add(new CorrectnessError(location, Severity.CRITICAL, RubyDuplicateDeclarationsChecker.class.getSimpleName()));
                    break;
                }
            }

            public void visitRMethod(@NotNull RMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(1);
                }
                RContainer container = method.getParentContainer();
                PsiElement identifier = method.getNameIdentifier();
                if (container == null || identifier == null || method.getName() == null) {
                    return;
                }
                TextRange location = RubyDuplicateDeclarationsChecker.this.getLocationInSuggestion(identifier.getTextRange(), offset, prefix2, suggestion);
                if (location == null) {
                    return;
                }
                for (PsiElement statement : container.getStatements()) {
                    if (!(statement instanceof RMethod)) continue;
                    RMethod candidate = (RMethod)statement;
                    if (method.equals(statement) || !method.getFQNWithNesting().equals(candidate.getFQNWithNesting())) continue;
                    errors.add(new CorrectnessError(location, Severity.CRITICAL, RubyDuplicateDeclarationsChecker.class.getSimpleName()));
                    break;
                }
            }

            public void visitRModule(@NotNull RModule module) {
                FQN fqn;
                if (module == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((fqn = module.getFQNWithNesting()) == FQN.INVALID) {
                    return;
                }
                TextRange location = (TextRange)ObjectUtils.doIfNotNull((Object)module.getModuleName(), it -> RubyDuplicateDeclarationsChecker.this.getLocationInSuggestion(it.getTextRange(), offset, prefix2, suggestion));
                if (location == null) {
                    return;
                }
                PsiFile psiFile2 = module.getContainingFile();
                if (!(psiFile2 instanceof RFile)) {
                    return;
                }
                RFile file2 = (RFile)psiFile2;
                for (RContainer container : RContainerUtil.getStructureElementsRecursively((RContainer)file2)) {
                    if (module.equals(container) || !(container instanceof RModule) || !fqn.equals(container.getFQNWithNesting())) continue;
                    errors.add(new CorrectnessError(location, Severity.CRITICAL, RubyDuplicateDeclarationsChecker.class.getSimpleName()));
                    break;
                }
            }

            public void visitRSingletonMethod(@NotNull RSingletonMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(3);
                }
                RContainer container = method.getParentContainer();
                PsiElement identifier = method.getNameIdentifier();
                if (container == null || identifier == null || method.getName() == null) {
                    return;
                }
                TextRange location = RubyDuplicateDeclarationsChecker.this.getLocationInSuggestion(identifier.getTextRange(), offset, prefix2, suggestion);
                if (location == null) {
                    return;
                }
                for (PsiElement statement : container.getStatements()) {
                    if (!(statement instanceof RSingletonMethod)) continue;
                    RSingletonMethod candidate = (RSingletonMethod)statement;
                    if (method.equals(statement) || !method.getFQNWithNesting().equals(candidate.getFQNWithNesting())) continue;
                    errors.add(new CorrectnessError(location, Severity.CRITICAL, RubyDuplicateDeclarationsChecker.class.getSimpleName()));
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "clazz";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/fullLine/ruby/supporters/correctness/RubyDuplicateDeclarationsChecker$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRMethod";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRModule";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRSingletonMethod";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        element.accept((PsiElementVisitor)visitor2);
        ArrayList<CorrectnessError> arrayList = errors;
        if (arrayList == null) {
            RubyDuplicateDeclarationsChecker.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestion";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/fullLine/ruby/supporters/correctness/RubyDuplicateDeclarationsChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/fullLine/ruby/supporters/correctness/RubyDuplicateDeclarationsChecker";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findErrors";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

