/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.fullLine.ruby.supporters.correctness;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.fullLine.ruby.supporters.correctness.RubyDuplicateDeclarationsChecker;
import com.intellij.fullLine.ruby.supporters.correctness.RubyInspectionBasedChecker;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ml.impl.correctness.checker.CorrectnessCheckerBase;
import com.intellij.platform.ml.impl.correctness.checker.SemanticChecker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.inspections.argcount.RubyArgCountInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.jumpError.RubyJumpErrorInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.resolve.InvalidCallToProtectedPrivateMethodInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.resolve.RubyResolveInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.supercall.RubySuperCallWithoutSuperclassInspection;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/fullLine/ruby/supporters/correctness/RubyCorrectnessChecker;", "Lcom/intellij/platform/ml/impl/correctness/checker/CorrectnessCheckerBase;", "()V", "buildPsiForSemanticChecks", "Lcom/intellij/psi/PsiFile;", "file", "suggestion", "", "offset", "", "prefix", "matchedEnclosuresIndices", "", "intellij.fullLine.ruby"})
@SourceDebugExtension(value={"SMAP\nRubyCorrectnessChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubyCorrectnessChecker.kt\ncom/intellij/fullLine/ruby/supporters/correctness/RubyCorrectnessChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class RubyCorrectnessChecker
extends CorrectnessCheckerBase {
    public RubyCorrectnessChecker() {
        RubyResolveInspection rubyResolveInspection;
        Object[] objectArray = new SemanticChecker[6];
        objectArray[0] = new RubyInspectionBasedChecker((LocalInspectionTool)new RubyJumpErrorInspection());
        objectArray[1] = new RubyInspectionBasedChecker((LocalInspectionTool)new RubyArgCountInspection());
        objectArray[2] = new RubyInspectionBasedChecker((LocalInspectionTool)new InvalidCallToProtectedPrivateMethodInspection());
        objectArray[3] = new RubyInspectionBasedChecker((LocalInspectionTool)new RubySuperCallWithoutSuperclassInspection());
        RubyResolveInspection rubyResolveInspection2 = rubyResolveInspection = new RubyResolveInspection();
        int n = 4;
        Object[] objectArray2 = objectArray;
        RubyCorrectnessChecker rubyCorrectnessChecker = this;
        boolean bl = false;
        it.warnImplicitResults = true;
        Unit unit = Unit.INSTANCE;
        LocalInspectionTool localInspectionTool = (LocalInspectionTool)rubyResolveInspection;
        objectArray2[n] = new RubyInspectionBasedChecker(localInspectionTool);
        objectArray[5] = new RubyDuplicateDeclarationsChecker();
        super(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    protected PsiFile buildPsiForSemanticChecks(@NotNull PsiFile file2, @NotNull String suggestion, int offset, @NotNull String prefix2, @Nullable Set<Integer> matchedEnclosuresIndices) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        String it = file2.getText();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        String text = StringsKt.take((String)it, (int)(offset - prefix2.length())) + suggestion + " " + StringsKt.drop((String)it, (int)offset);
        PsiFileFactory psiFileFactory = PsiFileFactoryImpl.getInstance((Project)file2.getProject());
        Intrinsics.checkNotNull((Object)psiFileFactory, (String)"null cannot be cast to non-null type com.intellij.psi.impl.PsiFileFactoryImpl");
        PsiFileFactoryImpl factory = (PsiFileFactoryImpl)psiFileFactory;
        PsiFile mockFile = factory.createFileFromText(file2.getName(), (Language)RubyLanguage.INSTANCE, (CharSequence)text, true, true, false, PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)file2)));
        PsiFileImpl psiFileImpl = mockFile instanceof PsiFileImpl ? (PsiFileImpl)mockFile : null;
        if (psiFileImpl != null) {
            psiFileImpl.setOriginalFile(file2);
        }
        Intrinsics.checkNotNull((Object)mockFile);
        return mockFile;
    }
}

