/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.fullLine.java.supporters.features;

import com.intellij.application.options.CodeStyle;
import com.intellij.fullLine.java.supporters.features.correctness.JavaCorrectnessCheckerKt;
import com.intellij.fullLine.java.supporters.features.correctness.JavaCorrectnessImportClassFix;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.ml.impl.correctness.autoimport.ImportFixer;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J*\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J(\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J*\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/fullLine/java/supporters/features/JavaImportFixer;", "Lcom/intellij/platform/ml/impl/correctness/autoimport/ImportFixer;", "()V", "applyFixesAndFormat", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "context", "Lcom/intellij/platform/ml/impl/correctness/autoimport/ImportFixer$ImportContext;", "importFix", "Lcom/intellij/fullLine/java/supporters/features/correctness/JavaCorrectnessImportClassFix;", "pointer", "Lcom/intellij/psi/SmartPsiFileRange;", "applyImport", "file", "Lcom/intellij/psi/PsiFile;", "fix", "suggestionRange", "Lcom/intellij/openapi/util/TextRange;", "format", "moveCaretBetweenBraces", "lineNumber", "", "fileDocument", "Lcom/intellij/openapi/editor/Document;", "myImportClassFix", "runAutoImport", "intellij.fullLine.java"})
@SourceDebugExtension(value={"SMAP\nJavaImportFixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaImportFixer.kt\ncom/intellij/fullLine/java/supporters/features/JavaImportFixer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n800#2,11:173\n1549#2:184\n1620#2,3:185\n288#2,2:188\n*S KotlinDebug\n*F\n+ 1 JavaImportFixer.kt\ncom/intellij/fullLine/java/supporters/features/JavaImportFixer\n*L\n167#1:173,11\n168#1:184\n168#1:185,3\n169#1:188,2\n*E\n"})
public final class JavaImportFixer
implements ImportFixer {
    @TestOnly
    public final void fix(@NotNull PsiFile file2, @NotNull TextRange suggestionRange, @NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)suggestionRange, (String)"suggestionRange");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        JavaCorrectnessImportClassFix fix = (JavaCorrectnessImportClassFix)((Object)ApplicationManager.getApplication().executeOnPooledThread(() -> JavaImportFixer.fix$lambda$1(this, file2, suggestionRange, project, editor)).get());
        SmartPsiFileRange smartPsiFileRange = SmartPointerManager.getInstance((Project)project).createSmartPsiFileRangePointer(file2, suggestionRange);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"createSmartPsiFileRangePointer(...)");
        SmartPsiFileRange pointer = smartPsiFileRange;
        this.applyFixesAndFormat(project, editor, new ImportFixer.ImportContext(null, null), fix, pointer);
    }

    public void runAutoImport(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull TextRange suggestionRange, @NotNull ImportFixer.ImportContext context2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)suggestionRange, (String)"suggestionRange");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(file2 instanceof PsiJavaFile)) {
            return;
        }
        Project project = ((PsiJavaFile)file2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Document fileDocument = file2.getViewProvider().getDocument();
        long initialStamp = fileDocument.getModificationStamp();
        SmartPsiFileRange smartPsiFileRange = SmartPointerManager.getInstance((Project)project2).createSmartPsiFileRangePointer(file2, suggestionRange);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"createSmartPsiFileRangePointer(...)");
        SmartPsiFileRange pointer = smartPsiFileRange;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.applyFixesAndFormat(project2, editor, context2, null, pointer);
            return;
        }
        ReadAction.nonBlocking(() -> JavaImportFixer.runAutoImport$lambda$2(this, file2, suggestionRange, project2, editor)).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> JavaImportFixer.runAutoImport$lambda$3((Function1)new Function1<JavaCorrectnessImportClassFix, Unit>(this, project2, editor, context2, pointer){
            final /* synthetic */ JavaImportFixer this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ ImportFixer.ImportContext $context;
            final /* synthetic */ SmartPsiFileRange $pointer;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$editor = $editor;
                this.$context = $context;
                this.$pointer = $pointer;
                super(1);
            }

            public final void invoke(@Nullable JavaCorrectnessImportClassFix fix) {
                JavaImportFixer.access$applyFixesAndFormat(this.this$0, this.$project, this.$editor, this.$context, fix, this.$pointer);
            }
        }, arg_0)).expireWhen(() -> JavaImportFixer.runAutoImport$lambda$4(fileDocument, initialStamp)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private final void applyFixesAndFormat(Project project, Editor editor, ImportFixer.ImportContext context2, JavaCorrectnessImportClassFix importFix, SmartPsiFileRange pointer) {
        PsiFile psiFile2 = pointer.getContainingFile();
        if (psiFile2 == null) {
            return;
        }
        PsiFile file2 = psiFile2;
        CommandProcessor.getInstance().executeCommand(project, () -> JavaImportFixer.applyFixesAndFormat$lambda$5(this, project, file2, editor, importFix, pointer), context2.getCommandName(), context2.getCommandGroup());
    }

    private final void format(Project project, Editor editor, SmartPsiFileRange pointer) {
        ApplicationManager.getApplication().runWriteAction(() -> JavaImportFixer.format$lambda$6(pointer, project, editor, this));
    }

    private final void moveCaretBetweenBraces(Editor editor, SmartPsiFileRange pointer, int lineNumber2, Document fileDocument) {
        PsiElement nextElement;
        PsiElement psiElement;
        PsiElement previousElement;
        int offset = editor.getCaretModel().getOffset();
        PsiFile psiFile2 = pointer.getContainingFile();
        Object element = psiFile2 != null ? psiFile2.findElementAt(offset) : null;
        PsiElement psiElement2 = element;
        IElementType elementType = psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null;
        PsiElement psiElement3 = previousElement = Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.LBRACE) ? element : PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
        if (previousElement != null) {
            previousElement = PsiTreeUtil.getDeepestLast((PsiElement)previousElement);
            ASTNode aSTNode = previousElement.getNode();
            Object object = elementType = aSTNode != null ? aSTNode.getElementType() : null;
            if (Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.RBRACE) && lineNumber2 != fileDocument.getLineNumber(previousElement.getTextRange().getEndOffset())) {
                ASTNode aSTNode2 = previousElement.getNode();
                elementType = aSTNode2 != null ? aSTNode2.getElementType() : null;
                PsiElement psiElement4 = previousElement = Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.LBRACE) ? previousElement : PsiTreeUtil.skipWhitespacesBackward((PsiElement)previousElement);
                if (previousElement != null) {
                    previousElement = PsiTreeUtil.getDeepestLast((PsiElement)previousElement);
                    ASTNode aSTNode3 = previousElement.getNode();
                    Object object2 = elementType = aSTNode3 != null ? aSTNode3.getElementType() : null;
                    if (Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.LBRACE) && lineNumber2 == fileDocument.getLineNumber(previousElement.getTextRange().getEndOffset())) {
                        TextRange textRange = previousElement.getTextRange();
                        editor.getCaretModel().moveToOffset(textRange != null ? textRange.getEndOffset() : offset);
                        return;
                    }
                }
            }
        }
        IElementType iElementType = (psiElement = (nextElement = element)) != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : (elementType = null);
        if (!Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.LBRACE)) {
            nextElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        }
        if (nextElement == null) {
            return;
        }
        nextElement = PsiTreeUtil.getDeepestFirst((PsiElement)nextElement);
        ASTNode aSTNode = nextElement.getNode();
        Object object = elementType = aSTNode != null ? aSTNode.getElementType() : null;
        if (Intrinsics.areEqual((Object)elementType, (Object)JavaTokenType.LBRACE) && lineNumber2 == fileDocument.getLineNumber(nextElement.getTextRange().getEndOffset())) {
            TextRange textRange = nextElement.getTextRange();
            editor.getCaretModel().moveToOffset(textRange != null ? textRange.getEndOffset() : offset);
        }
    }

    private final void applyImport(Project project, PsiFile file2, Editor editor, JavaCorrectnessImportClassFix importFix) {
        if (importFix != null) {
            int offset = editor.getCaretModel().getOffset();
            SmartPsiFileRange smartPsiFileRange = SmartPointerManager.getInstance((Project)project).createSmartPsiFileRangePointer(file2, new TextRange(offset, offset));
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"createSmartPsiFileRangePointer(...)");
            SmartPsiFileRange rangePointer = smartPsiFileRange;
            TextRange textRange = importFix.getReference().getTextRange();
            editor.getCaretModel().moveToOffset(textRange.getStartOffset());
            importFix.invoke(project, editor, file2);
            Segment range = rangePointer.getRange();
            if (range != null) {
                editor.getCaretModel().moveToOffset(range.getStartOffset());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JavaCorrectnessImportClassFix myImportClassFix(PsiFile file2, TextRange suggestionRange, Project project, Editor editor) {
        Object v2;
        block4: {
            void $this$firstOrNull$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            PsiElement psiElement = JavaCorrectnessCheckerKt.findTargetElement(file2, suggestionRange);
            if (psiElement == null) {
                return null;
            }
            PsiElement commonParent = psiElement;
            SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)file2)).onRange(commonParent.getTextRange());
            Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"onRange(...)");
            Iterable iterable = (Iterable)syntaxTraverser;
            boolean $i$f$filterIsInstance = false;
            Iterator iterator2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PsiJavaCodeReferenceElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new JavaCorrectnessImportClassFix((PsiJavaCodeReferenceElement)it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JavaCorrectnessImportClassFix it = (JavaCorrectnessImportClassFix)((Object)element$iv);
                boolean bl = false;
                if (!it.isAvailable(project, editor, file2)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        return v2;
    }

    private static final JavaCorrectnessImportClassFix fix$lambda$1$lambda$0(JavaImportFixer this$0, PsiFile $file, TextRange $suggestionRange, Project $project, Editor $editor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$suggestionRange, (String)"$suggestionRange");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        return this$0.myImportClassFix($file, $suggestionRange, $project, $editor);
    }

    private static final JavaCorrectnessImportClassFix fix$lambda$1(JavaImportFixer this$0, PsiFile $file, TextRange $suggestionRange, Project $project, Editor $editor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$suggestionRange, (String)"$suggestionRange");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        return (JavaCorrectnessImportClassFix)((Object)ReadAction.compute(() -> JavaImportFixer.fix$lambda$1$lambda$0(this$0, $file, $suggestionRange, $project, $editor)));
    }

    private static final JavaCorrectnessImportClassFix runAutoImport$lambda$2(JavaImportFixer this$0, PsiFile $file, TextRange $suggestionRange, Project $project, Editor $editor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$suggestionRange, (String)"$suggestionRange");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        return this$0.myImportClassFix($file, $suggestionRange, $project, $editor);
    }

    private static final void runAutoImport$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean runAutoImport$lambda$4(Document $fileDocument, long $initialStamp) {
        return $fileDocument.getModificationStamp() != $initialStamp;
    }

    private static final void applyFixesAndFormat$lambda$5(JavaImportFixer this$0, Project $project, PsiFile $file, Editor $editor, JavaCorrectnessImportClassFix $importFix, SmartPsiFileRange $pointer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$pointer, (String)"$pointer");
        this$0.applyImport($project, $file, $editor, $importFix);
        this$0.format($project, $editor, $pointer);
    }

    private static final void format$lambda$6(SmartPsiFileRange $pointer, Project $project, Editor $editor, JavaImportFixer this$0) {
        Intrinsics.checkNotNullParameter((Object)$pointer, (String)"$pointer");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PsiFile psiFile2 = $pointer.getContainingFile();
        if (psiFile2 == null || (psiFile2 = psiFile2.getFileDocument()) == null) {
            return;
        }
        PsiFile fileDocument = psiFile2;
        PsiDocumentManager.getInstance((Project)$project).commitDocument((Document)fileDocument);
        PsiFile psiFile3 = $pointer.getContainingFile();
        if (psiFile3 == null) {
            return;
        }
        PsiFile file2 = psiFile3;
        int lineNumber2 = fileDocument.getLineNumber($editor.getCaretModel().getOffset());
        Segment segment = $pointer.getRange();
        if (segment == null) {
            return;
        }
        Segment segment2 = segment;
        PsiElement psiElement = JavaCorrectnessCheckerKt.findTargetElement(file2, new TextRange(segment2.getStartOffset(), segment2.getEndOffset()));
        if (psiElement == null) {
            return;
        }
        PsiElement psiElement2 = psiElement;
        CommonCodeStyleSettings commonCodeStyleSettings = CodeStyle.getSettings((Project)$project).getCommonSettings((Language)JavaLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCommonSettings(...)");
        CommonCodeStyleSettings commonSettings = commonCodeStyleSettings;
        if (Registry.is((String)"full.line.java.force.format") || commonSettings.CLASS_BRACE_STYLE != 1 && psiElement2 instanceof PsiClass || commonSettings.METHOD_BRACE_STYLE != 1 && psiElement2 instanceof PsiMethod) {
            CodeStyleManager.getInstance((Project)$project).reformat(psiElement2);
        }
        this$0.moveCaretBetweenBraces($editor, $pointer, lineNumber2, (Document)fileDocument);
    }

    public static final /* synthetic */ void access$applyFixesAndFormat(JavaImportFixer $this, Project project, Editor editor, ImportFixer.ImportContext context2, JavaCorrectnessImportClassFix importFix, SmartPsiFileRange pointer) {
        $this.applyFixesAndFormat(project, editor, context2, importFix, pointer);
    }
}

