/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dynamicPlugins.performanceTesting;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginEnableDisableAction;
import com.intellij.ide.plugins.PluginEnabledState;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.Strings;
import com.jetbrains.performancePlugin.utils.AbstractCallbackBasedCommand;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class UpdatePluginStateCommand
extends AbstractCallbackBasedCommand {
    @NonNls
    public static final String PREFIX = "%updatePluginState";

    public UpdatePluginStateCommand(@NotNull String text, int line) {
        if (text == null) {
            UpdatePluginStateCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    protected void execute(@NotNull ActionCallback callback, @NotNull PlaybackContext context) {
        if (callback == null) {
            UpdatePluginStateCommand.$$$reportNull$$$0(1);
        }
        if (context == null) {
            UpdatePluginStateCommand.$$$reportNull$$$0(2);
        }
        String[] arguments = this.getText().split(" ", 4);
        PluginEnabledState initialState = PluginEnabledState.valueOf((String)arguments[1]);
        PluginEnableDisableAction action = PluginEnableDisableAction.valueOf((String)arguments[2]);
        PluginId pluginId = PluginId.getId((String)arguments[3]);
        UpdatePluginStateCommand.checkStateAndUpdate(callback, context, initialState, action, pluginId);
    }

    static void checkStateAndUpdate(@NotNull ActionCallback callback, @NotNull PlaybackContext context, PluginEnabledState initialState, PluginEnableDisableAction action, PluginId pluginId) {
        if (callback == null) {
            UpdatePluginStateCommand.$$$reportNull$$$0(3);
        }
        if (context == null) {
            UpdatePluginStateCommand.$$$reportNull$$$0(4);
        }
        assert (!InstalledPluginsState.getInstance().isRestartRequired()) : "Not allowing load/unload without restart because of pending restart operation";
        PluginLoadingError loadingError = PluginManagerCore.INSTANCE.getLoadingError(pluginId);
        assert (loadingError == null) : loadingError.getShortMessage();
        PluginEnabledState targetState = action.apply(initialState);
        assert (targetState != null) : "Action: " + action + " is not applicable to " + initialState + " state";
        IdeaPluginDescriptor descriptor = PluginManagerCore.getPlugin((PluginId)pluginId);
        assert (descriptor instanceof IdeaPluginDescriptorImpl) : UpdatePluginStateCommand.getPluginErrorMessage(pluginId, (String)(descriptor == null ? "not found" : "is instance of " + descriptor.getClass().getName()));
        assert (!descriptor.isRequireRestart()) : UpdatePluginStateCommand.getPluginErrorMessage(pluginId, "requires restart");
        Project project = context.getProject();
        DumbService.getInstance((Project)project).runWhenSmart(() -> {
            IdeEventQueue.getInstance().flushQueue();
            try {
                UpdatePluginStateCommand.updatePluginState(descriptor, project, initialState, action, targetState);
                callback.setDone();
            }
            catch (Throwable throwable) {
                String stackTrace = Strings.join((Object[])throwable.getStackTrace(), Objects::toString, (String)"\t\n");
                callback.reject(throwable.getMessage() + "\n" + stackTrace);
            }
        });
    }

    private static void updatePluginState(@NotNull IdeaPluginDescriptor descriptor, @NotNull Project project, @NotNull PluginEnabledState initialState, @NotNull PluginEnableDisableAction action, @NotNull PluginEnabledState targetState) throws ConfigurationException {
        if (descriptor == null) {
            UpdatePluginStateCommand.$$$reportNull$$$0(5);
        }
        if (project == null) {
            UpdatePluginStateCommand.$$$reportNull$$$0(6);
        }
        if (initialState == null) {
            UpdatePluginStateCommand.$$$reportNull$$$0(7);
        }
        if (action == null) {
            UpdatePluginStateCommand.$$$reportNull$$$0(8);
        }
        if (targetState == null) {
            UpdatePluginStateCommand.$$$reportNull$$$0(9);
        }
        MyPluginModel model = new MyPluginModel(project);
        PluginEnabledState actualInitialState = model.getState(descriptor);
        assert (initialState == actualInitialState) : "Invalid initial state, expected: " + initialState + ", actual: " + actualInitialState;
        model.setEnabledState(List.of(descriptor), action);
        boolean success = model.apply(null);
        assert (success) : "Can not " + action.toString().toLowerCase(Locale.ROOT) + " the '" + descriptor.getPluginId() + "' plugin";
        PluginEnabledState actualTargetState = model.getState(descriptor);
        assert (targetState == actualTargetState) : "Invalid target state, expected: " + targetState + ", actual: " + model.getState(descriptor);
        assert (action.isEnable() == descriptor.isEnabled()) : "Descriptor is supposed to be " + (action.isEnable() ? "" : "not") + " enabled";
    }

    @NotNull
    @NonNls
    private static String getPluginErrorMessage(@NotNull PluginId pluginId, @NotNull @NonNls String description) {
        if (pluginId == null) {
            UpdatePluginStateCommand.$$$reportNull$$$0(10);
        }
        if (description == null) {
            UpdatePluginStateCommand.$$$reportNull$$$0(11);
        }
        String string = "Plugin '" + pluginId + "' " + description;
        if (string == null) {
            UpdatePluginStateCommand.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialState";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetState";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/dynamicPlugins/performanceTesting/UpdatePluginStateCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/dynamicPlugins/performanceTesting/UpdatePluginStateCommand";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkStateAndUpdate";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updatePluginState";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPluginErrorMessage";
                break;
            }
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

