/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dynamicPlugins.performanceTesting;

import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.performancePlugin.utils.AbstractCallbackBasedCommand;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class FindPluginDependenciesCommand
extends AbstractCallbackBasedCommand {
    @NonNls
    public static final String PREFIX = "%findDependencies";

    public FindPluginDependenciesCommand(@NotNull String text, int line) {
        if (text == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    protected void execute(@NotNull ActionCallback actionCallback, @NotNull PlaybackContext context) throws IOException {
        if (actionCallback == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(1);
        }
        if (context == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(2);
        }
        String[] arguments = this.getText().split(" ", 4);
        String dependantsToDisable = arguments[1];
        String dependenciesToEnable = arguments[2];
        PluginId pluginId = PluginId.getId((String)arguments[3]);
        LinkedHashSet<PluginId> foundDependenciesOnPlugin = new LinkedHashSet<PluginId>();
        LinkedHashSet<PluginId> foundPluginsDependencies = new LinkedHashSet<PluginId>();
        Map pluginIdMap = PluginManagerCore.INSTANCE.buildPluginIdMap();
        for (IdeaPluginDescriptorImpl descriptor : PluginManagerCore.INSTANCE.getPluginSet().enabledPlugins) {
            PluginId currentPluginId = descriptor.getPluginId();
            Set dependenciesIds = PluginManagerCore.INSTANCE.getNonOptionalDependenciesIds(descriptor);
            if (currentPluginId.equals((Object)pluginId)) {
                FindPluginDependenciesCommand.collectNonOptionalDependenciesIds(dependenciesIds, pluginIdMap, foundPluginsDependencies);
                continue;
            }
            if (!dependenciesIds.contains(pluginId)) continue;
            foundDependenciesOnPlugin.add(currentPluginId);
        }
        FindPluginDependenciesCommand.writeInFile(dependantsToDisable, foundDependenciesOnPlugin);
        FindPluginDependenciesCommand.writeInFile(dependenciesToEnable, foundPluginsDependencies);
        actionCallback.setDone();
    }

    private static void collectNonOptionalDependenciesIds(@NotNull Set<PluginId> dependenciesIds, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap, @NotNull Set<PluginId> accumulator) {
        if (dependenciesIds == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(3);
        }
        if (pluginIdMap == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(4);
        }
        if (accumulator == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(5);
        }
        for (PluginId id : dependenciesIds) {
            IdeaPluginDescriptorImpl descriptor;
            if (accumulator.contains(id) || (descriptor = PluginManagerCore.isModuleDependency((PluginId)id) ? PluginManagerCore.INSTANCE.findPluginByModuleDependency(id) : Objects.requireNonNull(pluginIdMap.get(id))) == null || descriptor.isBundled()) continue;
            accumulator.add(descriptor.getPluginId());
            FindPluginDependenciesCommand.collectNonOptionalDependenciesIds(PluginManagerCore.INSTANCE.getNonOptionalDependenciesIds(descriptor), pluginIdMap, accumulator);
        }
    }

    static void writeInFile(@NotNull String fileName, @NotNull Collection<PluginId> pluginIds) throws IOException {
        if (fileName == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(6);
        }
        if (pluginIds == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(7);
        }
        FileUtil.writeToFile((File)new File(fileName), (String)StringUtil.join(pluginIds, (String)"\n"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionCallback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesIds";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIdMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/dynamicPlugins/performanceTesting/FindPluginDependenciesCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNonOptionalDependenciesIds";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "writeInFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

