/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dynamicPlugins.performanceTesting;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginEnabledState;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.utils.AbstractCallbackBasedCommand;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckPluginStateCommand
extends AbstractCallbackBasedCommand {
    @NonNls
    public static final String PREFIX = "%checkPluginState";
    private static final Logger LOG = Logger.getInstance(CheckPluginStateCommand.class);

    public CheckPluginStateCommand(@NotNull String text, int line) {
        if (text == null) {
            CheckPluginStateCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    protected void execute(@NotNull ActionCallback actionCallback, @NotNull PlaybackContext context) {
        if (actionCallback == null) {
            CheckPluginStateCommand.$$$reportNull$$$0(1);
        }
        if (context == null) {
            CheckPluginStateCommand.$$$reportNull$$$0(2);
        }
        String[] arguments = this.getText().split(" ", 3);
        PluginEnabledState expectedState = PluginEnabledState.valueOf((String)arguments[1]);
        PluginId pluginId = PluginId.getId((String)arguments[2]);
        assert (!InstalledPluginsState.getInstance().isRestartRequired()) : "Not allowing load/unload without restart because of pending restart operation";
        DumbService.getInstance((Project)context.getProject()).runWhenSmart(() -> {
            IdeaPluginDescriptor descriptor = PluginManagerCore.getPlugin((PluginId)pluginId);
            if (PluginEnabler.HEADLESS.isDisabled(pluginId)) {
                if (descriptor == null) {
                    CheckPluginStateCommand.assertIsDisabled(actionCallback, expectedState, "Plugin '" + pluginId + "' is disabled");
                } else {
                    CheckPluginStateCommand.checkPluginInLoadedPlugins(actionCallback, expectedState, pluginId);
                }
            } else {
                Objects.requireNonNull(descriptor);
                CheckPluginStateCommand.checkPluginInLoadedPlugins(actionCallback, expectedState, pluginId);
            }
        });
    }

    private static void checkPluginInLoadedPlugins(@NotNull ActionCallback actionCallback, @NotNull PluginEnabledState expectedState, @NotNull PluginId pluginId) {
        if (actionCallback == null) {
            CheckPluginStateCommand.$$$reportNull$$$0(3);
        }
        if (expectedState == null) {
            CheckPluginStateCommand.$$$reportNull$$$0(4);
        }
        if (pluginId == null) {
            CheckPluginStateCommand.$$$reportNull$$$0(5);
        }
        for (IdeaPluginDescriptor loadedPlugin : PluginManagerCore.getLoadedPlugins()) {
            if (!loadedPlugin.getPluginId().equals((Object)pluginId)) continue;
            String message = "Plugin '" + pluginId + "' is loaded";
            if (expectedState.isEnabled()) {
                LOG.info(message);
                actionCallback.setDone();
            } else {
                actionCallback.reject(message);
            }
            return;
        }
        CheckPluginStateCommand.assertIsDisabled(actionCallback, expectedState, "Plugin '" + pluginId + "' is not loaded");
    }

    private static void assertIsDisabled(@NotNull ActionCallback actionCallback, @NotNull PluginEnabledState expectedState, @NotNull String message) {
        if (actionCallback == null) {
            CheckPluginStateCommand.$$$reportNull$$$0(6);
        }
        if (expectedState == null) {
            CheckPluginStateCommand.$$$reportNull$$$0(7);
        }
        if (message == null) {
            CheckPluginStateCommand.$$$reportNull$$$0(8);
        }
        if (expectedState.isEnabled()) {
            actionCallback.reject(message);
        } else {
            LOG.info(message);
            actionCallback.setDone();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionCallback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/dynamicPlugins/performanceTesting/CheckPluginStateCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPluginInLoadedPlugins";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "assertIsDisabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

