/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.StructureViewWrapperImpl;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLAlias;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.structureView.YAMLAliasResolveNodeProvider;
import org.jetbrains.yaml.structureView.YAMLCustomStructureViewFactory;
import org.jetbrains.yaml.structureView.YAMLStructureViewFile;
import org.jetbrains.yaml.structureView.YAMLStructureViewKeyValueDuplicated;
import org.jetbrains.yaml.structureView.YAMLStructureViewKeyValueOriginal;
import org.jetbrains.yaml.structureView.YAMLStructureViewSequenceItemDuplicated;
import org.jetbrains.yaml.structureView.YAMLStructureViewSequenceItemOriginal;

public final class YAMLStructureViewFactory
implements PsiStructureViewFactory {
    static final Icon ALIAS_ICON = AllIcons.Nodes.Alias;

    public YAMLStructureViewFactory() {
        YAMLCustomStructureViewFactory.EP_NAME.addChangeListener(() -> ((Runnable)ApplicationManager.getApplication().getMessageBus().syncPublisher(StructureViewWrapperImpl.STRUCTURE_CHANGED)).run(), ExtensionPointUtil.createKeyedExtensionDisposable((Object)this, (ExtensionPoint)PsiStructureViewFactory.EP_NAME.getPoint()));
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder(final @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            YAMLStructureViewFactory.$$$reportNull$$$0(0);
        }
        if (!(psiFile instanceof YAMLFile)) {
            return null;
        }
        for (YAMLCustomStructureViewFactory extension : YAMLCustomStructureViewFactory.EP_NAME.getExtensionList()) {
            StructureViewBuilder builder = extension.getStructureViewBuilder((YAMLFile)psiFile);
            if (builder == null) continue;
            return builder;
        }
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                StructureViewModelBase structureViewModelBase = new StructureViewModelBase(psiFile, editor, (StructureViewTreeElement)new YAMLStructureViewFile((YAMLFile)psiFile)){

                    @NotNull
                    public Collection<NodeProvider<?>> getNodeProviders() {
                        Set<YAMLAliasResolveNodeProvider> set = Collections.singleton(new YAMLAliasResolveNodeProvider());
                        if (set == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return set;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/structureView/YAMLStructureViewFactory$1$1", "getNodeProviders"));
                    }
                }.withSorters(new Sorter[]{Sorter.ALPHA_SORTER}).withSuitableClasses(new Class[]{YAMLFile.class, YAMLDocument.class, YAMLKeyValue.class});
                if (structureViewModelBase == null) {
                    1.$$$reportNull$$$0(0);
                }
                return structureViewModelBase;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/structureView/YAMLStructureViewFactory$1", "createStructureViewModel"));
            }
        };
    }

    @NotNull
    static String getAliasPresentableText(@NotNull YAMLAlias alias) {
        if (alias == null) {
            YAMLStructureViewFactory.$$$reportNull$$$0(1);
        }
        String string = "*" + alias.getAliasName();
        if (string == null) {
            YAMLStructureViewFactory.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    static Collection<StructureViewTreeElement> createChildrenViewTreeElements(@Nullable YAMLPsiElement element, final @Nullable String path) {
        if (element == null) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                YAMLStructureViewFactory.$$$reportNull$$$0(3);
            }
            return list;
        }
        final Ref result = Ref.create(Collections.emptyList());
        element.accept(new YamlPsiElementVisitor(){

            @Override
            public void visitSequence(@NotNull YAMLSequence sequence) {
                if (sequence == null) {
                    2.$$$reportNull$$$0(0);
                }
                result.set((Object)ContainerUtil.map(sequence.getItems(), i -> path == null ? new YAMLStructureViewSequenceItemOriginal((YAMLSequenceItem)i) : new YAMLStructureViewSequenceItemDuplicated((YAMLSequenceItem)i, path)));
            }

            @Override
            public void visitMapping(@NotNull YAMLMapping mapping) {
                if (mapping == null) {
                    2.$$$reportNull$$$0(1);
                }
                result.set((Object)ContainerUtil.map(mapping.getKeyValues(), kv -> path == null ? new YAMLStructureViewKeyValueOriginal((YAMLKeyValue)kv) : new YAMLStructureViewKeyValueDuplicated((YAMLKeyValue)kv, path)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sequence";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mapping";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/yaml/structureView/YAMLStructureViewFactory$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSequence";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMapping";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        Collection collection2 = (Collection)result.get();
        if (collection2 == null) {
            YAMLStructureViewFactory.$$$reportNull$$$0(4);
        }
        return collection2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/structureView/YAMLStructureViewFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/structureView/YAMLStructureViewFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasPresentableText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildrenViewTreeElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStructureViewBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAliasPresentableText";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

