/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSplitElseIfIntention
extends JSIntention {
    @IntentionName
    @NotNull
    public String getText() {
        String string = JSIntentionBundle.message("trivialif.split-else-if.display-name", new Object[0]);
        if (string == null) {
            JSSplitElseIfIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("trivialif.split-else-if.family-name", new Object[0]);
        if (string == null) {
            JSSplitElseIfIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new SplitElseIfPredicate();
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSSplitElseIfIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSSplitElseIfIntention.$$$reportNull$$$0(3);
        }
        JSIfStatement parentStatement = (JSIfStatement)element.getParent();
        assert (parentStatement != null);
        JSStatement elseBranch = (JSStatement)parentStatement.getElseBranch();
        String newStatement = "{" + elseBranch.getText() + "}";
        JSRefactoringUtil.replaceStatementAndReformat((JSStatement)elseBranch, (String)newStatement);
    }

    @Override
    protected boolean stopTraversingUp(@Nullable PsiElement element) {
        return super.stopTraversingUp(element) || element instanceof JSExpression && !ConditionalUtils.isInIfCondition((JSExpression)element);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSSplitElseIfIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSSplitElseIfIntention.$$$reportNull$$$0(5);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSIfStatement parentIf = (JSIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSIfStatement.class);
        return parentIf == null || !PsiTreeUtil.isAncestor((PsiElement)parentIf.getElseBranch(), (PsiElement)element, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitElseIfIntention";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitElseIfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    private static class SplitElseIfPredicate
    implements JSElementPredicate {
        private SplitElseIfPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            PsiElement parent;
            if (element == null) {
                SplitElseIfPredicate.$$$reportNull$$$0(0);
            }
            if (!((parent = element.getParent()) instanceof JSIfStatement)) {
                return false;
            }
            JSIfStatement ifStatement = (JSIfStatement)parent;
            if (PsiUtilCore.hasErrorElementChild((PsiElement)ifStatement)) {
                return false;
            }
            JSStatement thenBranch = (JSStatement)ifStatement.getThenBranch();
            JSStatement elseBranch = (JSStatement)ifStatement.getElseBranch();
            return thenBranch != null && elseBranch instanceof JSIfStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitElseIfIntention$SplitElseIfPredicate", "satisfiedBy"));
        }
    }
}

