/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMergeParallelIfsIntention
extends JSIntention {
    @NonNls
    private static final String IF_STATEMENT_PREFIX = "if (";
    @NonNls
    private static final String ELSE_KEYWORD = "else ";

    @IntentionName
    @NotNull
    public String getText() {
        String string = JSIntentionBundle.message("trivialif.merge-parallel-ifs.display-name", new Object[0]);
        if (string == null) {
            JSMergeParallelIfsIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("trivialif.merge-parallel-ifs.family-name", new Object[0]);
        if (string == null) {
            JSMergeParallelIfsIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new MergeParallelIfsPredicate();
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSMergeParallelIfsIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSMergeParallelIfsIntention.$$$reportNull$$$0(3);
        }
        PsiElement nextElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        assert (nextElement != null);
        JSIfStatement firstStatement = (JSIfStatement)element;
        JSIfStatement secondStatement = (JSIfStatement)nextElement;
        StringBuilder statementBuffer = new StringBuilder();
        this.mergeIfStatements(statementBuffer, firstStatement, secondStatement);
        JSRefactoringUtil.replaceStatementAndReformat((JSStatement)firstStatement, (String)statementBuffer.toString());
        JSRefactoringUtil.removeElementWithLinebreak((PsiElement)secondStatement);
    }

    private void mergeIfStatements(StringBuilder statementBuffer, JSIfStatement firstStatement, JSIfStatement secondStatement) {
        JSExpression condition = firstStatement.getCondition();
        JSStatement firstThenBranch = (JSStatement)firstStatement.getThenBranch();
        JSStatement secondThenBranch = (JSStatement)secondStatement.getThenBranch();
        JSStatement firstElseBranch = (JSStatement)firstStatement.getElseBranch();
        JSStatement secondElseBranch = (JSStatement)secondStatement.getElseBranch();
        statementBuffer.append(IF_STATEMENT_PREFIX).append(condition.getText()).append(')');
        ControlFlowUtils.appendStatementsInSequence((StringBuilder)statementBuffer, (JSStatement)firstThenBranch, (JSStatement)secondThenBranch);
        if (firstElseBranch != null || secondElseBranch != null) {
            statementBuffer.append(ELSE_KEYWORD);
            if (firstElseBranch instanceof JSIfStatement && secondElseBranch instanceof JSIfStatement && MergeParallelIfsPredicate.ifStatementsCanBeMerged((JSIfStatement)firstElseBranch, (JSIfStatement)secondElseBranch)) {
                this.mergeIfStatements(statementBuffer, (JSIfStatement)firstElseBranch, (JSIfStatement)secondElseBranch);
            } else {
                ControlFlowUtils.appendStatementsInSequence((StringBuilder)statementBuffer, (JSStatement)firstElseBranch, (JSStatement)secondElseBranch);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeParallelIfsIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeParallelIfsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static class MergeParallelIfsPredicate
    implements JSElementPredicate {
        private MergeParallelIfsPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                MergeParallelIfsPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSIfStatement) || PsiUtilCore.hasErrorElementChild((PsiElement)element)) {
                return false;
            }
            PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
            if (!(nextStatement instanceof JSIfStatement) || PsiUtilCore.hasErrorElementChild((PsiElement)nextStatement)) {
                return false;
            }
            return MergeParallelIfsPredicate.ifStatementsCanBeMerged((JSIfStatement)element, (JSIfStatement)nextStatement);
        }

        public static boolean ifStatementsCanBeMerged(JSIfStatement statement1, JSIfStatement statement2) {
            JSExpression secondCondition;
            JSStatement thenBranch = (JSStatement)statement1.getThenBranch();
            JSStatement elseBranch = (JSStatement)statement1.getElseBranch();
            if (thenBranch == null) {
                return false;
            }
            JSExpression firstCondition = statement1.getCondition();
            if (!EquivalenceChecker.expressionsAreEquivalent((JSExpression)firstCondition, (JSExpression)(secondCondition = statement2.getCondition()))) {
                return false;
            }
            JSStatement nextThenBranch = (JSStatement)statement2.getThenBranch();
            if (!ControlFlowUtils.canBeMerged((JSStatement)thenBranch, (JSStatement)nextThenBranch)) {
                return false;
            }
            JSStatement nextElseBranch = (JSStatement)statement2.getElseBranch();
            return elseBranch == null || nextElseBranch == null || ControlFlowUtils.canBeMerged((JSStatement)elseBranch, (JSStatement)nextElseBranch);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeParallelIfsIntention$MergeParallelIfsPredicate", "satisfiedBy"));
        }
    }
}

