/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.increment;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSExpressionWithOperationNode;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunctionExitPoint;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.braces.JSAddBracesIntention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExtractIncrementIntention
extends JSMutablyNamedIntention {
    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("increment.extract-increment.family-name", new Object[0]);
        if (string == null) {
            JSExtractIncrementIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public String getTextForElement(PsiElement element) {
        return JSIntentionBundle.message("increment.extract-increment.display-name", ((JSExpressionWithOperationNode)element).getOperationNode().getText());
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new ExtractIncrementPredicate();
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        boolean isPostfix;
        JSExpression operand;
        if (project == null) {
            JSExtractIncrementIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSExtractIncrementIntention.$$$reportNull$$$0(2);
        }
        JSExpression jSExpression = operand = (isPostfix = element instanceof JSPostfixExpression) ? ((JSPostfixExpression)element).getExpression() : ((JSPrefixExpression)element).getExpression();
        if (operand == null) {
            return;
        }
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
        assert (statement != null);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)element);
        JSStatement statementNode = JSPsiElementFactory.createJSStatement((String)(element.getText() + semicolon), (PsiElement)element);
        if (statement instanceof JSLoopStatement) {
            JSStatement body = ((JSLoopStatement)statement).getBody();
            if (!(body instanceof JSBlockStatement)) {
                assert (body != null);
                new JSAddBracesIntention().processIntention(project, editor, (PsiElement)body);
            }
            JSBlockStatement block = (JSBlockStatement)((JSLoopStatement)statement).getBody();
            assert (block != null);
            block.addAfter((PsiElement)statementNode, block.getFirstChild());
            if (statement instanceof JSForStatement) {
                element.delete();
            } else {
                JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)((JSExpression)element), (String)operand.getText());
            }
            return;
        }
        if (isPostfix) {
            statement.addStatementAfter(statementNode);
        } else {
            statement.addStatementBefore(statementNode);
        }
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)((JSExpression)element), (String)operand.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/increment/JSExtractIncrementIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/increment/JSExtractIncrementIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class ExtractIncrementPredicate
    implements JSElementPredicate {
        private ExtractIncrementPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                ExtractIncrementPredicate.$$$reportNull$$$0(0);
            }
            if (!ExpressionUtil.isIncrementDecrementExpression((PsiElement)element)) {
                return false;
            }
            if (PsiUtilCore.hasErrorElementChild((PsiElement)element)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof JSExpressionStatement) {
                return false;
            }
            JSStatement containingStatement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
            if (element instanceof JSPostfixExpression && containingStatement instanceof JSFunctionExitPoint) {
                return false;
            }
            return containingStatement != null && (!(containingStatement instanceof JSLoopStatement) || ExtractIncrementPredicate.isSuitableForLoop((JSLoopStatement)containingStatement, element));
        }

        private static boolean isSuitableForLoop(JSLoopStatement statement, PsiElement element) {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/increment/JSExtractIncrementIntention$ExtractIncrementPredicate", "satisfiedBy"));
        }
    }
}

