/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.comment;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMoveCommentToSeparateLineIntention
extends JSIntention {
    @IntentionName
    @NotNull
    public String getText() {
        String string = JSIntentionBundle.message("comment.move-comment-to-separate-line.display-name", new Object[0]);
        if (string == null) {
            JSMoveCommentToSeparateLineIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("comment.move-comment-to-separate-line.family-name", new Object[0]);
        if (string == null) {
            JSMoveCommentToSeparateLineIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        return new CommentOnLineWithSourcePredicate();
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSMoveCommentToSeparateLineIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSMoveCommentToSeparateLineIntention.$$$reportNull$$$0(3);
        }
        PsiComment comment = (PsiComment)element;
        PsiElement anchor = JSMoveCommentToSeparateLineIntention.findAnchor(comment);
        JSSourceElement parentSourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)anchor, JSSourceElement.class);
        assert (parentSourceElement != null);
        parentSourceElement.getParent().addBefore((PsiElement)JSPsiElementFactory.createPsiComment((String)comment.getText(), (PsiElement)comment), (PsiElement)parentSourceElement);
        comment.delete();
    }

    @NotNull
    private static PsiElement findAnchor(PsiComment comment) {
        PsiElement prevLeaf;
        PsiComment anchor = comment;
        while ((prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)anchor)) != null && !JSUtils.isLineBreakWhiteSpace((PsiElement)prevLeaf)) {
            anchor = prevLeaf;
        }
        PsiComment psiComment = anchor;
        if (psiComment == null) {
            JSMoveCommentToSeparateLineIntention.$$$reportNull$$$0(4);
        }
        return psiComment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/comment/JSMoveCommentToSeparateLineIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/comment/JSMoveCommentToSeparateLineIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnchor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static class CommentOnLineWithSourcePredicate
    implements JSElementPredicate {
        private CommentOnLineWithSourcePredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                CommentOnLineWithSourcePredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof PsiComment)) {
                return false;
            }
            PsiComment comment = (PsiComment)element;
            IElementType type = comment.getTokenType();
            if (!JSTokenTypes.C_STYLE_COMMENT.equals(type) && !JSTokenTypes.END_OF_LINE_COMMENT.equals(type)) {
                return false;
            }
            PsiElement prevSibling = PsiTreeUtil.prevLeaf((PsiElement)element);
            if (prevSibling == null) {
                return false;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)JSMoveCommentToSeparateLineIntention.findAnchor(comment), JSSourceElement.class) == null) {
                return false;
            }
            if (!JSUtils.isLineBreakWhiteSpace((PsiElement)prevSibling)) {
                return true;
            }
            PsiElement nextSibling = PsiTreeUtil.nextLeaf((PsiElement)element);
            return !JSUtils.isLineBreakWhiteSpace((PsiElement)nextSibling);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/comment/JSMoveCommentToSeparateLineIntention$CommentOnLineWithSourcePredicate", "satisfiedBy"));
        }
    }
}

