/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.braces;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.Set;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRemoveBracesIntention
extends JSMutablyNamedIntention {
    @NonNls
    private static final String IF_KEYWORD = "if";
    @NonNls
    private static final String ELSE_KEYWORD = "else";

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        return new RemoveBracesPredicate();
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        String keyword;
        JSElement parent = (JSElement)element.getParent();
        assert (parent != null);
        if (parent instanceof JSIfStatement) {
            JSIfStatement ifStatement = (JSIfStatement)parent;
            JSStatement elseBranch = (JSStatement)ifStatement.getElseBranch();
            keyword = element.equals(elseBranch) ? ELSE_KEYWORD : IF_KEYWORD;
        } else {
            PsiElement keywordChild = parent.getFirstChild();
            assert (keywordChild != null);
            keyword = keywordChild.getText();
        }
        return JSIntentionBundle.message("braces.remove-braces.display-name", keyword);
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("braces.remove-braces.family-name", new Object[0]);
        if (string == null) {
            JSRemoveBracesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSRemoveBracesIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSRemoveBracesIntention.$$$reportNull$$$0(2);
        }
        JSBlockStatement blockStatement = (JSBlockStatement)element;
        JSSourceElement[] statements = blockStatement.getStatementListItems();
        JSSourceElement statement = statements[0];
        Set<PsiElement> blockParent = Collections.singleton(blockStatement.getParent());
        new CommentsMover(statement).move(blockParent, blockParent);
        JSRefactoringUtil.replaceStatementAndReformat((JSStatement)blockStatement, (String)statement.getText());
    }

    @Override
    protected boolean stopTraversingUp(@Nullable PsiElement element) {
        return super.stopTraversingUp(element) || element instanceof JSExpression && !ConditionalUtils.isInIfCondition((JSExpression)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/braces/JSRemoveBracesIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/braces/JSRemoveBracesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static class RemoveBracesPredicate
    implements JSElementPredicate {
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                RemoveBracesPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSBlockStatement)) {
                return false;
            }
            JSBlockStatement blockStatement = (JSBlockStatement)element;
            PsiElement parent = blockStatement.getParent();
            if (!(parent instanceof JSIfStatement) && !(parent instanceof JSLoopStatement)) {
                return false;
            }
            JSSourceElement[] statements = blockStatement.getStatementListItems();
            return statements.length == 1 && statements[0] instanceof JSStatement && !(statements[0] instanceof JSVarStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSRemoveBracesIntention$RemoveBracesPredicate", "satisfiedBy"));
        }
    }
}

