/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.braces;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAddBracesIntention
extends JSMutablyNamedIntention {
    @NonNls
    private static final String IF_KEYWORD = "if";
    @NonNls
    private static final String ELSE_KEYWORD = "else";

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        return new AddBracesPredicate();
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        String keyword;
        JSElement parent = (JSElement)element.getParent();
        assert (parent != null);
        if (JSAddBracesIntention.isShorthandArrowFunction(element)) {
            return JavaScriptBundle.message((String)"js.add.braces.to.arrow.function", (Object[])new Object[0]);
        }
        if (parent instanceof JSIfStatement) {
            JSIfStatement ifStatement = (JSIfStatement)parent;
            JSStatement elseBranch = (JSStatement)ifStatement.getElseBranch();
            keyword = JSAddBracesIntention.quote(element.equals(elseBranch) ? ELSE_KEYWORD : IF_KEYWORD);
        } else {
            PsiElement firstChild = parent.getFirstChild();
            assert (firstChild != null);
            keyword = JSAddBracesIntention.quote(firstChild.getText());
        }
        return JSIntentionBundle.message("braces.add-braces.display-name", keyword);
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("braces.add-braces.family-name", new Object[0]);
        if (string == null) {
            JSAddBracesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static String quote(@NotNull String s) {
        if (s == null) {
            JSAddBracesIntention.$$$reportNull$$$0(1);
        }
        return "'" + s + "'";
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSAddBracesIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSAddBracesIntention.$$$reportNull$$$0(3);
        }
        if (element instanceof JSFunctionExpression && JSAddBracesIntention.isShorthandArrowFunction(element)) {
            JSRefactoringUtil.addBracesToShorthandArrowFunction((JSFunctionExpression)((JSFunctionExpression)element));
            return;
        }
        JSRefactoringUtil.addBracesToStatement((PsiElement)element);
    }

    private static boolean isShorthandArrowFunction(@NotNull PsiElement element) {
        if (element == null) {
            JSAddBracesIntention.$$$reportNull$$$0(4);
        }
        return element instanceof JSFunctionExpression && ((JSFunctionExpression)element).isShorthandArrowFunction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isShorthandArrowFunction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private static class AddBracesPredicate
    implements JSElementPredicate {
        private AddBracesPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                AddBracesPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSStatement)) {
                return JSAddBracesIntention.isShorthandArrowFunction(element);
            }
            if (element instanceof JSBlockStatement) {
                return false;
            }
            PsiElement parentElement = element.getParent();
            if (!(parentElement instanceof JSElement)) {
                return false;
            }
            JSElement parent = (JSElement)parentElement;
            if (parent instanceof JSIfStatement) {
                JSIfStatement ifStatement = (JSIfStatement)parent;
                return !(element instanceof JSIfStatement) || !element.equals(ifStatement.getElseBranch());
            }
            if (parent instanceof JSForStatement || parent instanceof JSForInStatement) {
                return element.equals(((JSLoopStatement)parent).getBody());
            }
            return parent instanceof JSWhileStatement || parent instanceof JSDoWhileStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention$AddBracesPredicate", "satisfiedBy"));
        }
    }
}

