/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.bool;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.bool.ConjunctionPredicate;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDeMorgansLawIntention
extends JSMutablyNamedIntention {
    private static final String AND_OPERATOR = "&&";
    private static final String OR_OPERATOR = "||";

    @Override
    protected String getTextForElement(PsiElement element) {
        IElementType tokenType = ((JSBinaryExpression)element).getOperationSign();
        return JSTokenTypes.ANDAND.equals(tokenType) ? JSIntentionBundle.message("bool.de-morgans-law.display-name.ANDAND", new Object[0]) : JSIntentionBundle.message("bool.de-morgans-law.display-name.OROR", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        String string = JSIntentionBundle.message("bool.de-morgans-law.family-name", new Object[0]);
        if (string == null) {
            JSDeMorgansLawIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new ConjunctionPredicate();
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSDeMorgansLawIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSDeMorgansLawIntention.$$$reportNull$$$0(2);
        }
        JSBinaryExpression exp = (JSBinaryExpression)element;
        IElementType tokenType = exp.getOperationSign();
        exp = ConjunctionPredicate.getTopConjunction(exp, tokenType);
        assert (tokenType != null);
        String newExpression = this.convertConjunctionExpression(exp, tokenType);
        ConditionalUtils.replaceExpressionWithNegatedExpressionString((JSExpression)exp, newExpression);
    }

    private String convertConjunctionExpression(JSBinaryExpression exp, IElementType tokenType) {
        IElementType flippedOperator = tokenType.equals(JSTokenTypes.ANDAND) ? JSTokenTypes.OROR : JSTokenTypes.ANDAND;
        int precedence = flippedOperator.equals(JSTokenTypes.ANDAND) ? 14 : 15;
        String leftText = this.getOperandText(exp.getLOperand(), tokenType, precedence);
        String rightText = this.getOperandText(exp.getROperand(), tokenType, precedence);
        String flippedConjunction = flippedOperator.equals(JSTokenTypes.ANDAND) ? AND_OPERATOR : OR_OPERATOR;
        return leftText + flippedConjunction + rightText;
    }

    private String getOperandText(JSExpression operand, IElementType tokenType, int precedence) {
        return ConjunctionPredicate.isConjunctionExpression((JSElement)operand, tokenType) ? this.convertConjunctionExpression((JSBinaryExpression)operand, tokenType) : BoolUtils.getNegatedExpressionText(operand, precedence);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/bool/JSDeMorgansLawIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/bool/JSDeMorgansLawIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

