/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.style;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueMatchData;
import com.intellij.psi.css.impl.CssElementType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.descriptor.value.CssIntegerValue;
import com.intellij.psi.css.impl.descriptor.value.CssLengthValue;
import com.intellij.psi.css.impl.descriptor.value.CssPercentageValue;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class CssRedundantUnitInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssRedundantUnitInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(){

            @Override
            public void visitCssDeclaration(CssDeclaration cssDeclaration) {
                Collection<? extends CssPropertyDescriptor> descriptors = cssDeclaration.getDescriptors();
                if (descriptors.isEmpty()) {
                    return;
                }
                CssTermList termList = cssDeclaration.getValue();
                if (termList == null) {
                    return;
                }
                Set matchDatas = null;
                block0: for (CssTerm term : termList.getTerms()) {
                    IElementType iElementType;
                    PsiElement nextSibling;
                    PsiElement child;
                    PsiElement firstTermElement = term.getFirstChild();
                    if (firstTermElement == null || !((child = firstTermElement.getFirstChild()) instanceof CssTokenImpl) || !child.textMatches((CharSequence)"0") || (nextSibling = child.getNextSibling()) == null || nextSibling instanceof PsiWhiteSpace || "fr".equalsIgnoreCase(nextSibling.getText()) || (iElementType = ((CssTokenImpl)child).getElementType()) != CssElementTypes.CSS_NUMBER) continue;
                    if (matchDatas == null) {
                        matchDatas = descriptors.stream().map(descriptor -> termList.matchWithValueDescriptor(descriptor.getValueDescriptor())).collect(Collectors.toSet());
                    }
                    for (CssValueMatchData matchData : matchDatas) {
                        CssValueDescriptor valueDescriptor = matchData.findDeepestDescriptorForElement(term);
                        if (!(valueDescriptor instanceof CssLengthValue) && !(valueDescriptor instanceof CssPercentageValue) && !(valueDescriptor instanceof CssIntegerValue)) continue;
                        holder.registerProblem(nextSibling, CssBundle.message("css.inspections.redundant.unit.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveUnitQualifier()});
                        continue block0;
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/style/CssRedundantUnitInspection", "buildVisitor"));
    }

    private static class RemoveUnitQualifier
    implements LocalQuickFix {
        private RemoveUnitQualifier() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message("css.inspections.redundant.unit.fix.message", new Object[0]);
            if (string == null) {
                RemoveUnitQualifier.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement;
            if (project == null) {
                RemoveUnitQualifier.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveUnitQualifier.$$$reportNull$$$0(2);
            }
            if ((psiElement = descriptor.getPsiElement()) != null && psiElement.isValid() && (psiElement instanceof CssElement || psiElement.getNode().getElementType() instanceof CssElementType)) {
                psiElement.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/style/CssRedundantUnitInspection$RemoveUnitQualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/style/CssRedundantUnitInspection$RemoveUnitQualifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

