/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssElementDescriptorConstants;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssFixFactory;
import com.intellij.psi.css.inspections.CssInspectionFilter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CssNoGenericFontNameInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            CssNoGenericFontNameInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(){

            @Override
            public void visitCssDeclaration(CssDeclaration cssDeclaration) {
                String propertyName = CssDescriptorsUtil.getCanonicalPropertyName(cssDeclaration);
                if ("font-family".equals(propertyName) && CssNoGenericFontNameInspection.isGenericFontFamilyMissed(cssDeclaration)) {
                    LocalQuickFix[] localQuickFixArray;
                    if (isOnTheFly) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = CssFixFactory.getInstance().insertGenericFontFamilyAction(cssDeclaration);
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    LocalQuickFix[] quickFixes = localQuickFixArray;
                    holder.registerProblem((PsiElement)cssDeclaration, CssBundle.message("css.overwritten.nongeneric.fontname.message", propertyName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, quickFixes);
                }
            }
        };
    }

    public static boolean isGenericFontFamilyMissed(@NotNull CssDeclaration cssDeclaration) {
        CssTerm[] terms;
        IElementType elementType;
        CssAtRule atRule;
        if (cssDeclaration == null) {
            CssNoGenericFontNameInspection.$$$reportNull$$$0(1);
        }
        if ((atRule = (CssAtRule)PsiTreeUtil.getParentOfType((PsiElement)cssDeclaration, CssAtRule.class)) != null && ((elementType = atRule.getNode().getElementType()) == CssElementTypes.CSS_FONTFACE || elementType == CssElementTypes.CSS_FONT_PALETTE_VALUES)) {
            return false;
        }
        CssTermList termList = cssDeclaration.getValue();
        Language language = CssPsiUtil.getStylesheetLanguage(cssDeclaration);
        if (language == null) {
            return false;
        }
        CssInspectionFilter inspectionFilter = (CssInspectionFilter)CssInspectionFilter.INSTANCE.forLanguage(language);
        if (inspectionFilter != null && !inspectionFilter.isValueShouldBeValidatedWithCssScheme(termList)) {
            return false;
        }
        CssTerm[] cssTermArray = terms = termList != null ? termList.getTerms() : CssTerm.TERMS_EMPTY_ARRAY;
        if (terms.length == 1 && ArrayUtil.contains((String)terms[0].getText().trim(), (String[])new String[]{"initial", "inherit", "revert", "unset"})) {
            return false;
        }
        for (CssTerm term : terms) {
            if (!CssElementDescriptorConstants.GENERIC_FONT_NAMES.contains(StringUtil.unquoteString((String)term.getText().trim()))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssDeclaration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/inspections/bugs/CssNoGenericFontNameInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isGenericFontFamilyMissed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

