/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.CssLazyStylesheet;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class CssQuotesFormatPreprocessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode node, @NotNull TextRange range) {
        PsiElement formattingRoot;
        if (node == null) {
            CssQuotesFormatPreprocessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            CssQuotesFormatPreprocessor.$$$reportNull$$$0(1);
        }
        if ((formattingRoot = node.getPsi()) == null || !formattingRoot.isValid()) {
            TextRange textRange = range;
            if (textRange == null) {
                CssQuotesFormatPreprocessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        if (formattingRoot.getContainingFile().getContext() != null) {
            TextRange textRange = range;
            if (textRange == null) {
                CssQuotesFormatPreprocessor.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        Collection<Object> elements = !(formattingRoot instanceof CssElement) && formattingRoot.getContainingFile() instanceof HtmlCompatibleFile ? PsiTreeUtil.findChildrenOfType((PsiElement)formattingRoot, CssLazyStylesheet.class) : Collections.singleton(formattingRoot);
        for (PsiElement element : elements) {
            CssCodeStyleSettings settings = CssCodeStyleSettings.getLanguageSpecificSettings(element);
            if (settings == null || !settings.ENFORCE_QUOTES_ON_FORMAT) continue;
            char quoteChar = settings.USE_DOUBLE_QUOTES ? (char)'\"' : '\'';
            CssQuotesConverter converter = new CssQuotesConverter(quoteChar);
            element.accept((PsiElementVisitor)converter);
            range = range.grown(converter.getRangeDelta());
        }
        TextRange textRange = range;
        if (textRange == null) {
            CssQuotesFormatPreprocessor.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/editor/CssQuotesFormatPreprocessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/editor/CssQuotesFormatPreprocessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class CssQuotesConverter
    extends CssElementVisitor {
        private final char myOldQuoteChar;
        private final char myNewQuoteChar;
        private int myRangeDelta = 0;

        CssQuotesConverter(char quoteChar) {
            this.myOldQuoteChar = (char)(quoteChar == '\"' ? 39 : 34);
            this.myNewQuoteChar = quoteChar;
        }

        private int getRangeDelta() {
            return this.myRangeDelta;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                CssQuotesConverter.$$$reportNull$$$0(0);
            }
            element.acceptChildren((PsiElementVisitor)this);
        }

        @Override
        public void visitCssString(CssString string) {
            if (string.getParent() instanceof CssCharset) {
                return;
            }
            if (string.getTextLength() < 2) {
                return;
            }
            String oldText = string.getText();
            if (oldText.charAt(0) == this.myOldQuoteChar && oldText.charAt(oldText.length() - 1) == this.myOldQuoteChar) {
                String newText = oldText.substring(1, oldText.length() - 1);
                newText = StringUtil.replace((String)newText, (String)("\\" + this.myOldQuoteChar), (String)String.valueOf(this.myOldQuoteChar));
                newText = StringUtil.replace((String)newText, (String)String.valueOf(this.myNewQuoteChar), (String)("\\" + this.myNewQuoteChar));
                CssString newString = CssElementFactory.getInstance(string.getProject()).createString(this.myNewQuoteChar, newText, string.getLanguage());
                this.myRangeDelta += newString.getTextLength() - string.getTextLength();
                string.replace(newString);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/editor/CssQuotesFormatPreprocessor$CssQuotesConverter", "visitElement"));
        }
    }
}

