/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.css.util.CssConstants;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPropertyInfo;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.descriptor.CssValueOwnerDescriptor;
import com.intellij.psi.css.descriptor.value.CssAnyValue;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssFunctionImpl;
import com.intellij.psi.css.impl.descriptor.value.CompletionCssValueDescriptorMapper;
import com.intellij.psi.css.impl.descriptor.value.CssAngleValue;
import com.intellij.psi.css.impl.descriptor.value.CssColorValue;
import com.intellij.psi.css.impl.descriptor.value.CssDecibelValue;
import com.intellij.psi.css.impl.descriptor.value.CssExpressionValue;
import com.intellij.psi.css.impl.descriptor.value.CssFlexValue;
import com.intellij.psi.css.impl.descriptor.value.CssFrequencyValue;
import com.intellij.psi.css.impl.descriptor.value.CssFunctionInvocationValue;
import com.intellij.psi.css.impl.descriptor.value.CssInlineValue;
import com.intellij.psi.css.impl.descriptor.value.CssIntegerValue;
import com.intellij.psi.css.impl.descriptor.value.CssLengthValue;
import com.intellij.psi.css.impl.descriptor.value.CssNameValue;
import com.intellij.psi.css.impl.descriptor.value.CssNumberValue;
import com.intellij.psi.css.impl.descriptor.value.CssPercentageValue;
import com.intellij.psi.css.impl.descriptor.value.CssResolutionValue;
import com.intellij.psi.css.impl.descriptor.value.CssStringValue;
import com.intellij.psi.css.impl.descriptor.value.CssTimeValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorVisitorImpl;
import com.intellij.psi.css.impl.util.completion.AngleUserLookup;
import com.intellij.psi.css.impl.util.completion.CssCompletionUtil;
import com.intellij.psi.css.impl.util.completion.LengthUserLookup;
import com.intellij.psi.css.impl.util.completion.handler.CssPropertyValueInsertHandler;
import com.intellij.psi.css.impl.util.completion.provider.ValueUnitCompletionVisitor;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssFontFamilyDescriptor;
import com.intellij.psi.css.impl.util.table.CssLookupValue;
import com.intellij.psi.css.inspections.invalid.CssInvalidPropertyValueInspection;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssPropertyValueCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        CssValueDescriptorVisitorImpl visitor;
        Collection<CssValueOwnerDescriptor> descriptors;
        PsiElement parent;
        if (parameters == null) {
            CssPropertyValueCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CssPropertyValueCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            CssPropertyValueCompletionProvider.$$$reportNull$$$0(2);
        }
        PsiElement element = parameters.getPosition();
        PsiElement elementParent = element.getParent();
        boolean isInsideString = elementParent instanceof CssString;
        boolean isValueUnit = elementParent.getNode().getElementType() == CssElementTypes.CSS_NUMBER_TERM || CssPropertyValueCompletionProvider.isUnfinishedFloatValue(element);
        CssTermList cssTermList = (CssTermList)PsiTreeUtil.getParentOfType((PsiElement)element, CssTermList.class);
        PsiElement psiElement = parent = cssTermList == null ? null : cssTermList.getParent();
        if (!isValueUnit) {
            CssPropertyValueCompletionProvider.addVarCompletion(result, element);
        }
        if (parent instanceof CssDeclaration) {
            descriptors = CssInvalidPropertyValueInspection.getFilteredPropertyDescriptors((CssDeclaration)parent);
        } else if (parent instanceof CssFunction) {
            descriptors = CssDescriptorsUtil.filterDescriptorsByContext(((CssFunction)parent).getDescriptors(), element);
        } else {
            return;
        }
        CssValueDescriptorVisitorImpl cssValueDescriptorVisitorImpl = visitor = isValueUnit ? new ValueUnitCompletionVisitor(result) : new ValueDescriptorCompletionVisitor(result, element);
        if (!isValueUnit && CssPropertyValueCompletionProvider.isNotClassicDialectWithSingleAnyValueDescriptor(element, descriptors)) {
            ((ValueDescriptorCompletionVisitor)visitor).addOldSchoolLookupElements((CssPropertyDescriptor)descriptors.iterator().next());
            return;
        }
        boolean isCustomPropertyAtRuleStringValue = com.intellij.psi.css.util.CssCompletionUtil.isCustomPropertyAtRuleSyntaxProperty(element);
        boolean hasNumericValueDescriptor = false;
        for (CssValueOwnerDescriptor descriptor : descriptors) {
            ProgressManager.checkCanceled();
            CompletionCssValueDescriptorMapper mapper = new CompletionCssValueDescriptorMapper(cssTermList);
            mapper.mapValue(descriptor.getValueDescriptor());
            for (CssValueDescriptor valueDescriptor : mapper.getAllowableDescriptorsForCompletion()) {
                if (!valueDescriptor.isShowInCompletion() || isInsideString && !(valueDescriptor instanceof CssStringValue) && !isCustomPropertyAtRuleStringValue || isCustomPropertyAtRuleStringValue && !(valueDescriptor instanceof CssNameValue) && !(valueDescriptor instanceof CssStringValue)) continue;
                if (!hasNumericValueDescriptor && CssPropertyValueCompletionProvider.isNumericDescriptor(valueDescriptor)) {
                    hasNumericValueDescriptor = true;
                }
                valueDescriptor.accept(visitor);
            }
        }
        if (!isValueUnit) {
            CssPropertyValueCompletionProvider.addFunctionCompletions(result, parent, hasNumericValueDescriptor);
        }
    }

    private static boolean isNumericDescriptor(@NotNull CssValueDescriptor valueDescriptor) {
        if (valueDescriptor == null) {
            CssPropertyValueCompletionProvider.$$$reportNull$$$0(3);
        }
        return valueDescriptor instanceof CssAngleValue || valueDescriptor instanceof CssDecibelValue || valueDescriptor instanceof CssExpressionValue || valueDescriptor instanceof CssFlexValue || valueDescriptor instanceof CssFrequencyValue || valueDescriptor instanceof CssIntegerValue || valueDescriptor instanceof CssLengthValue || valueDescriptor instanceof CssNumberValue || valueDescriptor instanceof CssPercentageValue || valueDescriptor instanceof CssResolutionValue || valueDescriptor instanceof CssTimeValue;
    }

    private static void addVarCompletion(@NotNull CompletionResultSet result, @NotNull PsiElement element) {
        PsiElement functionElement;
        PsiElement term;
        if (result == null) {
            CssPropertyValueCompletionProvider.$$$reportNull$$$0(4);
        }
        if (element == null) {
            CssPropertyValueCompletionProvider.$$$reportNull$$$0(5);
        }
        PsiElement termList = (term = element.getParent()) != null ? term.getParent() : null;
        PsiElement psiElement = functionElement = termList != null ? termList.getParent() : null;
        if (functionElement instanceof CssFunction) {
            String functionName = functionElement.getFirstChild().getText();
            if (functionName.equals("var")) {
                for (PsiElement nextSibling = term.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                    if (nextSibling.getNode().getElementType() != CssElementTypes.CSS_COMMA) continue;
                    return;
                }
                boolean hasComma = false;
                for (PsiElement prevSibling = term.getPrevSibling(); prevSibling != null; prevSibling = prevSibling.getPrevSibling()) {
                    if (prevSibling.getNode().getElementType() != CssElementTypes.CSS_COMMA) continue;
                    hasComma = true;
                }
                if (!hasComma) {
                    return;
                }
            } else if (!CssConstants.MATH_FUNCTIONS.contains(functionName) && CssElementDescriptorFactory2.getInstance().findFunction(functionName).isEmpty()) {
                return;
            }
        }
        result.addElement((LookupElement)LookupElementBuilder.create((String)"var()").withInsertHandler(CssPropertyValueInsertHandler.INSTANCE));
    }

    private static boolean isUnfinishedFloatValue(@NotNull PsiElement element) {
        IElementType elementType;
        PsiElement elementParent;
        if (element == null) {
            CssPropertyValueCompletionProvider.$$$reportNull$$$0(6);
        }
        PsiElement prevSibling = (elementParent = element.getParent()) != null ? elementParent.getPrevSibling() : null;
        IElementType iElementType = elementType = prevSibling != null ? prevSibling.getNode().getElementType() : null;
        if (elementType != CssElementTypes.CSS_PERIOD) {
            return false;
        }
        PsiElement termList = elementParent.getParent();
        PsiElement term = termList != null ? termList.getFirstChild() : null;
        PsiElement numberTerm = term != null ? term.getFirstChild() : null;
        IElementType elementTypeBeforeDot = numberTerm != null ? numberTerm.getNode().getElementType() : null;
        return elementTypeBeforeDot == CssElementTypes.CSS_NUMBER_TERM;
    }

    private static void addFunctionCompletions(@NotNull CompletionResultSet result, PsiElement parent, boolean hasNumericValueDescriptor) {
        if (result == null) {
            CssPropertyValueCompletionProvider.$$$reportNull$$$0(7);
        }
        if (hasNumericValueDescriptor) {
            for (String mathFunction : CssConstants.OUTER_MATH_FUNCTIONS) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)(mathFunction + "()")).withInsertHandler(CssPropertyValueInsertHandler.INSTANCE));
            }
        }
        if (parent instanceof CssFunctionImpl && CssConstants.OUTER_MATH_FUNCTIONS.contains(((CssFunctionImpl)parent).getName())) {
            for (String mathFunction : CssConstants.MATH_FUNCTIONS) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)(mathFunction + "()")).withInsertHandler(CssPropertyValueInsertHandler.INSTANCE));
            }
        }
    }

    private static boolean isNotClassicDialectWithSingleAnyValueDescriptor(@NotNull PsiElement element, @NotNull Collection<? extends CssValueOwnerDescriptor> descriptors) {
        CssValueOwnerDescriptor descriptor;
        if (element == null) {
            CssPropertyValueCompletionProvider.$$$reportNull$$$0(8);
        }
        if (descriptors == null) {
            CssPropertyValueCompletionProvider.$$$reportNull$$$0(9);
        }
        if (descriptors.size() == 1 && (descriptor = descriptors.iterator().next()) instanceof CssPropertyDescriptor && descriptor.getValueDescriptor() instanceof CssAnyValue) {
            VirtualFile file = element.getContainingFile().getOriginalFile().getVirtualFile();
            return CssDialectMappings.getInstance(element.getProject()).hasCustomDialect(file);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptor";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/impl/util/completion/provider/CssPropertyValueCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isNumericDescriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addVarCompletion";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnfinishedFloatValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addFunctionCompletions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotClassicDialectWithSingleAnyValueDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ValueDescriptorCompletionVisitor
    extends CssValueDescriptorVisitorImpl {
        @NotNull
        private final CompletionResultSet myCompletionResultSet;
        @NotNull
        private final PsiElement myContext;
        private final Set<String> myProcessedLookupStrings;

        ValueDescriptorCompletionVisitor(@NotNull CompletionResultSet completionResultSet, @NotNull PsiElement context) {
            if (completionResultSet == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(1);
            }
            this.myProcessedLookupStrings = new HashSet<String>();
            this.myCompletionResultSet = completionResultSet;
            this.myContext = context;
        }

        @Override
        public void visitNameValue(@NotNull CssNameValue nameValue) {
            String value;
            if (nameValue == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(2);
            }
            if ((value = nameValue.getValue()) == null) {
                return;
            }
            CssCodeStyleSettings settings = CssCodeStyleSettings.getLanguageSpecificSettings(this.myContext);
            if (settings != null && !settings.USE_DOUBLE_QUOTES && !this.myContext.getText().startsWith("\"") || this.myContext.getText().startsWith("'")) {
                value = value.replace("\"", "'");
            }
            if (this.myProcessedLookupStrings.add(value)) {
                this.myCompletionResultSet.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)nameValue, (String)value).withInsertHandler(CssPropertyValueInsertHandler.INSTANCE), (double)50.0));
            }
        }

        @Override
        public void visitFunctionValue(@NotNull CssFunctionInvocationValue functionValue) {
            String lookupString;
            if (functionValue == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(3);
            }
            char quote = CssCodeStyleSettings.getLanguageSpecificQuote(this.myContext);
            String functionName = functionValue.getFunctionName();
            String string = lookupString = functionName.equals("url") ? functionName + "(" + quote + quote + ")" : functionName + "()";
            if (this.myProcessedLookupStrings.add(lookupString)) {
                this.myCompletionResultSet.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)functionValue, (String)lookupString).withInsertHandler(CssPropertyValueInsertHandler.INSTANCE), (double)50.0));
            }
        }

        @Override
        public void visitStringValue(@NotNull CssStringValue stringValue) {
            Object lookupString;
            String value;
            if (stringValue == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(4);
            }
            if ((value = stringValue.getValue()) == null) {
                return;
            }
            boolean isInsideString = this.myContext.getParent() instanceof CssString;
            Object object = lookupString = isInsideString ? value : "\"" + value + "\"";
            if (this.myProcessedLookupStrings.add((String)lookupString)) {
                this.myCompletionResultSet.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)stringValue, (String)lookupString).withInsertHandler(CssPropertyValueInsertHandler.INSTANCE), (double)50.0));
            }
        }

        @Override
        public void visitColorValue(@NotNull CssColorValue colorValue) {
            if (colorValue == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(5);
            }
            this.addOldSchoolLookupElements(new com.intellij.psi.css.impl.util.table.CssColorValue(colorValue.isAllColorKeywordsKnown()));
        }

        @Override
        public void visitLengthValue(@NotNull CssLengthValue lengthValue) {
            if (lengthValue == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(6);
            }
            this.addOldSchoolLookupElements(new CssLookupValue(new LengthUserLookup(), new CssTermType[0]));
        }

        @Override
        public void visitAngleValue(@NotNull CssAngleValue angleValue) {
            if (angleValue == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(7);
            }
            this.addOldSchoolLookupElements(new CssLookupValue(new AngleUserLookup(), new CssTermType[0]));
        }

        @Override
        public void visitInlineValue(@NotNull CssInlineValue inlineValue) {
            if (inlineValue == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(8);
            }
            if (inlineValue.getRefId().equals("font-family")) {
                this.addOldSchoolLookupElements(new CssFontFamilyDescriptor("font-family", CssPropertyInfo.EMPTY_ARRAY));
            }
        }

        private void addOldSchoolLookupElements(@NotNull CssPropertyDescriptor propertyDescriptor) {
            if (propertyDescriptor == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(9);
            }
            for (Object o : propertyDescriptor.getVariants(this.myContext)) {
                this.addOldSchoolLookupElement(o);
            }
        }

        private void addOldSchoolLookupElements(@NotNull CssPropertyValue oldSchoolPropertyValue) {
            if (oldSchoolPropertyValue == null) {
                ValueDescriptorCompletionVisitor.$$$reportNull$$$0(10);
            }
            this.addOldSchoolLookupElement(oldSchoolPropertyValue.getValue());
            for (CssPropertyValue cssPropertyValue : oldSchoolPropertyValue.getDynamicVariants(this.myContext)) {
                this.addOldSchoolLookupElements(cssPropertyValue);
            }
        }

        private void addOldSchoolLookupElement(@Nullable Object o) {
            LookupElement lookupElement = CssCompletionUtil.valueLookupElement(o);
            if (lookupElement != null && this.myProcessedLookupStrings.add(lookupElement.getLookupString())) {
                this.myCompletionResultSet.addElement(lookupElement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "completionResultSet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionValue";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringValue";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorValue";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lengthValue";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "angleValue";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlineValue";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyDescriptor";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldSchoolPropertyValue";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/css/impl/util/completion/provider/CssPropertyValueCompletionProvider$ValueDescriptorCompletionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNameValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFunctionValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitStringValue";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitColorValue";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLengthValue";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAngleValue";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInlineValue";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addOldSchoolLookupElements";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

