/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.parsing;

import com.intellij.core.CoreBundle;
import com.intellij.indentation.AbstractIndentParser;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.TokenType;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.parsing.CssParser2;
import com.intellij.psi.css.impl.parsing.PreprocessorTokenTypeProvider;
import com.intellij.psi.css.impl.stubs.CssPseudoSelectorStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndentPreprocessorParser
extends AbstractIndentParser {
    protected final WhitespacesAndCommentsBinder COMMENTS_BEFORE_BINDER = new WhitespacesAndCommentsBinder(){

        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            int i;
            for (i = 0; i < tokens.size() && !IndentPreprocessorParser.this.getComments().contains(tokens.get(i)); ++i) {
            }
            return i;
        }
    };
    protected final WhitespacesAndCommentsBinder COMMENTS_AND_INDENT_BEFORE_BINDER = new WhitespacesAndCommentsBinder(){

        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            int lastEolIndex = -1;
            for (int i = 0; i < tokens.size() && IndentPreprocessorParser.this.getWhitespaceTokenSet().contains(tokens.get(i)); ++i) {
                if (tokens.get(i) != IndentPreprocessorParser.this.getEolElementType()) continue;
                lastEolIndex = i;
            }
            return lastEolIndex + 1;
        }
    };
    protected final WhitespacesAndCommentsBinder WHITE_SPACES_AFTER_BINDER = new WhitespacesAndCommentsBinder(){

        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            int i;
            int eolIndex = -1;
            for (i = 0; i < tokens.size(); ++i) {
                IElementType token = tokens.get(i);
                if (!IndentPreprocessorParser.this.getWhitespaceTokenSet().contains(token)) break;
                if (token != IndentPreprocessorParser.this.getEolElementType()) continue;
                if (eolIndex == -1) {
                    eolIndex = i;
                    continue;
                }
                return i;
            }
            return eolIndex == -1 ? i : Math.max(eolIndex - 1, 0);
        }
    };

    protected void parseAttributeRSide() {
        if (!this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_EQ, CssElementTypes.CSS_BEGINS_WITH, CssElementTypes.CSS_ENDS_WITH, CssElementTypes.CSS_CONTAINS, CssElementTypes.CSS_INCLUDES, CssElementTypes.CSS_DASHMATCH})) {
            return;
        }
        this.advance();
        PsiBuilder.Marker attributeRSide = this.mark();
        if (this.parseIdentOrInterpolation()) {
            this.parseInterpolationAfterIdent();
        } else if (!this.parseString(true)) {
            this.error(CssBundle.message("parsing.error.expected.string.or.identifier", new Object[0]));
        }
        attributeRSide.done(CssElementTypes.CSS_ATTRIBUTE_RSIDE);
    }

    protected boolean parseRulesetMedia() {
        if (this.getTokenType() != CssElementTypes.CSS_MEDIA_SYM) {
            return false;
        }
        int indent = this.getCurrentIndent();
        PsiBuilder.Marker media = this.mark();
        this.advance();
        if (this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN) {
            this.parsePseudoFunction();
        } else {
            this.parseMediumList();
        }
        this.parseDeclarationBlock(indent);
        media.done((IElementType)CssElementTypes.CSS_MEDIA);
        return true;
    }

    protected boolean parseRulesetCustomProperty() {
        if (this.getTokenType() != CssElementTypes.CSS_CUSTOM_PROPERTY_AT_RULE_SYM) {
            return false;
        }
        int indent = this.getCurrentIndent();
        PsiBuilder.Marker property = this.mark();
        this.advance();
        this.parseIdent();
        this.parseDeclarationBlock(indent);
        property.done((IElementType)CssElementTypes.CSS_CUSTOM_PROPERTY_AT_RULE);
        return true;
    }

    protected boolean parseString(boolean withInterpolation) {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_STRING_TOKEN})) {
            PsiBuilder.Marker stringMarker = this.mark();
            this.advance();
            while (!(this.eof() || this.isNewLine() || this.hasWhitespaceBefore())) {
                PsiBuilder.Marker possibleError = this.mark();
                if (this.parseInterpolation()) {
                    if (!withInterpolation) {
                        possibleError.error(CssBundle.message("parsing.error.unexpected.interpolation", new Object[0]));
                        continue;
                    }
                    possibleError.drop();
                    continue;
                }
                possibleError.drop();
                if (!this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_STRING_TOKEN})) break;
                this.advance();
            }
            this.done(stringMarker, CssElementTypes.CSS_STRING);
            return true;
        }
        return false;
    }

    protected boolean parseParenthesis() {
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            this.advance();
            this.parseTermList(true, CssElementTypes.CSS_RPAREN);
            this.parseRightParenthesis();
            return true;
        }
        return false;
    }

    protected boolean parseRuleset(int parentIndent) {
        boolean result = false;
        if (this.isNewLine() && parentIndent < this.getCurrentIndent()) {
            PsiBuilder.Marker rulesetMarker = this.mark();
            int indent = this.getCurrentIndent();
            if (this.parseSelectorList(indent)) {
                this.parseDeclarationBlock(indent);
                this.done(rulesetMarker, (IElementType)CssElementTypes.CSS_RULESET);
                result = true;
            } else {
                IndentPreprocessorParser.drop((PsiBuilder.Marker)rulesetMarker);
                result = false;
            }
        }
        return result;
    }

    protected abstract boolean selectorsCouldBeInANewLine(int var1);

    protected boolean parseSelfSufficientHierarchySelector() {
        return false;
    }

    protected boolean tryParseSelectors(int indent) {
        boolean result = false;
        boolean newLine = false;
        while (this.selectorsCouldBeInANewLine(indent) || !newLine) {
            int offset = this.getCurrentOffset();
            if (this.parseSelfSufficientHierarchySelector()) {
                result = true;
            } else if (this.currentTokenIn(CssParser2.SELECTORS_HIERARCHY_TOKENS)) {
                this.advance();
            }
            if (!this.parseSelector() || offset == this.getCurrentOffset()) break;
            newLine = this.isNewLine();
            result = true;
        }
        return result;
    }

    protected boolean parseSelectorList(int indent) {
        return this.parseSelectorList(indent, true, false);
    }

    protected boolean parseSelectorList(int indent, boolean expectEolAfterSelectorList, boolean silent) {
        PsiBuilder.Marker selectorListMarker = this.mark();
        PsiBuilder.Marker selectorMarker = this.mark(true);
        boolean result = this.tryParseSelectors(indent);
        if (result) {
            this.done(selectorMarker, (IElementType)CssElementTypes.CSS_SELECTOR);
        } else {
            this.rollbackTo(selectorMarker);
        }
        while (this.getTokenType() == CssElementTypes.CSS_COMMA) {
            this.advance();
            selectorMarker = this.mark();
            boolean parsed = this.tryParseSelectors(indent);
            if (parsed) {
                this.done(selectorMarker, (IElementType)CssElementTypes.CSS_SELECTOR);
                continue;
            }
            if (!silent) {
                this.error(CssBundle.message("parsing.error.selector.expected", new Object[0]));
            }
            IndentPreprocessorParser.drop((PsiBuilder.Marker)selectorMarker);
        }
        if (result) {
            this.done(selectorListMarker, (IElementType)CssElementTypes.CSS_SELECTOR_LIST);
            if (expectEolAfterSelectorList && !this.ruleCouldContainBraces()) {
                this.expectEolOrEof();
            }
        } else {
            IndentPreprocessorParser.drop((PsiBuilder.Marker)selectorListMarker);
        }
        return result;
    }

    protected boolean parseIdent() {
        if (this.currentTokenIn(this.getPossibleIdentifiers())) {
            this.advance();
            return true;
        }
        return false;
    }

    protected boolean parseIdentOrInterpolation() {
        return this.parseIdent() || this.parseInterpolation();
    }

    protected boolean parseNumber() {
        if (this.getTokenType() == CssElementTypes.CSS_NUMBER) {
            PsiBuilder.Marker numberMarker = this.mark();
            this.advance();
            if (!this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_PERCENT, CssElementTypes.CSS_IDENT}) && this.rawLookup(-1) == CssElementTypes.CSS_NUMBER) {
                this.advance();
            }
            this.done(numberMarker, CssElementTypes.CSS_NUMBER_TERM);
            return true;
        }
        return false;
    }

    protected boolean parseIdentMergedToAmpersand() {
        return false;
    }

    protected boolean parseSelectorPrefix() {
        if (this.getSelectorPrefixTokenTypes().contains(this.getTokenType())) {
            IElementType nextToken = this.rawLookup(1);
            if (!this.getWhitespaceTokenSet().contains(nextToken) && !CssParser2.SELECTORS_HIERARCHY_TOKENS.contains(nextToken) && nextToken != CssElementTypes.CSS_COMMA) {
                this.advance();
                if (!this.isNewLine()) {
                    PsiBuilder.Marker possibleError = this.mark();
                    boolean somethingParsed = this.parseIdentMergedToAmpersand();
                    boolean bl = somethingParsed = this.parseSelectorSuffixList() || somethingParsed;
                    if (somethingParsed) {
                        possibleError.drop();
                    } else {
                        possibleError.error(CssBundle.message("parsing.error.selector.suffix.expected", new Object[0]));
                    }
                }
            } else {
                this.advance();
            }
            return true;
        }
        return false;
    }

    protected boolean parseSelector() {
        PsiBuilder.Marker marker = this.mark(true);
        boolean result = this.parseSelectorPrefix();
        if (!result) {
            result = this.parseTagSimpleSelector();
        }
        if (!result || !this.isNewLine()) {
            IElementType nextToken = this.rawLookup(1);
            if (this.isIdSelectorStart() || this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LBRACKET}) || this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_PERIOD}) && !this.getWhitespaceTokenSet().contains(nextToken) || this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_PERCENT}) || this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COLON}) && !this.getWhitespaceTokenSet().contains(nextToken)) {
                this.parseSelectorSuffixList();
                result = true;
            }
        }
        if (result) {
            this.done(marker, (IElementType)CssElementTypes.CSS_SIMPLE_SELECTOR);
        } else {
            this.rollbackTo(marker);
        }
        return result;
    }

    protected boolean parseUri() {
        if (this.getTokenType() == CssElementTypes.CSS_URI_START) {
            PsiBuilder.Marker uriMarker = this.mark();
            this.advance();
            this.expect(CssElementTypes.CSS_LPAREN, CssBundle.message("parsing.error.opening.parenthesis.expected", new Object[0]));
            if (this.getTokenType() == CssElementTypes.CSS_URL && this.lookAhead(1) == CssElementTypes.CSS_RPAREN) {
                this.advance();
            } else if (!this.parseTerm()) {
                this.errorUntil(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_RPAREN}), CssBundle.message("parsing.error.url.or.string.expected", new Object[0]));
            }
            this.expect(CssElementTypes.CSS_RPAREN, CssBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
            this.done(uriMarker, CssElementTypes.CSS_URI);
            return true;
        }
        return false;
    }

    protected boolean parseTagSimpleSelector() {
        PsiBuilder.Marker toReturn;
        if (this.currentTokenIn(new IElementType[]{this.getMultiplyToken()}) && this.rawLookup(1) == CssElementTypes.CSS_PIPE) {
            this.advance();
            this.advance();
        } else {
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_IDENT}) && this.rawLookup(-1) != this.getInterpolationSuffixToken() && this.rawLookup(1) != this.getInterpolationPrefixToken() && ("to".equals(this.getTokenText()) || "from".equals(this.getTokenText()))) {
                return false;
            }
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_IDENT}) || this.isInterpolation()) {
                toReturn = this.mark(true);
                if (this.isInterpolation()) {
                    this.parseInterpolation();
                    if (!this.isNewLine() && !this.hasWhitespaceBefore()) {
                        this.parseInterpolationAfterIdent();
                    }
                } else {
                    this.parseIdent();
                    this.parseInterpolationAfterIdent();
                }
                if (!this.isNewLine() && !this.hasWhitespaceBefore() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_PIPE})) {
                    toReturn.drop();
                    this.advance();
                } else {
                    this.rollbackTo(toReturn);
                }
            }
        }
        if (this.currentTokenIn(new IElementType[]{this.getMultiplyToken()})) {
            this.advance();
            return true;
        }
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_IDENT}) || this.isInterpolation()) {
            toReturn = this.mark(true);
            this.parseIdentOrInterpolation();
            this.parseInterpolationAfterIdent();
            if (!this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COLON}) && this.getWhitespaceTokenSet().contains(this.rawLookup(1))) {
                this.rollbackTo(toReturn);
                return false;
            }
            toReturn.drop();
            return true;
        }
        return false;
    }

    protected boolean parseImportDestination() {
        return this.parseUri() || this.parseString(false);
    }

    protected boolean parseImport() {
        if (this.getTokenType() == CssElementTypes.CSS_IMPORT_SYM) {
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            if (!this.parseImportDestination()) {
                this.error(CssBundle.message("parsing.error.url.or.string.expected", new Object[0]));
            }
            while (!this.isNewLine() && this.getTokenType() == CssElementTypes.CSS_COMMA) {
                this.advance();
                if (this.parseImportDestination()) continue;
                this.error(CssBundle.message("parsing.error.url.or.string.expected", new Object[0]));
                break;
            }
            if (!this.isNewLine() && !this.eof()) {
                this.parseImportLayer();
            }
            if (!this.isNewLine() && !this.eof()) {
                this.parseImportSupportsCondition();
            }
            if (!this.isNewLine() && !this.eof()) {
                this.parseMediumList();
            }
            this.parseOptionalSemicolon();
            this.done(marker, (IElementType)CssElementTypes.CSS_IMPORT);
            return true;
        }
        return false;
    }

    private void parseImportLayer() {
        if (this.getTokenType() == CssElementTypes.CSS_IDENT && "layer".equals(this.getTokenText())) {
            PsiBuilder.Marker layer = this.mark();
            this.advance();
            layer.done(CssElementTypes.CSS_IMPORT_LAYER);
            return;
        }
        if (this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN && "layer".equals(this.getTokenText()) && this.rawLookup(1) == CssElementTypes.CSS_LPAREN) {
            PsiBuilder.Marker layer = this.mark();
            this.advance();
            this.advance();
            this.parseImportLayerArg();
            if (!this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_RPAREN})) {
                this.advance();
            } else {
                this.error(CssBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
            }
            layer.done(CssElementTypes.CSS_IMPORT_LAYER);
        }
    }

    private void parseImportLayerArg() {
        if (!this.isNewLine() && this.parseIdent()) {
            while (!this.isNewLine() && this.getTokenType() == CssElementTypes.CSS_PERIOD) {
                this.advance();
                if (!this.isNewLine() && this.parseIdent()) continue;
                this.error(CssBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
                break;
            }
        } else {
            this.error(CssBundle.message("parsing.error.identifier.expected", new Object[0]));
        }
    }

    protected void parseOptionalSemicolon() {
    }

    protected void parseMediumList() {
        PsiBuilder.Marker mediumListMarker = this.mark();
        this.parseMediaQuery();
        while ((this.mediumListAllowLineBreaks() || !this.isNewLine()) && this.getTokenType() == CssElementTypes.CSS_COMMA) {
            this.advance();
            if ((this.mediumListAllowLineBreaks() || !this.isNewLine()) && this.parseMediaQuery()) continue;
            this.error(CssBundle.message("parsing.error.media.query.expected", new Object[0]));
            break;
        }
        this.done(mediumListMarker, CssElementTypes.CSS_MEDIUM_LIST);
    }

    protected boolean mediumListAllowLineBreaks() {
        return false;
    }

    protected boolean parseMediaQueryTerm() {
        if (!this.isNewLine() && this.parseIdentOrInterpolation()) {
            this.parseInterpolationAfterIdent();
            return true;
        }
        return false;
    }

    private boolean parseMediaQuery() {
        boolean result = false;
        PsiBuilder.Marker mediaQuery = this.mark();
        PreprocessorTokenTypeProvider tokenTypeProvider = this.getTokenTypeProvider();
        if (this.currentTokenIn(new IElementType[]{tokenTypeProvider.getNotKeyword(), tokenTypeProvider.getOnlyKeyword()})) {
            this.advance();
        }
        if (this.parseMediaQueryTerm()) {
            if (!this.isNewLine() && this.currentTokenIn(this.getPossibleIdentifiers())) {
                if (this.currentTokenIn(new IElementType[]{tokenTypeProvider.getAndKeyword()})) {
                    this.advance();
                } else {
                    PsiBuilder.Marker error = this.mark();
                    this.advance();
                    error.error(CssBundle.message("parsing.error.and.expected", new Object[0]));
                }
                if (this.isNewLine() || !this.parseMediaExpressionList()) {
                    this.error(CssBundle.message("parsing.error.expression.list.expected", new Object[0]));
                    mediaQuery.done(CssElementTypes.CSS_MEDIA_QUERY);
                    return false;
                }
            }
            mediaQuery.done(CssElementTypes.CSS_MEDIA_QUERY);
            return true;
        }
        if (!this.isNewLine() && this.parseMediaExpressionList()) {
            result = true;
        }
        mediaQuery.done(CssElementTypes.CSS_MEDIA_QUERY);
        return result;
    }

    private boolean parseMediaExpressionList() {
        boolean result = false;
        PsiBuilder.Marker expressionList = this.mark();
        if (this.parseMediaExpression()) {
            while (!this.eof() && !this.isNewLine() && this.currentTokenIn(new IElementType[]{this.getTokenTypeProvider().getAndKeyword()})) {
                this.advance();
                if (!this.isNewLine() && this.parseMediaExpression()) continue;
                this.error(CssBundle.message("parsing.error.media.expression.expected", new Object[0]));
            }
            result = true;
        }
        expressionList.done(CssElementTypes.CSS_MEDIA_EXPRESSION_LIST);
        return result;
    }

    protected abstract boolean parseMediaExpression();

    protected abstract boolean isInterpolation();

    protected boolean parseUriStringOrIdentifier() {
        return this.parseUri() || this.parseExpression();
    }

    protected boolean parseTerm() {
        PsiBuilder.Marker marker = this.mark();
        if (this.parseUriStringOrIdentifier()) {
            this.done(marker, CssElementTypes.CSS_TERM);
            return true;
        }
        if (this.getTokenType() == CssElementTypes.CSS_LBRACKET) {
            this.advance();
            if (this.getTokenType() != CssElementTypes.CSS_RBRACKET) {
                this.parseTermList(true, CssElementTypes.CSS_RBRACKET);
            }
            if (this.getTokenType() == CssElementTypes.CSS_RBRACKET) {
                this.advance();
            } else {
                this.error(CssBundle.message("parsing.error.closing.bracket.expected", new Object[0]));
            }
            marker.done(CssElementTypes.CSS_BRACKETED_LIST);
            return true;
        }
        IndentPreprocessorParser.drop((PsiBuilder.Marker)marker);
        return false;
    }

    protected boolean parseIdSelector() {
        if (this.isIdSelectorStart()) {
            PsiBuilder.Marker cssClass = this.mark();
            this.advance();
            this.parseInterpolationAfterIdent();
            cssClass.done((IElementType)CssElementTypes.CSS_ID_SELECTOR);
            return true;
        }
        return false;
    }

    protected boolean isIdSelectorStart() {
        return this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_HASH});
    }

    protected boolean parseClass() {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_PERIOD})) {
            PsiBuilder.Marker cssClass = this.mark();
            this.advance();
            if (!this.isNewLine() && this.rawLookup(-1) == CssElementTypes.CSS_PERIOD) {
                this.parseIdentOrInterpolation();
                this.parseInterpolationAfterIdent();
            }
            cssClass.done((IElementType)CssElementTypes.CSS_CLASS);
            return true;
        }
        return false;
    }

    protected boolean parseSelectorSuffixList() {
        PsiBuilder.Marker selectorSuffixList;
        boolean result;
        block2: {
            PsiBuilder.Marker element;
            result = false;
            selectorSuffixList = this.mark();
            while (this.parseSelectorSuffix()) {
                result = true;
                if (!this.hasWhitespaceBefore() && !this.currentTokenIn(this.getWhitespaceTokenSet()) && !this.isNewLine() && !this.eof()) continue;
                break block2;
            }
            if (this.getTokenType() == TokenType.BAD_CHARACTER && (element = this.mark()) != null) {
                this.advance();
                element.error(CssBundle.message("parsing.error.unexpected.token", new Object[0]));
            }
        }
        selectorSuffixList.done(CssElementTypes.CSS_SELECTOR_SUFFIX_LIST);
        selectorSuffixList.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, null);
        return result;
    }

    protected boolean parseAttribute() {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LBRACKET})) {
            PsiBuilder.Marker attribute = this.mark();
            this.advance();
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_PIPE})) {
                this.advance();
            }
            if (!this.parseTagSimpleSelector()) {
                this.error(CssBundle.message("parsing.error.identifier.expected", new Object[0]));
            }
            this.parseAttributeRSide();
            if (!this.isNewLine() && this.currentTokenIn(this.getPossibleIdentifiers()) && "i".equals(this.getTokenText())) {
                this.advance();
            }
            if (this.isNewLine() || !this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_RBRACKET})) {
                this.error(CssBundle.message("parsing.error.closing.bracket.expected", new Object[0]));
            }
            this.advance();
            attribute.done((IElementType)CssElementTypes.CSS_ATTRIBUTE);
            return true;
        }
        return false;
    }

    protected boolean parseTermList(IElementType ... stopElements) {
        return this.parseTermList(true, stopElements);
    }

    protected boolean parseTermList(boolean strict, IElementType ... stopElements) {
        return this.parseTermList(strict, true, stopElements);
    }

    protected boolean parseTermList(boolean strict, boolean rollbackOnError, IElementType ... stopElements) {
        PsiBuilder.Marker termListMarker = this.mark(true);
        boolean result = this.parseTerm();
        if (result) {
            boolean wasComma = false;
            while (!this.isNewLine() || wasComma) {
                int offset = this.getCurrentOffset();
                wasComma = false;
                if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COMMA, CssElementTypes.CSS_SLASH}) && !this.currentTokenIn(stopElements)) {
                    wasComma = this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COMMA});
                    this.advance();
                } else if (this.currentTokenIn(stopElements) || !this.parseTerm()) {
                    if (this.currentTokenIn(stopElements) || this.isTermListFinished()) break;
                    if (strict) {
                        this.error(CssBundle.message("parsing.error.unexpected.term", new Object[0]));
                        while (!this.currentTokenIn(stopElements) && !this.isTermListFinished()) {
                            this.advance();
                        }
                        break;
                    }
                    if (rollbackOnError) {
                        this.rollbackTo(termListMarker);
                        return false;
                    }
                    this.advance();
                    result = false;
                    continue;
                }
                if (offset != this.getCurrentOffset()) continue;
                this.done(termListMarker, CssElementTypes.CSS_TERM_LIST);
                break;
            }
            this.done(termListMarker, CssElementTypes.CSS_TERM_LIST);
        } else {
            IndentPreprocessorParser.drop((PsiBuilder.Marker)termListMarker);
        }
        return result;
    }

    protected boolean isTermListFinished() {
        return this.isNewLine() || this.eof() || this.currentTokenIn(this.getComments()) || this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_RBRACE, CssElementTypes.CSS_RPAREN, CssElementTypes.CSS_IMPORTANT, CssElementTypes.CSS_RBRACKET});
    }

    protected boolean parsePseudoTermList() {
        PsiBuilder.Marker propertyValueMarker = this.mark();
        boolean result = this.parsePseudoTerm();
        if (result) {
            while (true) {
                if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COMMA, CssElementTypes.CSS_SLASH})) {
                    this.advance();
                    continue;
                }
                if (!this.parsePseudoTerm()) break;
            }
            if (!this.isTermListFinished()) {
                this.error(CssBundle.message("parsing.error.unexpected.term", new Object[0]));
                while (!this.isTermListFinished()) {
                    this.advance();
                }
            }
            this.done(propertyValueMarker, CssElementTypes.CSS_TERM_LIST);
        } else {
            IndentPreprocessorParser.drop((PsiBuilder.Marker)propertyValueMarker);
        }
        return result;
    }

    protected boolean parsePseudoTerm() {
        PsiBuilder.Marker marker = this.mark();
        if (this.parseClass() || this.parseIdSelector() || this.parsePseudo() || this.parseAttribute()) {
            this.done(marker, CssElementTypes.CSS_TERM);
            return true;
        }
        IndentPreprocessorParser.drop((PsiBuilder.Marker)marker);
        return this.parseTerm();
    }

    protected boolean parsePseudoFunction() {
        if (this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN && this.lookAhead(1) == CssElementTypes.CSS_LPAREN) {
            PsiBuilder.Marker functionInvocationMarker = this.mark();
            this.advance();
            this.expect(CssElementTypes.CSS_LPAREN, CssBundle.message("parsing.error.opening.parenthesis.expected", new Object[0]));
            if (this.isNewLine()) {
                this.error(CssBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
                this.done(functionInvocationMarker, CssElementTypes.CSS_FUNCTION);
                return false;
            }
            this.parsePseudoTermList();
            if (this.isNewLine()) {
                this.error(CssBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
                this.done(functionInvocationMarker, CssElementTypes.CSS_FUNCTION);
                return false;
            }
            this.parseRightParenthesis();
            this.done(functionInvocationMarker, CssElementTypes.CSS_FUNCTION);
            return true;
        }
        return false;
    }

    protected boolean parseRightParenthesis() {
        return this.expect(CssElementTypes.CSS_RPAREN, CssBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
    }

    protected boolean parsePseudo() {
        CssPseudoSelectorStubElementType pseudoType;
        if (this.getTokenType() != CssElementTypes.CSS_COLON) {
            return false;
        }
        PsiBuilder.Marker pseudo = this.mark();
        this.advance();
        if (!this.isNewLine() && this.getTokenType() == CssElementTypes.CSS_COLON) {
            this.advance();
            pseudoType = CssElementTypes.CSS_PSEUDO_ELEMENT;
        } else {
            pseudoType = CssElementTypes.CSS_PSEUDO_CLASS;
        }
        PsiBuilder.Marker possibleFunction = this.mark();
        if (!this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_FUNCTION_TOKEN})) {
            IndentPreprocessorParser.drop((PsiBuilder.Marker)possibleFunction);
            this.parsePseudoFunction();
        } else if (!this.isNewLine() && this.parseIdentOrInterpolation()) {
            this.parseInterpolationAfterIdent();
            if (!this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LPAREN})) {
                this.advance();
                if (this.isNewLine()) {
                    this.error(CssBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
                }
                this.parsePseudoTermList();
                if (this.isNewLine()) {
                    this.error(CssBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
                }
                this.parseRightParenthesis();
                this.done(possibleFunction, CssElementTypes.CSS_FUNCTION);
            } else {
                IndentPreprocessorParser.drop((PsiBuilder.Marker)possibleFunction);
            }
        } else {
            IndentPreprocessorParser.drop((PsiBuilder.Marker)possibleFunction);
            this.errorUntilEol(CssBundle.message("parsing.error.pseudo.element.or.pseudo.class.expected", new Object[0]));
        }
        pseudo.done((IElementType)pseudoType);
        return true;
    }

    protected boolean parseArgumentList() {
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            this.advance();
            if (this.getTokenType() != CssElementTypes.CSS_RPAREN) {
                PsiBuilder.Marker argumentError;
                PsiBuilder.Marker termListMarker = this.mark();
                if (!this.parseArgument()) {
                    argumentError = this.mark();
                    this.advanceUntil(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_COMMA, CssElementTypes.CSS_RPAREN}));
                    argumentError.error(CssBundle.message("parsing.error.invalid.argument", new Object[0]));
                }
                while (this.getTokenType() == CssElementTypes.CSS_COMMA) {
                    this.advance();
                    if (this.parseArgument() || this.isTrailingCommaInParamsAllowed() && this.getTokenType() == CssElementTypes.CSS_RPAREN) continue;
                    argumentError = this.mark();
                    this.advanceUntil(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_COMMA, CssElementTypes.CSS_RPAREN}));
                    argumentError.error(CssBundle.message("parsing.error.invalid.argument", new Object[0]));
                }
                this.done(termListMarker, CssElementTypes.CSS_TERM_LIST);
            }
            this.expect(CssElementTypes.CSS_RPAREN, CssBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
            return true;
        }
        return false;
    }

    protected boolean isTrailingCommaInParamsAllowed() {
        return false;
    }

    protected boolean parseParameterList() {
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            IElementType parameterListElementType;
            this.advance();
            PsiBuilder.Marker parameterList = this.mark();
            if (this.getTokenType() != CssElementTypes.CSS_RPAREN) {
                PsiBuilder.Marker parameterError;
                if (!this.parseParameter()) {
                    parameterError = this.mark();
                    this.advanceUntil(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_COMMA, CssElementTypes.CSS_RPAREN}));
                    parameterError.error(CssBundle.message("parsing.error.invalid.parameter", new Object[0]));
                }
                while (this.getTokenType() == CssElementTypes.CSS_COMMA) {
                    this.advance();
                    if (this.parseParameter() || this.isTrailingCommaInParamsAllowed() && this.getTokenType() == CssElementTypes.CSS_RPAREN) continue;
                    parameterError = this.mark();
                    this.advanceUntil(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_COMMA, CssElementTypes.CSS_RPAREN}));
                    parameterError.error(CssBundle.message("parsing.error.invalid.parameter", new Object[0]));
                }
            }
            if ((parameterListElementType = this.getParameterListElementType()) != null) {
                this.done(parameterList, parameterListElementType);
            } else {
                IndentPreprocessorParser.drop((PsiBuilder.Marker)parameterList);
            }
            this.expect(CssElementTypes.CSS_RPAREN, CssBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
            return true;
        }
        return false;
    }

    @Nullable
    protected IElementType getParameterListElementType() {
        return null;
    }

    protected boolean parseFontFace() {
        return this.parseSimpleAtRule(CssElementTypes.CSS_FONTFACE_SYM, CssElementTypes.CSS_FONTFACE);
    }

    protected boolean parseSimpleAtRule(@NotNull IElementType atRuleSym, @NotNull IElementType resultElementType) {
        if (atRuleSym == null) {
            IndentPreprocessorParser.$$$reportNull$$$0(0);
        }
        if (resultElementType == null) {
            IndentPreprocessorParser.$$$reportNull$$$0(1);
        }
        if (this.getTokenType() == atRuleSym) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            this.expectEolOrEof();
            this.parseDeclarationBlock(indent);
            marker.done(resultElementType);
            return true;
        }
        return false;
    }

    protected boolean parseKeyframesRuleset(int parentIndent) {
        PsiBuilder.Marker ruleset = this.mark();
        int rulesetIndent = this.getCurrentIndent();
        if (!this.eof() && this.isNewLine() && rulesetIndent > parentIndent && this.parseKeyframesSelectorList()) {
            if (!this.eof() && this.isDeclarationBlock()) {
                this.parseDeclarationBlock(rulesetIndent);
            } else {
                this.errorUntilEol(CssBundle.message("parsing.error.unexpected.token", new Object[0]));
            }
            ruleset.done((IElementType)CssElementTypes.CSS_RULESET);
            return true;
        }
        ruleset.drop();
        return false;
    }

    protected boolean isDeclarationBlock() {
        return this.isNewLine();
    }

    @Contract(mutates="this")
    protected boolean parseKeyframesSelectorList() {
        PsiBuilder.Marker selectorList = this.mark();
        boolean result = this.parseKeyframesSelector();
        while (!this.eof() && !this.isNewLine() && this.getTokenType() == CssElementTypes.CSS_COMMA) {
            this.advance();
            if (this.eof() || this.parseKeyframesSelector()) continue;
            this.error(CssBundle.message("parsing.error.keyframes.selector.expected", new Object[0]));
            break;
        }
        if (result) {
            selectorList.done((IElementType)CssElementTypes.CSS_SELECTOR_LIST);
            return true;
        }
        selectorList.drop();
        return false;
    }

    private boolean parseKeyframesSelector() {
        PsiBuilder.Marker selector = this.mark();
        PsiBuilder.Marker simpleSelector = this.mark();
        if (this.getTokenType() == CssElementTypes.CSS_NUMBER) {
            this.advance();
            this.expect(CssElementTypes.CSS_PERCENT, "'%'");
        } else if (this.parseIdent()) {
            this.parseInterpolationAfterIdent();
        } else {
            simpleSelector.drop();
            selector.drop();
            return false;
        }
        simpleSelector.done(CssElementTypes.CSS_KEYFRAMES_SELECTOR);
        selector.done((IElementType)CssElementTypes.CSS_SELECTOR);
        return true;
    }

    protected boolean parseNamespace() {
        if (!this.isNewLine() || this.getTokenType() != CssElementTypes.CSS_NAMESPACE_SYM) {
            return false;
        }
        PsiBuilder.Marker namespace = this.mark();
        this.advance();
        this.parseIdent();
        if (!this.parseUriStringOrIdentifier()) {
            this.error(CssBundle.message("parsing.error.url.or.string.expected", new Object[0]));
        }
        namespace.done(CssElementTypes.CSS_NAMESPACE);
        return true;
    }

    protected boolean parseViewPort() {
        return this.parseSimpleAtRule(CssElementTypes.CSS_VIEWPORT_SYM, CssElementTypes.CSS_VIEWPORT);
    }

    protected boolean parsePageMarginRules() {
        return this.parseSimpleAtRule(CssElementTypes.CSS_PAGE_MARGIN_SYM, CssElementTypes.CSS_PAGE_MARGIN_RULE);
    }

    protected boolean parseCounterStyle() {
        if (this.getTokenType() == CssElementTypes.CSS_COUNTER_STYLE_SYM) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker counterStyle = this.mark();
            this.advance();
            if (this.isNewLine() || !this.parseIdent()) {
                this.errorUntilEol(CssBundle.message("parsing.error.counter.style.name.expected", new Object[0]));
            }
            this.expectEolOrEof();
            this.parseDeclarationBlock(indent);
            counterStyle.done(CssElementTypes.CSS_COUNTER_STYLE_RULE);
            return true;
        }
        return false;
    }

    protected boolean parsePage() {
        if (this.getTokenType() == CssElementTypes.CSS_PAGE_SYM) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker page = this.mark();
            this.advance();
            this.parsePageSelectors();
            this.expectEolOrEof();
            this.parseDeclarationBlock(indent);
            page.done(CssElementTypes.CSS_PAGE);
            return true;
        }
        return false;
    }

    protected void parsePageSelectors() {
        if (!this.isNewLine() && this.parsePageSelector()) {
            while (this.getTokenType() == CssElementTypes.CSS_COMMA) {
                this.advance();
                if (this.parsePageSelector()) continue;
                this.error(CssBundle.message("parsing.error.page.selector.expected", new Object[0]));
            }
        }
    }

    protected boolean parsePageSelector() {
        boolean result = false;
        if (this.parseIdentOrInterpolation()) {
            this.parseInterpolationAfterIdent();
            result = true;
        }
        while (!(this.isNewLine() || result && this.hasWhitespaceBefore() || this.getTokenType() != CssElementTypes.CSS_COLON)) {
            PsiBuilder.Marker pseudoPage = this.mark();
            this.advance();
            if (!this.hasWhitespaceBefore() && this.parseIdent()) {
                result = true;
            } else {
                this.errorUntilEol(CssBundle.message("parsing.error.identifier.expected", new Object[0]));
            }
            pseudoPage.done((IElementType)CssElementTypes.CSS_PSEUDO_PAGE);
        }
        return result;
    }

    protected boolean parseRegion() {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_REGION_SYM})) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            if (!this.isNewLine()) {
                this.parseSelector();
            } else {
                this.errorUntilEol(CssBundle.message("parsing.error.region.selector.expected", new Object[0]));
            }
            this.parseDeclarationBlock(indent);
            marker.done(CssElementTypes.CSS_REGION_RULE);
            return true;
        }
        return false;
    }

    protected boolean parseScopeRule() {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_SCOPE_SYM})) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            if (!this.isNewLine()) {
                this.parseSelectorList(indent);
            } else {
                this.errorUntilEol(CssBundle.message("parsing.error.region.selector.expected", new Object[0]));
            }
            this.parseDeclarationBlock(indent);
            marker.done(CssElementTypes.CSS_SCOPE_RULE);
            return true;
        }
        return false;
    }

    protected boolean parseDocument() {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_DOCUMENT_SYM})) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            if (this.isNewLine()) {
                this.errorUntilEol(CssBundle.message("parsing.error.function.expected", new Object[0]));
            }
            IElementType lastToken = null;
            while (!this.eof() && (this.getCurrentIndent() <= indent || this.getTokenType() != null && this.isNewLine() && lastToken == CssElementTypes.CSS_COMMA)) {
                IElementType type;
                if (this.isNewLine()) {
                    type = this.getTokenType();
                    lastToken = this.getWhitespaceTokenSet().contains(type) ? lastToken : type;
                    this.advance();
                }
                while (!this.isNewLine() && !this.eof()) {
                    type = this.getTokenType();
                    lastToken = this.getWhitespaceTokenSet().contains(type) ? lastToken : type;
                    this.advance();
                }
            }
            this.parseDeclarationBlock(indent);
            marker.done(CssElementTypes.CSS_DOCUMENT_RULE);
            return true;
        }
        return false;
    }

    protected boolean parseCssExpression() {
        if (this.getTokenType() != CssElementTypes.CSS_EXPRESSION) {
            return false;
        }
        PsiBuilder.Marker expression = this.mark();
        this.advance();
        this.expect(CssElementTypes.CSS_LPAREN, CssBundle.message("parsing.error.opening.parenthesis.expected", new Object[0]));
        PsiBuilder.Marker expressionParameter = this.mark();
        this.parseExpressionTokenList();
        expressionParameter.done(CssElementTypes.CSS_EXPRESSION_PARAMETER);
        this.parseRightParenthesis();
        expression.done(CssElementTypes.CSS_EXPRESSION);
        return true;
    }

    private void parseExpressionTokenList() {
        int openedParentheses = 0;
        while (this.getTokenType() != null) {
            if (this.isNewLine()) {
                if (openedParentheses > 0) {
                    this.error(CssBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
                }
                return;
            }
            IElementType type = this.getTokenType();
            if (CssParser2.isCssExpressionType(type)) {
                this.advance();
                continue;
            }
            if (this.parseIdentOrInterpolation()) {
                this.parseInterpolationAfterIdent();
                continue;
            }
            type = this.getTokenType();
            if (type == CssElementTypes.CSS_LPAREN) {
                ++openedParentheses;
                this.advance();
                continue;
            }
            if (type == CssElementTypes.CSS_RPAREN) {
                if (openedParentheses == 0) break;
                if (openedParentheses <= 0) continue;
                --openedParentheses;
                this.advance();
                continue;
            }
            this.advance();
        }
    }

    protected boolean parseCharset() {
        if (this.getTokenType() != CssElementTypes.CSS_CHARSET_SYM) {
            return false;
        }
        PsiBuilder.Marker charset = this.mark();
        this.advance();
        this.parseString(true);
        while (!this.eof() && !this.isNewLine()) {
            this.error(CssBundle.message("parsing.error.end.of.line.expected", new Object[0]));
            this.advance();
        }
        this.done(charset, CssElementTypes.CSS_CHARSET);
        return true;
    }

    protected boolean parseImportSupportsCondition() {
        if (CssParser2.isSupportsClause(this.getTokenType(), this.getTokenText()) && this.rawLookup(1) == CssElementTypes.CSS_LPAREN) {
            PsiBuilder.Marker supports = this.mark();
            this.advance();
            this.advance();
            if (!this.isNewLine() && (this.parseSupportsCondition() || this.parseDeclaration())) {
                if (this.isNewLine() || !this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_RPAREN})) {
                    this.error(CssBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
                } else {
                    this.advance();
                }
            } else {
                this.errorUntilEol(CssBundle.message("parsing.error.supports.condition.or.declaration.expected", new Object[0]));
            }
            this.done(supports, CssElementTypes.CSS_SUPPORTS);
            return true;
        }
        return false;
    }

    protected boolean parseSupports() {
        if (this.getTokenType() == CssElementTypes.CSS_SUPPORTS_SYM) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker supports = this.mark();
            this.advance();
            if (!this.parseSupportsTopLevelCondition()) {
                this.errorUntilEol(CssBundle.message("parsing.error.supports.condition.expected", new Object[0]));
            }
            this.parseDeclarationBlock(indent);
            this.done(supports, CssElementTypes.CSS_SUPPORTS);
            return true;
        }
        return false;
    }

    protected boolean parseFontPaletteValues() {
        if (this.getTokenType() != CssElementTypes.CSS_FONT_PALETTE_VALUES_SYM) {
            return false;
        }
        int indent = this.getCurrentIndent();
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        if (!this.parseIdent()) {
            this.error(CssBundle.message("parsing.error.identifier.expected", new Object[0]));
        }
        if (!this.isNewLine()) {
            this.errorUntilEol(CoreBundle.message((String)"parsing.error.end.of.line.expected", (Object[])new Object[0]));
        }
        this.parseDeclarationBlock(indent);
        marker.done(CssElementTypes.CSS_FONT_PALETTE_VALUES);
        return true;
    }

    protected boolean parseSupportsTopLevelCondition() {
        return this.parseSupportsCondition();
    }

    private boolean parseSupportsCondition() {
        PsiBuilder.Marker conditionList = this.mark(true);
        PsiBuilder.Marker condition = this.mark();
        if (this.parseSupportsNegation()) {
            this.done(condition, CssElementTypes.CSS_SUPPORTS_CONDITION);
            IndentPreprocessorParser.drop((PsiBuilder.Marker)conditionList);
            return true;
        }
        if (this.parseSupportsConditionsInParens()) {
            if (this.currentTokenIn(this.getPossibleIdentifiers()) || this.currentTokenIn(new IElementType[]{this.getTokenTypeProvider().getAndKeyword(), this.getTokenTypeProvider().getOrKeyword()})) {
                IElementType listType;
                if (this.currentTokenIn(new IElementType[]{this.getTokenTypeProvider().getAndKeyword()})) {
                    listType = CssElementTypes.CSS_SUPPORTS_CONDITION_AND_LIST;
                    this.parseSupportsMultiConditions(this.getTokenTypeProvider().getAndKeyword(), CssBundle.message("parsing.error.and.expected", new Object[0]));
                } else if (this.currentTokenIn(new IElementType[]{this.getTokenTypeProvider().getOrKeyword()})) {
                    listType = CssElementTypes.CSS_SUPPORTS_CONDITION_OR_LIST;
                    this.parseSupportsMultiConditions(this.getTokenTypeProvider().getOrKeyword(), CssBundle.message("parsing.error.or.expected", new Object[0]));
                } else {
                    listType = CssElementTypes.CSS_SUPPORTS_CONDITION_UNKNOWN_LIST;
                    this.parseSupportsMultiConditions(null, CssBundle.message("parsing.error.and.or.or.expected", new Object[0]));
                }
                IndentPreprocessorParser.drop((PsiBuilder.Marker)condition);
                this.done(conditionList, listType);
            } else {
                this.done(condition, CssElementTypes.CSS_SUPPORTS_CONDITION);
                IndentPreprocessorParser.drop((PsiBuilder.Marker)conditionList);
            }
            return true;
        }
        this.rollbackTo(conditionList);
        return false;
    }

    private void parseSupportsMultiConditions(@Nullable IElementType expectedElementType, @NotNull @NlsContexts.ParsingError String errorMessage) {
        if (errorMessage == null) {
            IndentPreprocessorParser.$$$reportNull$$$0(2);
        }
        while (this.currentTokenIn(new IElementType[]{this.getTokenTypeProvider().getIdentifier()}) && !this.isNewLine() || this.currentTokenIn(new IElementType[]{this.getTokenTypeProvider().getOrKeyword(), this.getTokenTypeProvider().getAndKeyword()})) {
            if (!this.currentTokenIn(new IElementType[]{expectedElementType})) {
                PsiBuilder.Marker error = this.mark();
                this.advance();
                error.error(errorMessage);
            } else {
                this.advance();
            }
            if (this.parseSupportsConditionsInParens()) continue;
            this.errorUntilEol(CssBundle.message("parsing.error.supports.condition.expected", new Object[0]));
            break;
        }
    }

    private boolean parseSupportsNegation() {
        if (this.currentTokenIn(new IElementType[]{this.getTokenTypeProvider().getNotKeyword()})) {
            this.advance();
            if (!this.parseSupportsConditionsInParens()) {
                this.errorUntilEol(CssBundle.message("parsing.error.supports.condition.expected", new Object[0]));
            }
            return true;
        }
        return false;
    }

    private boolean parseSupportsConditionsInParens() {
        if (this.parseSupportsFunction()) {
            return true;
        }
        if (this.parseSupportsGeneralEnclosed()) {
            return true;
        }
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            this.advance();
            if (!this.parseSupportsCondition() && !this.parseDeclaration()) {
                this.errorUntil(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_RPAREN}), CssBundle.message("parsing.error.supports.condition.expected", new Object[0]));
            }
            this.parseRightParenthesis();
            return true;
        }
        return false;
    }

    protected boolean parseSupportsFunction() {
        if (this.getTokenType() != CssElementTypes.CSS_FUNCTION_TOKEN) {
            return false;
        }
        String functionName = this.getTokenText();
        PsiBuilder.Marker function = this.mark();
        this.advance();
        this.advance();
        if ("selector".equals(functionName) && this.getTokenType() != CssElementTypes.CSS_RPAREN) {
            this.parseSelectorList(this.getCurrentIndent(), false, false);
            if (this.getTokenType() != CssElementTypes.CSS_RPAREN) {
                this.error(CssBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
                this.advanceUntil(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_RPAREN}));
            }
        } else {
            this.advanceUntil(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_RPAREN}));
        }
        this.expect(CssElementTypes.CSS_RPAREN, CssBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
        function.done(CssElementTypes.CSS_FUNCTION);
        return true;
    }

    private boolean parseSupportsGeneralEnclosed() {
        IElementType initialToken = this.getTokenType();
        if (initialToken == CssElementTypes.CSS_FUNCTION_TOKEN || initialToken == CssElementTypes.CSS_LPAREN) {
            PsiBuilder.Marker markerToRollback = this.mark(true);
            this.advance();
            String tokenText = this.getTokenText();
            if (this.currentTokenIn(new IElementType[]{this.getTokenTypeProvider().getIdentifier()}) && ("any".equalsIgnoreCase(tokenText) || "unused".equalsIgnoreCase(tokenText))) {
                this.advance();
                this.parseRightParenthesis();
                IndentPreprocessorParser.drop((PsiBuilder.Marker)markerToRollback);
                return true;
            }
            this.rollbackTo(markerToRollback);
        }
        return false;
    }

    public boolean hasWhitespaceBefore() {
        return this.getWhitespaceTokenSet().contains(this.rawLookup(-1));
    }

    protected abstract boolean parseDeclaration();

    protected abstract boolean parseParameter();

    protected abstract boolean parseArgument();

    protected abstract boolean parseSelectorSuffix();

    protected abstract void parseDeclarationBlock(int var1);

    protected TokenSet getPossibleIdentifiers() {
        return TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_IDENT});
    }

    public abstract boolean parseInterpolation();

    public abstract boolean parseInterpolationAfterIdent();

    protected abstract IElementType getInterpolationPrefixToken();

    protected abstract IElementType getInterpolationSuffixToken();

    protected abstract TokenSet getWhitespaceTokenSet();

    protected abstract IElementType getMultiplyToken();

    protected abstract List<IElementType> getSelectorPrefixTokenTypes();

    protected abstract boolean parseExpression();

    protected abstract TokenSet getComments();

    protected abstract boolean ruleCouldContainBraces();

    protected abstract PreprocessorTokenTypeProvider getTokenTypeProvider();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "atRuleSym";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultElementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/impl/parsing/IndentPreprocessorParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSimpleAtRule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSupportsMultiConditions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

