/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.actions.CssBaseElementAtCaretIntentionAction;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CssReplaceQuotesIntention
extends CssBaseElementAtCaretIntentionAction {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        CssString string;
        if (project == null) {
            CssReplaceQuotesIntention.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CssReplaceQuotesIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            CssReplaceQuotesIntention.$$$reportNull$$$0(2);
        }
        if ((string = (CssString)PsiTreeUtil.getParentOfType((PsiElement)element, CssString.class)) != null) {
            String elementText = string.getText();
            int SINGLE_QUOTE = 39;
            int DOUBLE_QUOTE = 34;
            char quoteChar = StringUtil.startsWithChar((CharSequence)elementText, (char)'\"') ? (char)'\'' : '\"';
            char oldQuoteChar = quoteChar == '\'' ? (char)'\"' : '\'';
            String newStringValue = StringUtil.unquoteString((String)elementText);
            if (newStringValue.contains("\\" + oldQuoteChar)) {
                newStringValue = newStringValue.replace("\\" + oldQuoteChar, String.valueOf(oldQuoteChar));
            }
            newStringValue = newStringValue.replace(String.valueOf(quoteChar), "\\" + quoteChar);
            CssString newString = CssElementFactory.getInstance(project).createString(quoteChar, newStringValue, CssPsiUtil.getStylesheetLanguage(element));
            if (string.isPhysical()) {
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{element.getContainingFile()}).run(() -> string.replace(newString));
            } else {
                string.replace(newString);
            }
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            CssReplaceQuotesIntention.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            CssReplaceQuotesIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            CssReplaceQuotesIntention.$$$reportNull$$$0(5);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        CssString string = (CssString)PsiTreeUtil.getParentOfType((PsiElement)element, CssString.class);
        return string != null && StringUtil.isQuotedString((String)string.getText()) && PsiTreeUtil.getParentOfType((PsiElement)element, CssCharset.class) == null && PsiTreeUtil.getParentOfType((PsiElement)element, CssStylesheet.class) != null;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message("css.intentions.replace.quotes", new Object[0]);
        if (string == null) {
            CssReplaceQuotesIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = CssBundle.message("css.intentions.replace.quotes", new Object[0]);
        if (string == null) {
            CssReplaceQuotesIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/CssReplaceQuotesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/CssReplaceQuotesIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

