/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssExtractRulesetIntentionAction
extends BaseIntentionAction {
    public CssExtractRulesetIntentionAction() {
        this.setText(CssBundle.message("action.text.extract.ruleset", new Object[0]));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            CssExtractRulesetIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CssExtractRulesetIntentionAction.$$$reportNull$$$0(1);
        }
        return editor != null && file != null && !CssExtractRulesetIntentionAction.getElementsToMove(editor, file).isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        List<PsiElement> toMove;
        if (project == null) {
            CssExtractRulesetIntentionAction.$$$reportNull$$$0(2);
        }
        if ((toMove = CssExtractRulesetIntentionAction.getElementsToMove(editor, file)).isEmpty()) {
            return;
        }
        PsiElement firstElementOrig = toMove.get(0);
        PsiElement lastElementOrig = toMove.get(toMove.size() - 1);
        CssRuleset newRuleset = CssExtractRulesetIntentionAction.createRulesetCopyLeavingOnlyRequiredChildren(firstElementOrig, lastElementOrig);
        CssRuleset rulesetOrig = (CssRuleset)firstElementOrig.getParent().getParent();
        PsiElement addedRuleset = rulesetOrig.getParent().addAfter((PsiElement)newRuleset, (PsiElement)rulesetOrig);
        for (PsiElement each : toMove) {
            if (!each.isValid()) continue;
            each.delete();
        }
        SmartPsiElementPointer addedRulesetPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(addedRuleset);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        addedRuleset = addedRulesetPointer.getElement();
        if (addedRuleset instanceof CssRuleset && addedRuleset.getContainingFile().isPhysical()) {
            ((CssRuleset)addedRuleset).navigate(true);
            CssSelectorList selectorList = ((CssRuleset)addedRuleset).getSelectorList();
            if (selectorList != null) {
                editor.getSelectionModel().setSelection(selectorList.getTextRange().getStartOffset(), selectorList.getTextRange().getEndOffset());
            }
        }
    }

    @NotNull
    private static CssRuleset createRulesetCopyLeavingOnlyRequiredChildren(PsiElement firstElementOrig, PsiElement lastElementOrig) {
        PsiParserFacade parserFacade;
        CssRuleset rulesetOrig = (CssRuleset)firstElementOrig.getParent().getParent();
        TextRange firstElementRange = firstElementOrig.getTextRange().shiftRight(-rulesetOrig.getTextRange().getStartOffset());
        TextRange lastElementRange = lastElementOrig.getTextRange().shiftRight(-rulesetOrig.getTextRange().getStartOffset());
        CssRuleset newRuleset = (CssRuleset)rulesetOrig.copy();
        CssBlock newBlock = newRuleset.getBlock();
        assert (newBlock != null);
        PsiElement lBrace = newBlock.getLBrace();
        PsiElement rBrace = newBlock.getRBrace();
        boolean lBracePassed = lBrace == null;
        boolean firstElementPassed = false;
        boolean lastElementPassed = false;
        PsiElement firstElementInFirstGroupToDelete = null;
        PsiElement lastElementInFirstGroupToDelete = null;
        PsiElement firstElementInSecondGroupToDelete = null;
        PsiElement lastElementInSecondGroupToDelete = null;
        for (PsiElement e = newBlock.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (!lBracePassed) {
                if (e != lBrace) continue;
                lBracePassed = true;
                continue;
            }
            if (!firstElementPassed) {
                if (e.getTextRange().equals((Object)firstElementRange)) {
                    firstElementPassed = true;
                    if (!firstElementRange.equals((Object)lastElementRange)) continue;
                    lastElementPassed = true;
                    continue;
                }
                if (firstElementInFirstGroupToDelete == null) {
                    firstElementInFirstGroupToDelete = e;
                }
                lastElementInFirstGroupToDelete = e;
                continue;
            }
            if (!lastElementPassed) {
                if (!e.getTextRange().equals((Object)lastElementRange)) continue;
                lastElementPassed = true;
                continue;
            }
            if (e == rBrace) break;
            if (firstElementInSecondGroupToDelete == null) {
                firstElementInSecondGroupToDelete = e;
            }
            lastElementInSecondGroupToDelete = e;
        }
        if (firstElementInFirstGroupToDelete != null) {
            if (CssPsiUtil.isIndentBasedCssLanguage(firstElementInFirstGroupToDelete) && firstElementInFirstGroupToDelete instanceof PsiWhiteSpace && firstElementInFirstGroupToDelete != lastElementInFirstGroupToDelete) {
                firstElementInFirstGroupToDelete = firstElementInFirstGroupToDelete.getNextSibling();
            }
            firstElementInFirstGroupToDelete.getParent().deleteChildRange(firstElementInFirstGroupToDelete, lastElementInFirstGroupToDelete);
        }
        if (firstElementInSecondGroupToDelete != null) {
            firstElementInSecondGroupToDelete.getParent().deleteChildRange(firstElementInSecondGroupToDelete, lastElementInSecondGroupToDelete);
        }
        if (lBrace != null && firstElementOrig.getPrevSibling() instanceof PsiWhiteSpace && firstElementOrig.getPrevSibling().textContains('\n')) {
            parserFacade = PsiParserFacade.getInstance((Project)firstElementOrig.getProject());
            lBrace.getParent().addAfter(parserFacade.createWhiteSpaceFromText("\n"), lBrace);
        }
        if (rBrace != null && lastElementOrig.getNextSibling() instanceof PsiWhiteSpace && lastElementOrig.getNextSibling().textContains('\n')) {
            parserFacade = PsiParserFacade.getInstance((Project)firstElementOrig.getProject());
            rBrace.getParent().addBefore(parserFacade.createWhiteSpaceFromText("\n"), rBrace);
        }
        CssRuleset cssRuleset = newRuleset;
        if (cssRuleset == null) {
            CssExtractRulesetIntentionAction.$$$reportNull$$$0(3);
        }
        return cssRuleset;
    }

    @NotNull
    private static List<PsiElement> getElementsToMove(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            CssExtractRulesetIntentionAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            CssExtractRulesetIntentionAction.$$$reportNull$$$0(5);
        }
        if (!(file instanceof StylesheetFile) && !CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)file)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                CssExtractRulesetIntentionAction.$$$reportNull$$$0(6);
            }
            return list;
        }
        TextRange rangeInHost = InjectedLanguageManager.getInstance((Project)file.getProject()).injectedToHost((PsiElement)file, file.getTextRange());
        if (rangeInHost.getLength() != file.getTextLength()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                CssExtractRulesetIntentionAction.$$$reportNull$$$0(7);
            }
            return list;
        }
        int selectionStart = editor.getSelectionModel().getSelectionStart();
        int selectionEnd = editor.getSelectionModel().getSelectionEnd();
        PsiElement startElement = file.findElementAt(selectionStart);
        if (selectionStart == selectionEnd) {
            CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)startElement, CssDeclaration.class);
            if (declaration != null && declaration.getParent() instanceof CssBlock && declaration.getParent().getParent() instanceof CssRuleset) {
                return CssExtractRulesetIntentionAction.addRequiredSpaceAndSemicolonAndReturnAllSiblingElementsToMove(declaration, declaration);
            }
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                CssExtractRulesetIntentionAction.$$$reportNull$$$0(8);
            }
            return list;
        }
        PsiElement element1 = CssExtractRulesetIntentionAction.getCssBlockImmediateChild(startElement);
        if (element1 == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                CssExtractRulesetIntentionAction.$$$reportNull$$$0(9);
            }
            return list;
        }
        PsiElement endElement = file.findElementAt(selectionEnd);
        PsiElement element2 = CssExtractRulesetIntentionAction.getCssBlockImmediateChild(endElement);
        if (element2 == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                CssExtractRulesetIntentionAction.$$$reportNull$$$0(10);
            }
            return list;
        }
        if (element1.getParent() != element2.getParent()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                CssExtractRulesetIntentionAction.$$$reportNull$$$0(11);
            }
            return list;
        }
        if (!(element1.getParent().getParent() instanceof CssRuleset)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                CssExtractRulesetIntentionAction.$$$reportNull$$$0(12);
            }
            return list;
        }
        while (element1 instanceof PsiWhiteSpace || element1 instanceof CssTokenImpl) {
            element1 = element1.getNextSibling();
        }
        while (element2 instanceof PsiWhiteSpace || element2 instanceof CssTokenImpl) {
            element2 = element2.getPrevSibling();
        }
        if (element1 == null || element2 == null || element1.getTextRange().getStartOffset() > element2.getTextRange().getStartOffset()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                CssExtractRulesetIntentionAction.$$$reportNull$$$0(13);
            }
            return list;
        }
        return CssExtractRulesetIntentionAction.addRequiredSpaceAndSemicolonAndReturnAllSiblingElementsToMove(element1, element2);
    }

    @Nullable
    private static PsiElement getCssBlockImmediateChild(@Nullable PsiElement element) {
        while (element != null) {
            if (element instanceof PsiFile) {
                return null;
            }
            if (element.getParent() instanceof CssBlock) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    @NotNull
    private static List<PsiElement> addRequiredSpaceAndSemicolonAndReturnAllSiblingElementsToMove(@NotNull PsiElement fromElement, @NotNull PsiElement toElement) {
        PsiElement nextSibling;
        PsiElement prevSibling;
        if (fromElement == null) {
            CssExtractRulesetIntentionAction.$$$reportNull$$$0(14);
        }
        if (toElement == null) {
            CssExtractRulesetIntentionAction.$$$reportNull$$$0(15);
        }
        if ((prevSibling = fromElement.getPrevSibling()) instanceof PsiWhiteSpace && !prevSibling.textContains('\n')) {
            fromElement = prevSibling;
        }
        if ((nextSibling = toElement.getNextSibling()) instanceof PsiWhiteSpace) {
            nextSibling = nextSibling.getNextSibling();
        }
        if (nextSibling instanceof CssTokenImpl && nextSibling.getNode().getElementType() == CssElementTypes.CSS_SEMICOLON) {
            toElement = nextSibling;
        }
        SmartList result = new SmartList((Object)fromElement);
        for (PsiElement element = fromElement; element != toElement; element = element.getNextSibling()) {
            result.add(element);
        }
        SmartList smartList = result;
        if (smartList == null) {
            CssExtractRulesetIntentionAction.$$$reportNull$$$0(16);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/CssExtractRulesetIntentionAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/CssExtractRulesetIntentionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRulesetCopyLeavingOnlyRequiredChildren";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToMove";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addRequiredSpaceAndSemicolonAndReturnAllSiblingElementsToMove";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToMove";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addRequiredSpaceAndSemicolonAndReturnAllSiblingElementsToMove";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 14, 15 -> new IllegalArgumentException(string);
        };
    }
}

