/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssExpression;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CssLanguageInjector
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            CssLanguageInjector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CssLanguageInjector.$$$reportNull$$$0(1);
        }
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)context;
        PsiElement attribute = host.getParent();
        PsiElement tag = attribute.getParent();
        if (attribute instanceof XmlAttribute && tag instanceof XmlTag) {
            String namespace;
            boolean qualified;
            @NonNls String attrName = ((XmlAttribute)attribute).getName();
            if (tag instanceof HtmlTag) {
                attrName = StringUtil.toLowerCase((String)attrName);
            }
            boolean bl = qualified = !((XmlTag)tag).getNamespacePrefix().isEmpty();
            if (("style".equals(attrName) || "errorStyle".equals(attrName) || "infoStyle".equals(attrName) || "warnStyle".equals(attrName) || "fatalStyle".equals(attrName)) && qualified) {
                namespace = ((XmlTag)tag).getNamespace();
                if (Arrays.asList(XmlUtil.JSF_HTML_URIS).contains(namespace) || "http://struts.apache.org/tags-html".equals(namespace)) {
                    CssLanguageInjector.addInlineInjector(host, registrar);
                }
            } else if ("cssStyle".equals(attrName) && qualified) {
                namespace = ((XmlTag)tag).getNamespace();
                if ("http://www.springframework.org/tags/form".equals(namespace)) {
                    CssLanguageInjector.addInlineInjector(host, registrar);
                }
            } else if ("inlineStyle".equals(attrName) && qualified && ("http://myfaces.apache.org/trinidad".equals(namespace = ((XmlTag)tag).getNamespace()) || "http://myfaces.apache.org/trinidad/html".equals(namespace))) {
                CssLanguageInjector.addInlineInjector(host, registrar);
            }
        }
        Language jsLanguage = Language.findLanguageByID((String)"JavaScript");
        if (host instanceof CssExpression && jsLanguage != null && PsiTreeUtil.getParentOfType((PsiElement)host, CssDeclaration.class) != null) {
            String text = host.getText();
            String marker = "expression(";
            int offset = text.lastIndexOf(41);
            registrar.startInjecting(jsLanguage).addPlace("function expression() {\n", "\n}", host, new TextRange(marker.length(), offset != -1 ? offset : text.length())).doneInjecting();
        }
    }

    public static void addInlineInjector(PsiLanguageInjectionHost host, MultiHostRegistrar registrar) {
        PsiElement[] elements;
        int length = host.getTextLength();
        if (length < 2) {
            return;
        }
        if (host instanceof XmlAttributeValue && ((elements = host.getChildren()).length > 3 || elements.length == 3 && elements[1] instanceof OuterLanguageElement)) {
            return;
        }
        registrar.startInjecting(CssFileType.INSTANCE.getLanguage()).addPlace("inline.style {", "}", host, new TextRange(1, length - 1)).doneInjecting();
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlAttributeValue.class, CssExpression.class);
        if (list == null) {
            CssLanguageInjector.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/CssLanguageInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/CssLanguageInjector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

