/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssMedia;
import com.intellij.psi.css.impl.CssStubElementTypes;
import org.jetbrains.annotations.Nullable;

public class CssCharFilter
extends CharFilter {
    @Nullable
    public CharFilter.Result acceptChar(char c, int prefixLength, Lookup lookup) {
        PsiElement element;
        CompletionProcess currentCompletion;
        if (!lookup.isCompletion()) {
            return null;
        }
        PsiFile psiFile = lookup.getPsiFile();
        if (psiFile != null && !psiFile.getLanguage().isKindOf((Language)CSSLanguage.INSTANCE)) {
            return null;
        }
        if (Character.isJavaIdentifierPart(c) || c == '-') {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        LookupElement item = lookup.getCurrentItem();
        if (c == ':' && item != null && (currentCompletion = CompletionService.getCompletionService().getCurrentCompletion()) != null && currentCompletion.isAutopopupCompletion()) {
            return CharFilter.Result.HIDE_LOOKUP;
        }
        if (c == '(' && (element = lookup.getPsiElement()) != null) {
            if (element.getParent() instanceof CssMedia) {
                return CharFilter.Result.HIDE_LOOKUP;
            }
            PsiElement prev = element.getPrevSibling();
            if (prev != null && prev.getNode().getElementType() == CssStubElementTypes.CSS_MEDIA) {
                return CharFilter.Result.HIDE_LOOKUP;
            }
        }
        return null;
    }
}

