/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectIntAssociativeContainer;
import com.carrotsearch.hppc.ObjectIntHashMap;
import com.carrotsearch.hppc.ObjectIntMap;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.comparators.ObjectIntComparator;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectIntCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.predicates.ObjectIntPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.procedures.ObjectIntProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationObjectIntHashMap<KType>
implements ObjectIntMap<KType> {
    public final ObjectIntHashMap<KType> delegate;
    public final int[] iterationOrder;

    public SortedIterationObjectIntHashMap(ObjectIntHashMap<KType> delegate, Comparator<KType> comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationObjectIntHashMap(ObjectIntHashMap<KType> delegate, ObjectIntComparator<KType> comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        Object[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry2 = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry2++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry2 < size) {
            if (keys[keyIndex] != null) {
                entryIndexes[entry2++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, Comparator<KType> comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            Object[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ObjectIntComparator<KType> comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final KType[] keys;
            final int[] values;
            {
                this.keys = SortedIterationObjectIntHashMap.this.delegate.keys;
                this.values = SortedIterationObjectIntHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ObjectIntCursor<KType>> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(KType key2) {
        return this.delegate.containsKey(key2);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> container) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectIntPredicate<? super KType> predicate) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public <T extends ObjectIntProcedure<? super KType>> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        int[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply((Object)keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectIntPredicate<? super KType>> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        int[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply((Object)keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ObjectCollection<KType> keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public IntContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public int get(KType key2) {
        return this.delegate.get(key2);
    }

    @Override
    public int getOrDefault(KType key2, int defaultValue) {
        return this.delegate.getOrDefault(key2, defaultValue);
    }

    @Override
    public int put(KType key2, int value) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int putAll(ObjectIntAssociativeContainer<? extends KType> container) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ObjectIntCursor<? extends KType>> iterable) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int putOrAdd(KType key2, int putValue, int incrementValue) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int addTo(KType key2, int additionValue) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int remove(KType key2) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int indexOf(KType key2) {
        return this.delegate.indexOf(key2);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public int indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public int indexReplace(int index, int newValue) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, KType key2, int value) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public int indexRemove(int index) {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationObjectIntHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectIntCursor<KType>> {
        private final ObjectIntCursor<KType> cursor = new ObjectIntCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ObjectIntCursor<KType> fetch() {
            if (this.index < SortedIterationObjectIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectIntHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationObjectIntHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationObjectIntHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ObjectIntCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final SortedIterationObjectIntHashMap<KType> owner;

        private KeysContainer() {
            this.owner = SortedIterationObjectIntHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectIntHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            throw SortedIterationObjectIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(KType e) {
            throw SortedIterationObjectIntHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private final SortedIterationObjectIntHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = SortedIterationObjectIntHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(int value) {
            for (ObjectIntCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(int e) {
            throw SortedIterationObjectIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw SortedIterationObjectIntHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectIntHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectIntHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected IntCursor fetch() {
            if (this.index < SortedIterationObjectIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectIntHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectIntHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.index < SortedIterationObjectIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectIntHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectIntHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

