/*
 * Decompiled with CFR 0.152.
 */
package com.goide.ide;

import com.goide.ide.GoSurveyPromoterConfig;
import com.intellij.ide.util.PropertiesComponent;
import java.time.Duration;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a \u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0007\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0003H\u0002\u001a\b\u0010\u001b\u001a\u00020\u0016H\u0002\u001a\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00012\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0007\u001a\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"ACCEPTED_PROPERTY", "", "END_DATE", "Ljava/util/Calendar;", "IDLE_TIMEOUT_SECONDS", "", "LAST_DATE_POSTPONED_PROPERTY", "LAST_DATE_SELECTED_PROPERTY", "REJECTED_PROPERTY", "REMIND_ME_LATER_SECONDS", "", "SELECTED_PROPERTY", "SELECTION_PROBABILITY", "START_DATE", "date", "year", "month", "day", "getCalendarProperty", "propertyName", "getPromptDelayInSeconds", "config", "Lcom/goide/ide/GoSurveyPromoterConfig;", "todayDate", "isInStartEndRange", "", "now", "loadConfig", "setCalendarProperty", "", "value", "shouldPrompt", "storeConfig", "intellij.go.ide"})
@SourceDebugExtension(value={"SMAP\nGoSurveyPromoterStartupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoSurveyPromoterStartupActivity.kt\ncom/goide/ide/GoSurveyPromoterStartupActivityKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
public final class GoSurveyPromoterStartupActivityKt {
    @NotNull
    private static final Calendar START_DATE = GoSurveyPromoterStartupActivityKt.date(2024, 1, 23);
    @NotNull
    private static final Calendar END_DATE = GoSurveyPromoterStartupActivityKt.date(2024, 2, 11);
    private static final int SELECTION_PROBABILITY = 10;
    private static final int IDLE_TIMEOUT_SECONDS = 60;
    private static final long REMIND_ME_LATER_SECONDS = 86400L;
    @NotNull
    private static final String LAST_DATE_SELECTED_PROPERTY = "go.developer.survey.date.selected";
    @NotNull
    private static final String SELECTED_PROPERTY = "go.developer.survey.selected";
    @NotNull
    private static final String ACCEPTED_PROPERTY = "go.developer.survey.accepted";
    @NotNull
    private static final String REJECTED_PROPERTY = "go.developer.survey.rejected";
    @NotNull
    private static final String LAST_DATE_POSTPONED_PROPERTY = "go.developer.survey.date.postponed";

    @VisibleForTesting
    public static final boolean shouldPrompt(@NotNull GoSurveyPromoterConfig config, @NotNull Calendar todayDate) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)todayDate, (String)"todayDate");
        if (!GoSurveyPromoterStartupActivityKt.isInStartEndRange(config, todayDate)) {
            return false;
        }
        if (config.getLastDateSelectedForSurvey() != null) {
            Calendar calendar = config.getLastDateSelectedForSurvey();
            Intrinsics.checkNotNull((Object)calendar);
            if (!GoSurveyPromoterStartupActivityKt.isInStartEndRange(config, calendar)) {
                config.setLastDateSelectedForSurvey(null);
                config.setSelectedForSurvey(false);
                config.setHasAccepted(false);
                config.setHasRejected(false);
                config.setLastDatePostponed(null);
            }
        }
        if (config.getLastDateSelectedForSurvey() == null) {
            config.setSelectedForSurvey(RangesKt.random((IntRange)new IntRange(0, 99), (Random)((Random)Random.Default)) < config.getSelectionProbability());
            config.setLastDateSelectedForSurvey(todayDate);
        }
        return config.isSelectedForSurvey() && !config.getHasAccepted() && !config.getHasRejected();
    }

    private static final long getPromptDelayInSeconds(GoSurveyPromoterConfig config, Calendar todayDate) {
        if (config.getLastDatePostponed() == null) {
            return 0L;
        }
        Calendar calendar = config.getLastDatePostponed();
        Intrinsics.checkNotNull((Object)calendar);
        Duration timePassed = Duration.between(calendar.toInstant(), todayDate.toInstant());
        return Math.max(config.getRemindMeLaterSeconds() - timePassed.getSeconds(), 0L);
    }

    private static final boolean isInStartEndRange(GoSurveyPromoterConfig config, Calendar now) {
        return !now.before(config.getStartDate()) && !now.after(config.getEndDate());
    }

    private static final GoSurveyPromoterConfig loadConfig() {
        return new GoSurveyPromoterConfig(null, null, 0, 0, 0L, GoSurveyPromoterStartupActivityKt.getCalendarProperty(LAST_DATE_SELECTED_PROPERTY), PropertiesComponent.getInstance().getBoolean(SELECTED_PROPERTY, false), PropertiesComponent.getInstance().getBoolean(ACCEPTED_PROPERTY, false), PropertiesComponent.getInstance().getBoolean(REJECTED_PROPERTY, false), GoSurveyPromoterStartupActivityKt.getCalendarProperty(LAST_DATE_POSTPONED_PROPERTY), 31, null);
    }

    private static final void storeConfig(GoSurveyPromoterConfig config) {
        GoSurveyPromoterStartupActivityKt.setCalendarProperty(LAST_DATE_SELECTED_PROPERTY, config.getLastDateSelectedForSurvey());
        PropertiesComponent.getInstance().setValue(SELECTED_PROPERTY, config.isSelectedForSurvey(), false);
        PropertiesComponent.getInstance().setValue(ACCEPTED_PROPERTY, config.getHasAccepted(), false);
        PropertiesComponent.getInstance().setValue(REJECTED_PROPERTY, config.getHasRejected(), false);
        GoSurveyPromoterStartupActivityKt.setCalendarProperty(LAST_DATE_POSTPONED_PROPERTY, config.getLastDatePostponed());
    }

    @VisibleForTesting
    @NotNull
    public static final Calendar date(int year, int month, int day) {
        Calendar calendar;
        Calendar $this$date_u24lambda_u240 = calendar = Calendar.getInstance();
        boolean bl = false;
        $this$date_u24lambda_u240.set(year, month - 1, day, 0, 0);
        Calendar calendar2 = calendar;
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"apply(...)");
        return calendar2;
    }

    private static final Calendar getCalendarProperty(String propertyName) {
        Calendar calendar;
        long dateMillis = PropertiesComponent.getInstance().getLong(propertyName, 0L);
        if (dateMillis == 0L) {
            return null;
        }
        Calendar $this$getCalendarProperty_u24lambda_u241 = calendar = Calendar.getInstance();
        boolean bl = false;
        $this$getCalendarProperty_u24lambda_u241.setTimeInMillis(dateMillis);
        return calendar;
    }

    private static final void setCalendarProperty(String propertyName, Calendar value) {
        Object object = value;
        if (object == null || (object = Long.valueOf(((Calendar)object).getTimeInMillis()).toString()) == null) {
            object = "";
        }
        Object stringValue = object;
        PropertiesComponent.getInstance().setValue(propertyName, (String)stringValue, "");
    }

    public static final /* synthetic */ GoSurveyPromoterConfig access$loadConfig() {
        return GoSurveyPromoterStartupActivityKt.loadConfig();
    }

    public static final /* synthetic */ void access$storeConfig(GoSurveyPromoterConfig config) {
        GoSurveyPromoterStartupActivityKt.storeConfig(config);
    }

    public static final /* synthetic */ long access$getPromptDelayInSeconds(GoSurveyPromoterConfig config, Calendar todayDate) {
        return GoSurveyPromoterStartupActivityKt.getPromptDelayInSeconds(config, todayDate);
    }

    public static final /* synthetic */ Calendar access$getSTART_DATE$p() {
        return START_DATE;
    }

    public static final /* synthetic */ Calendar access$getEND_DATE$p() {
        return END_DATE;
    }
}

