/*
 * Decompiled with CFR 0.152.
 */
package com.goide.ide;

import com.goide.i18n.GoBundle;
import com.goide.ide.GoSurveyPromoterConfig;
import com.goide.ide.GoSurveyPromoterStartupActivity;
import com.goide.ide.GoSurveyPromoterStartupActivityKt;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdleTracker;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/goide/ide/GoSurveyPromoterStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "promote", "showNotification", "config", "Lcom/goide/ide/GoSurveyPromoterConfig;", "intellij.go.ide"})
public final class GoSurveyPromoterStartupActivity
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        this.promote(project);
        return Unit.INSTANCE;
    }

    private final void promote(Project project) {
        if (project.isDisposed()) {
            return;
        }
        GoSurveyPromoterConfig config = GoSurveyPromoterStartupActivityKt.access$loadConfig();
        Calendar todayDate = Calendar.getInstance();
        Intrinsics.checkNotNull((Object)todayDate);
        boolean prompt = GoSurveyPromoterStartupActivityKt.shouldPrompt(config, todayDate);
        GoSurveyPromoterStartupActivityKt.access$storeConfig(config);
        if (!prompt) {
            return;
        }
        long promptDelayInSeconds = GoSurveyPromoterStartupActivityKt.access$getPromptDelayInSeconds(config, todayDate);
        if (promptDelayInSeconds > 0L) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> GoSurveyPromoterStartupActivity.promote$lambda$0(this, project), promptDelayInSeconds, TimeUnit.SECONDS);
            return;
        }
        config.setLastDatePostponed(null);
        GoSurveyPromoterStartupActivityKt.access$storeConfig(config);
        Ref.ObjectRef idleListenerToken = new Ref.ObjectRef();
        idleListenerToken.element = IdleTracker.Companion.getInstance().addIdleListener(config.getIdleTimeoutSeconds() * 1000, () -> GoSurveyPromoterStartupActivity.promote$lambda$1(this, project, config, idleListenerToken));
    }

    private final void showNotification(Project project, GoSurveyPromoterConfig config) {
        if (project.isDisposed()) {
            return;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Go Developer Survey Promoter");
        String string = GoBundle.message((String)"go.survey.promoter.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new Object[]{new SimpleDateFormat("dd MMM yyyy").format(config.getEndDate().getTime())};
        String string2 = GoBundle.message((String)"go.survey.promoter.content", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Notification notification = notificationGroup.createNotification(string, string2, NotificationType.INFORMATION);
        notification.addAction((AnAction)NotificationAction.create((String)GoBundle.message((String)"go.survey.promoter.action.yes", (Object[])new Object[0]), arg_0 -> GoSurveyPromoterStartupActivity.showNotification$lambda$2((Function1)new Function1<AnActionEvent, Unit>(config, notification){
            final /* synthetic */ GoSurveyPromoterConfig $config;
            final /* synthetic */ Notification $notification;
            {
                this.$config = $config;
                this.$notification = $notification;
                super(1);
            }

            public final void invoke(AnActionEvent anActionEvent) {
                this.$config.setHasAccepted(true);
                BrowserUtil.browse((String)"https://google.qualtrics.com/jfe/form/SV_083SVAUCji98YeO?s=j");
                this.$notification.expire();
            }
        }, arg_0))).addAction((AnAction)NotificationAction.create((String)GoBundle.message((String)"go.survey.promoter.action.later", (Object[])new Object[0]), arg_0 -> GoSurveyPromoterStartupActivity.showNotification$lambda$3((Function1)new Function1<AnActionEvent, Unit>(config, notification, this, project){
            final /* synthetic */ GoSurveyPromoterConfig $config;
            final /* synthetic */ Notification $notification;
            final /* synthetic */ GoSurveyPromoterStartupActivity this$0;
            final /* synthetic */ Project $project;
            {
                this.$config = $config;
                this.$notification = $notification;
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final void invoke(AnActionEvent anActionEvent) {
                this.$config.setLastDatePostponed(Calendar.getInstance());
                AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> showNotification.2.invoke$lambda$0(this.this$0, this.$project), this.$config.getRemindMeLaterSeconds(), TimeUnit.SECONDS);
                this.$notification.expire();
            }

            private static final void invoke$lambda$0(GoSurveyPromoterStartupActivity this$0, Project $project) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                GoSurveyPromoterStartupActivity.access$promote(this$0, $project);
            }
        }, arg_0))).addAction((AnAction)NotificationAction.create((String)GoBundle.message((String)"go.survey.promoter.action.never", (Object[])new Object[0]), arg_0 -> GoSurveyPromoterStartupActivity.showNotification$lambda$4((Function1)new Function1<AnActionEvent, Unit>(config, notification){
            final /* synthetic */ GoSurveyPromoterConfig $config;
            final /* synthetic */ Notification $notification;
            {
                this.$config = $config;
                this.$notification = $notification;
                super(1);
            }

            public final void invoke(AnActionEvent anActionEvent) {
                this.$config.setHasRejected(true);
                this.$notification.expire();
            }
        }, arg_0))).whenExpired(() -> GoSurveyPromoterStartupActivity.showNotification$lambda$5(config));
        notification.notify(project);
    }

    private static final void promote$lambda$0(GoSurveyPromoterStartupActivity this$0, Project $project) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        this$0.promote($project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void promote$lambda$1(GoSurveyPromoterStartupActivity this$0, Project $project, GoSurveyPromoterConfig $config, Ref.ObjectRef $idleListenerToken) {
        AccessToken accessToken;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
                Intrinsics.checkNotNullParameter((Object)$idleListenerToken, (String)"$idleListenerToken");
                try {
                    this$0.showNotification($project, $config);
                    if ($idleListenerToken.element != null) break block4;
                }
                catch (Throwable throwable) {
                    AccessToken accessToken2;
                    if ($idleListenerToken.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"idleListenerToken");
                        accessToken2 = null;
                    } else {
                        accessToken2 = (AccessToken)$idleListenerToken.element;
                    }
                    accessToken2.finish();
                    throw throwable;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"idleListenerToken");
                accessToken = null;
                break block5;
            }
            accessToken = (AccessToken)$idleListenerToken.element;
        }
        accessToken.finish();
    }

    private static final void showNotification$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void showNotification$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void showNotification$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void showNotification$lambda$5(GoSurveyPromoterConfig $config) {
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        GoSurveyPromoterStartupActivityKt.access$storeConfig($config);
    }

    public static final /* synthetic */ void access$promote(GoSurveyPromoterStartupActivity $this, Project project) {
        $this.promote(project);
    }
}

