/*
 * Decompiled with CFR 0.152.
 */
package com.goide.ide;

import com.goide.go.GoGotoSuperHandler;
import com.goide.go.GoInheritorsSearch;
import com.intellij.codeInsight.actions.LastRunReformatCodeOptionsProvider;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.SystemProperties;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

final class GoIdeInitialConfigurator
implements StartupActivity.DumbAware {
    private static final String INITIAL_CFG_PROPERTY = "go.init.cfg.2";
    private static final String INITIAL_CFG_SET_FILE_TYPE_FOR_GO_MOD = "go.init.mod.file.type";
    private static final String INITIAL_CFG_LINE_MARKERS_PROPERTY = "go.init.cfg.line.markers";
    private static final String DEFAULT_REFORMAT_OPTIONS_SET = "go.optimizeImportsByDefault";
    private static final String FIRST_RUN_TIME_PROPERTY = "go.first.run.time";
    private static final String TIPS_WERE_ENABLED_ONCE_PROPERTY = "go.tips.were.enabled.once";
    private static final String SUGGEST_ALL_RC_WAS_ENABLED_ONCE_PROPERTY = "go.suggest.all.rc.was.enabled.once";
    private static final String TERMINAL_SHELL_COMMAND_HANDLING_WAS_DISABLED_ONCE_PROPERTY = "terminal.shell.command.handling.was.disabled.once";

    GoIdeInitialConfigurator() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            throw ExtensionNotApplicableException.create();
        }
    }

    public void runActivity(@NotNull Project project) {
        PropertiesComponent propertiesComponent;
        long days;
        if (project == null) {
            GoIdeInitialConfigurator.$$$reportNull$$$0(0);
        }
        if (!project.isDefault() && FileChooserUtil.getLastOpenedFile((Project)project) == null) {
            FileChooserUtil.setLastOpenedFile((Project)project, (Path)Paths.get(SystemProperties.getUserHome(), new String[0]));
        }
        if ((days = GoIdeInitialConfigurator.daysSinceFirstRun(propertiesComponent = PropertiesComponent.getInstance())) > 2L) {
            RunOnceUtil.runOnceForApp((String)TIPS_WERE_ENABLED_ONCE_PROPERTY, () -> {
                GeneralSettings general = GeneralSettings.getInstance();
                general.setShowTipsOnStartup(true);
            });
        }
        RunOnceUtil.runOnceForApp((String)SUGGEST_ALL_RC_WAS_ENABLED_ONCE_PROPERTY, () -> Registry.get((String)"suggest.all.run.configurations.from.context").setValue(true));
        if (propertiesComponent.getBoolean(INITIAL_CFG_SET_FILE_TYPE_FOR_GO_MOD)) {
            ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> {
                propertiesComponent.unsetValue(INITIAL_CFG_SET_FILE_TYPE_FOR_GO_MOD);
                FileTypeManager.getInstance().removeAssociation((FileType)FileTypes.PLAIN_TEXT, (FileNameMatcher)new ExactFileNameMatcher("go.mod"));
            }));
        }
        RunOnceUtil.runOnceForApp((String)INITIAL_CFG_PROPERTY, () -> {
            UISettings ui = UISettings.getInstance();
            ui.setShowDirectoryForNonUniqueFilenames(true);
            GeneralSettings general = GeneralSettings.getInstance();
            general.setShowTipsOnStartup(false);
            general.setConfirmExit(false);
        });
        RunOnceUtil.runOnceForApp((String)INITIAL_CFG_LINE_MARKERS_PROPERTY, () -> {
            LineMarkerSettings lms = LineMarkerSettings.getSettings();
            lms.setEnabled((GutterIconDescriptor)new GoInheritorsSearch.GoInheritorMarkerProvider(), true);
            lms.setEnabled((GutterIconDescriptor)new GoGotoSuperHandler.GoSuperMarkerProvider(), true);
        });
        RunOnceUtil.runOnceForApp((String)DEFAULT_REFORMAT_OPTIONS_SET, () -> {
            LastRunReformatCodeOptionsProvider reformatCodeOptions = new LastRunReformatCodeOptionsProvider(propertiesComponent);
            reformatCodeOptions.saveOptimizeImportsState(true);
            reformatCodeOptions.saveCodeCleanupState(true);
        });
        RunOnceUtil.runOnceForApp((String)TERMINAL_SHELL_COMMAND_HANDLING_WAS_DISABLED_ONCE_PROPERTY, () -> Experiments.getInstance().setFeatureEnabled("terminal.shell.command.handling", false));
    }

    private static long daysSinceFirstRun(@NotNull PropertiesComponent propertiesComponent) {
        if (propertiesComponent == null) {
            GoIdeInitialConfigurator.$$$reportNull$$$0(1);
        }
        long firstRunTime = propertiesComponent.getLong(FIRST_RUN_TIME_PROPERTY, System.currentTimeMillis());
        if (!propertiesComponent.isValueSet(FIRST_RUN_TIME_PROPERTY)) {
            propertiesComponent.setValue(FIRST_RUN_TIME_PROPERTY, Long.toString(firstRunTime));
        }
        return TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis() - firstRunTime);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesComponent";
                break;
            }
        }
        objectArray2[1] = "com/goide/ide/GoIdeInitialConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "daysSinceFirstRun";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

